/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.tender.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import se.swedsoft.bookkeeping.calc.math.SSProductMath;
import se.swedsoft.bookkeeping.calc.math.SSTenderMath;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSTender;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.company.panel.SSAdressPanel;
import se.swedsoft.bookkeeping.gui.company.panel.SSDefaultAccountPanel;
import se.swedsoft.bookkeeping.gui.customer.util.SSCustomerTableModel;
import se.swedsoft.bookkeeping.gui.invoice.util.SSInvoiceRowTableModel;
import se.swedsoft.bookkeeping.gui.tender.dialog.SSExchangeRateDialog;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonGroup;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.SSInputVerifier;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSBigDecimalTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInformationDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSCurrencyTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSDeliveryTermTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSDeliveryWayTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSPaymentTermTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSDeleteAction;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSTraversalAction;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSTaxCodeCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSTaxCodeCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;

public class SSTenderPanel {
    private SSTender iTender;
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private JFormattedTextField iNumber;
    private SSDateChooser iDate;
    private SSDateChooser iExpires;
    private SSTableComboBox<SSCustomer> iCustomer;
    private JTextField iCustomerName;
    private JCheckBox iTaxFree;
    private SSBigDecimalTextField iDelayInterest;
    private SSAdressPanel iDeliveryAddress;
    private SSAdressPanel iInvoiceAddress;
    private JTextArea iText;
    private JTextField iYourContactPerson;
    private JTextField iOurContactPerson;
    private SSBigDecimalTextField iTaxRate1;
    private SSBigDecimalTextField iTaxRate2;
    private SSBigDecimalTextField iTaxRate3;
    private JCheckBox iEuSaleCommodity;
    private JCheckBox iEuSaleYhirdPartCommodity;
    private SSEditableTableComboBox<SSDeliveryWay> iDeliveryWay;
    private SSEditableTableComboBox<SSDeliveryTerm> iDeliveryTerm;
    private SSEditableTableComboBox<SSPaymentTerm> iPaymentTerm;
    private SSEditableTableComboBox<SSCurrency> iCurrency;
    private SSTable iTable;
    private SSDefaultAccountPanel iDefaultAccounts;
    private SSButton iCurrencyCalculatorButton;
    private SSBigDecimalTextField iNetSum;
    private SSBigDecimalTextField iTaxSum1;
    private SSBigDecimalTextField iTaxSum2;
    private SSBigDecimalTextField iTaxSum3;
    private SSBigDecimalTextField iRoundingSum;
    private SSBigDecimalTextField iTotalSum;
    private JLabel iTaxLabel1;
    private JLabel iTaxLabel2;
    private JLabel iTaxLabel3;
    private JCheckBox iSavecustomerandproducts;
    private SSInvoiceRowTableModel iModel;
    private SSInputVerifier iInputVerifier;
    private JCheckBox iUseInvoiceForDelivery;
    private SSBigDecimalTextField iCurrencyRate;

    public SSTenderPanel(final SSDialog iOwner) {
        this.$$$setupUI$$$();
        this.iNumber.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("0"))));
        this.iNumber.setHorizontalAlignment(4);
        this.iTable.setColorReadOnly(true);
        this.iTable.setColumnSortingEnabled(false);
        this.iTable.setSingleSelect();
        this.iModel = new SSInvoiceRowTableModel();
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_PRODUCT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_DESCRIPTION, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_UNITPRICE, true);
        this.iModel.addColumn(new ContributionRateColumn(), false);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_QUANTITY, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_UNIT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_DISCOUNT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_SUM, false);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_TAX, true);
        this.iModel.setupTable(this.iTable);
        this.iModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SSTenderPanel.this.updateSumFields();
            }
        });
        this.iUseInvoiceForDelivery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTenderPanel.this.iDeliveryAddress.setEnabled(!SSTenderPanel.this.iUseInvoiceForDelivery.isSelected());
                if (!SSTenderPanel.this.iUseInvoiceForDelivery.isSelected()) {
                    SSTenderPanel.this.iDeliveryAddress.setFocus();
                } else {
                    SSTenderPanel.this.iInvoiceAddress.setFocus();
                }
            }
        });
        this.iCustomer.setModel(SSCustomerTableModel.getDropDownModel());
        this.iCustomer.setSearchColumns(0, 1);
        this.iCustomer.setAllowCustomValues(true);
        this.iCustomer.addSelectionListener(new SSSelectionListener<SSCustomer>(){

            @Override
            public void selected(SSCustomer selected) {
                if (selected != null) {
                    SSTenderPanel.this.iModel.setCustomer(selected);
                    SSTenderPanel.this.iTender.setCustomer(selected);
                    SSTenderPanel.this.iTender.setCurrencyRate(selected.getInvoiceCurrency() == null ? new BigDecimal(1) : selected.getInvoiceCurrency().getExchangeRate());
                    if (selected.getDiscount() != null) {
                        for (SSSaleRow iRow : SSTenderPanel.this.iModel.getObjects()) {
                            iRow.setDiscount(selected.getDiscount().doubleValue() == new BigDecimal(0).doubleValue() ? null : selected.getDiscount());
                        }
                    }
                    SSTenderPanel.this.setTender(SSTenderPanel.this.iTender);
                }
            }
        });
        new SSTraversalAction(this.iTable){

            @Override
            protected Point doTraversal(Point iPosition) {
                if (iPosition.x <= 4) {
                    ++iPosition.x;
                }
                if (iPosition.x == 5) {
                    ++iPosition.y;
                    iPosition.x = 0;
                    if (iPosition.y == SSTenderPanel.this.iModel.getRowCount()) {
                        SSTenderPanel.this.iButtonPanel.getOkButton().requestFocus();
                        return null;
                    }
                }
                return iPosition;
            }
        };
        new SSDeleteAction(this.iTable){

            @Override
            protected Point doDelete(Point iPosition) {
                SSSaleRow iSelected = (SSSaleRow)SSTenderPanel.this.iModel.getSelectedRow(SSTenderPanel.this.iTable);
                if (iSelected != null) {
                    SSQueryDialog dialog = new SSQueryDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "tenderframe.deleterow", iSelected.toString());
                    if (dialog.getResponce() != 0) {
                        return null;
                    }
                    SSTenderPanel.this.iModel.deleteRow(iSelected);
                }
                return iPosition;
            }
        };
        this.iCurrency.getComboBox().setModel(SSCurrencyTableModel.getDropDownModel());
        this.iCurrency.getComboBox().setSearchColumns(0);
        this.iCurrency.setEditingFactory(SSCurrencyTableModel.getEditingFactory(iOwner));
        this.iCurrency.getComboBox().addSelectionListener(new SSSelectionListener<SSCurrency>(){

            @Override
            public void selected(SSCurrency selected) {
                if (selected != null) {
                    SSTenderPanel.this.iCurrencyRate.setValue(selected.getExchangeRate());
                }
                SSTenderPanel.this.iModel.fireTableDataChanged();
            }
        });
        this.iDeliveryWay.getComboBox().setModel(SSDeliveryWayTableModel.getDropDownModel());
        this.iDeliveryWay.getComboBox().setSearchColumns(0);
        this.iDeliveryWay.setEditingFactory(SSDeliveryWayTableModel.getEditingFactory(iOwner));
        this.iDeliveryTerm.getComboBox().setModel(SSDeliveryTermTableModel.getDropDownModel());
        this.iDeliveryTerm.getComboBox().setSearchColumns(0);
        this.iDeliveryTerm.setEditingFactory(SSDeliveryTermTableModel.getEditingFactory(iOwner));
        this.iPaymentTerm.getComboBox().setModel(SSPaymentTermTableModel.getDropDownModel());
        this.iPaymentTerm.getComboBox().setSearchColumns(0);
        this.iPaymentTerm.setEditingFactory(SSPaymentTermTableModel.getEditingFactory(iOwner));
        this.iTaxRate1.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSTenderPanel.this.iTender.setTaxRate1(SSTenderPanel.this.iTaxRate1.getValue());
                SSTenderPanel.this.updateTaxTexts();
                SSTenderPanel.this.updateSumFields();
            }
        });
        this.iTaxRate2.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSTenderPanel.this.iTender.setTaxRate2(SSTenderPanel.this.iTaxRate2.getValue());
                SSTenderPanel.this.updateTaxTexts();
                SSTenderPanel.this.updateSumFields();
            }
        });
        this.iTaxRate3.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSTenderPanel.this.iTender.setTaxRate3(SSTenderPanel.this.iTaxRate3.getValue());
                SSTenderPanel.this.updateTaxTexts();
                SSTenderPanel.this.updateSumFields();
            }
        });
        this.iTaxFree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTenderPanel.this.iTender.setTaxFree(SSTenderPanel.this.iTaxFree.isSelected());
                SSTenderPanel.this.updateSumFields();
            }
        });
        this.iCurrencyCalculatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCurrency iCompanyCurrency = SSDB.getInstance().getCurrentCompany().getCurrency();
                SSCurrency iCurrentCurrency = (SSCurrency)SSTenderPanel.this.iCurrency.getSelected();
                if (iCompanyCurrency == null || iCurrentCurrency == null) {
                    new SSInformationDialog(iOwner, "tenderframe.selectcurrency");
                    return;
                }
                SSExchangeRateDialog.showDialog(iOwner, SSTenderPanel.this.iTender, iCompanyCurrency, iCurrentCurrency, SSTenderPanel.this.iModel);
            }
        });
        SSButtonGroup iGroup = new SSButtonGroup(true);
        iGroup.add(this.iEuSaleCommodity);
        iGroup.add(this.iEuSaleYhirdPartCommodity);
        this.iInputVerifier = new SSInputVerifier();
        this.iInputVerifier.add(this.iCustomer);
        this.iInputVerifier.add(this.iCustomerName);
        this.iInputVerifier.addListener(new SSInputVerifier.SSVerifierListener(){

            @Override
            public void updated(SSInputVerifier iVerifier, boolean iValid) {
                SSTenderPanel.this.iButtonPanel.getOkButton().setEnabled(iValid);
            }
        });
        this.iSavecustomerandproducts.setSelected(true);
        this.addKeyListeners();
    }

    public boolean isValid() {
        return this.iInputVerifier.isValid();
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener pActionListener) {
        this.iButtonPanel.addOkActionListener(pActionListener);
    }

    public void addCancelAction(ActionListener pActionListener) {
        this.iButtonPanel.addCancelActionListener(pActionListener);
    }

    public void setTender(SSTender pTender) {
        this.iTender = pTender;
        this.iModel.setObjects(pTender.getRows());
        this.iNumber.setValue(this.iTender.getNumber());
        this.iDate.setDate(this.iTender.getDate());
        this.iExpires.setDate(this.iTender.getExpires());
        this.iCustomer.setText(this.iTender.getCustomerNr());
        this.iCustomerName.setText(this.iTender.getCustomerName());
        this.iOurContactPerson.setText(this.iTender.getOurContactPerson());
        this.iYourContactPerson.setText(this.iTender.getYourContactPerson());
        this.iDelayInterest.setValue(this.iTender.getDelayInterest());
        this.iCurrency.setSelected(this.iTender.getCurrency());
        this.iCurrencyRate.setValue(this.iTender.getCurrencyRate());
        this.iPaymentTerm.setSelected(this.iTender.getPaymentTerm());
        this.iDeliveryTerm.setSelected(this.iTender.getDeliveryTerm());
        this.iDeliveryWay.setSelected(this.iTender.getDeliveryWay());
        for (SSCustomer pCustomer : SSDB.getInstance().getCustomers()) {
            if (!pCustomer.getNumber().equals(this.iCustomer.getText())) continue;
            this.iModel.setCustomer(pCustomer);
        }
        this.iTaxFree.setSelected(this.iTender.getTaxFree());
        this.iTaxRate1.setValue(this.iTender.getTaxRate1());
        this.iTaxRate2.setValue(this.iTender.getTaxRate2());
        this.iTaxRate3.setValue(this.iTender.getTaxRate3());
        this.iEuSaleCommodity.setSelected(this.iTender.getEuSaleCommodity());
        this.iEuSaleYhirdPartCommodity.setSelected(this.iTender.getEuSaleThirdPartCommodity());
        this.iText.setText(this.iTender.getText());
        this.iInvoiceAddress.setAdress(this.iTender.getInvoiceAddress());
        this.iDeliveryAddress.setAdress(this.iTender.getDeliveryAddress());
        this.iDefaultAccounts.setDefaultAccounts(this.iTender.getDefaultAccounts());
        this.updateSumFields();
        this.updateTaxTexts();
        this.iUseInvoiceForDelivery.setSelected(this.iTender.getDeliveryAddress().equals(this.iTender.getInvoiceAddress()));
        this.iDeliveryAddress.setEnabled(!this.iUseInvoiceForDelivery.isSelected());
        this.iInputVerifier.update();
    }

    public SSTender getTender() {
        this.iTender.setDate(this.iDate.getDate());
        this.iTender.setExpires(this.iExpires.getDate());
        this.iTender.setCustomerNr(this.iCustomer.getText());
        this.iTender.setCustomerName(this.iCustomerName.getText());
        this.iTender.setOurContactPerson(this.iOurContactPerson.getText());
        this.iTender.setYourContactPerson(this.iYourContactPerson.getText());
        this.iTender.setDelayInterest(this.iDelayInterest.getValue());
        this.iTender.setCurrency(this.iCurrency.getSelected());
        this.iTender.setCurrencyRate(this.iCurrencyRate.getValue());
        this.iTender.setPaymentTerm(this.iPaymentTerm.getSelected());
        this.iTender.setDeliveryTerm(this.iDeliveryTerm.getSelected());
        this.iTender.setDeliveryWay(this.iDeliveryWay.getSelected());
        this.iTender.setEuSaleCommodity(this.iEuSaleCommodity.isSelected());
        this.iTender.setEuSaleYhirdPartCommodity(this.iEuSaleYhirdPartCommodity.isSelected());
        this.iTender.setTaxFree(this.iTaxFree.isSelected());
        this.iTender.setTaxRate1(this.iTaxRate1.getValue());
        this.iTender.setTaxRate2(this.iTaxRate2.getValue());
        this.iTender.setTaxRate3(this.iTaxRate3.getValue());
        this.iTender.setText(this.iText.getText());
        this.iTender.setDefaultAccounts(this.iDefaultAccounts.getDefaultAccounts());
        this.iTender.setInvoiceAddress(this.iInvoiceAddress.getAddress());
        if (this.iUseInvoiceForDelivery.isSelected()) {
            this.iTender.setDeliveryAddress(this.iInvoiceAddress.getAddressCloned());
        } else {
            this.iTender.setDeliveryAddress(this.iDeliveryAddress.getAddress());
        }
        return this.iTender;
    }

    public boolean doSaveCustomerAndProducts() {
        return this.iSavecustomerandproducts.isSelected();
    }

    private void updateTaxTexts() {
        SSTaxCodeCellEditor iEditor = new SSTaxCodeCellEditor();
        SSTaxCodeCellRenderer iRenderer = new SSTaxCodeCellRenderer();
        String iTaxText = SSBundle.getBundle().getString("tenderframe.tax");
        BigDecimal iTaxRate1 = this.iTaxRate1.getValue() == null ? new BigDecimal(25) : this.iTaxRate1.getValue();
        BigDecimal iTaxRate2 = this.iTaxRate2.getValue() == null ? new BigDecimal(12) : this.iTaxRate2.getValue();
        BigDecimal iTaxRate3 = this.iTaxRate3.getValue() == null ? new BigDecimal(6) : this.iTaxRate3.getValue();
        iEditor.setValue(SSTaxCode.TAXRATE_0, new BigDecimal(0));
        iEditor.setValue(SSTaxCode.TAXRATE_1, iTaxRate1);
        iEditor.setValue(SSTaxCode.TAXRATE_2, iTaxRate2);
        iEditor.setValue(SSTaxCode.TAXRATE_3, iTaxRate3);
        iRenderer.setValue(SSTaxCode.TAXRATE_0, new BigDecimal(0));
        iRenderer.setValue(SSTaxCode.TAXRATE_1, iTaxRate1);
        iRenderer.setValue(SSTaxCode.TAXRATE_2, iTaxRate2);
        iRenderer.setValue(SSTaxCode.TAXRATE_3, iTaxRate3);
        NumberFormat iFormat = NumberFormat.getNumberInstance();
        this.iTaxLabel1.setText(iTaxText + ' ' + iFormat.format(iTaxRate1) + '%');
        this.iTaxLabel2.setText(iTaxText + ' ' + iFormat.format(iTaxRate2) + '%');
        this.iTaxLabel3.setText(iTaxText + ' ' + iFormat.format(iTaxRate3) + '%');
        this.iTable.setDefaultEditor(SSTaxCode.class, iEditor);
        this.iTable.setDefaultRenderer(SSTaxCode.class, iRenderer);
        this.iModel.fireTableDataChanged();
    }

    private void updateSumFields() {
        BigDecimal iNetSum = SSTenderMath.getNetSum(this.iTender);
        Map<SSTaxCode, BigDecimal> iTaxSum = SSTenderMath.getTaxSum(this.iTender);
        BigDecimal iTotalSum = SSTenderMath.getTotalSum(this.iTender);
        BigDecimal iRounding = SSTenderMath.getRounding(this.iTender);
        this.iNetSum.setValue(iNetSum);
        this.iTaxSum1.setValue(iTaxSum.get(SSTaxCode.TAXRATE_1));
        this.iTaxSum2.setValue(iTaxSum.get(SSTaxCode.TAXRATE_2));
        this.iTaxSum3.setValue(iTaxSum.get(SSTaxCode.TAXRATE_3));
        if (!SSDB.getInstance().getCurrentCompany().isRoundingOff()) {
            this.iRoundingSum.setValue(iRounding);
        }
        this.iTotalSum.setValue(iTotalSum);
    }

    public void setSavecustomerandproductsSelected(boolean iSelected) {
        this.iSavecustomerandproducts.setSelected(iSelected);
    }

    public void dispose() {
        PropertyChangeListener[] iPropertyChangeListeners;
        this.iModel.setCustomer(null);
        this.iPanel.removeAll();
        this.iPanel = null;
        this.iButtonPanel.dispose();
        this.iButtonPanel = null;
        this.iTable.dispose();
        this.iTable = null;
        this.iNumber.removeAll();
        this.iNumber = null;
        this.iDate.dispose();
        this.iDate = null;
        this.iExpires.dispose();
        this.iExpires = null;
        this.iCustomer.dispose();
        this.iCustomer = null;
        this.iCustomerName = null;
        this.iTaxFree = null;
        this.iDelayInterest = null;
        this.iDeliveryAddress = null;
        this.iInvoiceAddress = null;
        this.iText.removeAll();
        this.iText = null;
        this.iYourContactPerson.removeAll();
        this.iYourContactPerson = null;
        this.iOurContactPerson.removeAll();
        this.iOurContactPerson = null;
        for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners = this.iTaxRate1.getPropertyChangeListeners()) {
            this.iTaxRate1.removePropertyChangeListener(iPropertyChangeListener);
        }
        this.iTaxRate1.removeAll();
        this.iTaxRate1 = null;
        for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners = this.iTaxRate2.getPropertyChangeListeners()) {
            this.iTaxRate2.removePropertyChangeListener(iPropertyChangeListener);
        }
        this.iTaxRate2.removeAll();
        this.iTaxRate2 = null;
        for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners = this.iTaxRate3.getPropertyChangeListeners()) {
            this.iTaxRate3.removePropertyChangeListener(iPropertyChangeListener);
        }
        this.iTaxRate3.removeAll();
        this.iTaxRate3 = null;
        this.iEuSaleCommodity.removeAll();
        this.iEuSaleCommodity = null;
        this.iEuSaleYhirdPartCommodity.removeAll();
        this.iEuSaleYhirdPartCommodity = null;
        this.iDeliveryWay.dispose();
        this.iDeliveryWay = null;
        this.iDeliveryTerm.dispose();
        this.iDeliveryTerm = null;
        this.iPaymentTerm.dispose();
        this.iPaymentTerm = null;
        this.iCurrency.dispose();
        this.iCurrency = null;
        this.iDefaultAccounts.dispose();
        this.iDefaultAccounts = null;
        this.iCurrencyCalculatorButton.dispose();
        this.iCurrencyCalculatorButton = null;
        this.iNetSum.removeAll();
        this.iNetSum = null;
        this.iTaxSum1.removeAll();
        this.iTaxSum1 = null;
        this.iTaxSum2.removeAll();
        this.iTaxSum2 = null;
        this.iTaxSum3.removeAll();
        this.iTaxSum3 = null;
        this.iRoundingSum.removeAll();
        this.iRoundingSum = null;
        this.iTotalSum.removeAll();
        this.iTotalSum = null;
        this.iTaxLabel1 = null;
        this.iTaxLabel2 = null;
        this.iTaxLabel3 = null;
        this.iSavecustomerandproducts = null;
        this.iModel = null;
        this.iInputVerifier = null;
        this.iUseInvoiceForDelivery = null;
        this.iCurrencyRate.removeAll();
        this.iCurrencyRate = null;
    }

    public void addKeyListeners() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SSTenderPanel.this.iCustomer.getComponent(0).requestFocusInWindow();
            }
        });
        this.iCustomer.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTenderPanel.this.iCustomerName.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCustomerName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTenderPanel.this.iOurContactPerson.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iOurContactPerson.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTenderPanel.this.iYourContactPerson.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iYourContactPerson.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTenderPanel.this.iDate.getEditor().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDate.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTenderPanel.this.iExpires.getEditor().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iExpires.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTenderPanel.this.iPaymentTerm.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPaymentTerm.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTenderPanel.this.iDeliveryTerm.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDeliveryTerm.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTenderPanel.this.iDeliveryWay.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDeliveryWay.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTenderPanel.this.iCurrency.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCurrency.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTenderPanel.this.iCurrencyRate.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCurrencyRate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTenderPanel.this.iTable.requestFocusInWindow();
                            SSTenderPanel.this.iTable.changeSelection(0, 0, false, false);
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getOkButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTenderPanel.this.iButtonPanel.getCancelButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getCancelButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTenderPanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iNumber.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SSTenderPanel.this.iCustomer.getComponent(0).requestFocusInWindow();
                    }
                });
            }
        });
        this.iInvoiceAddress.addKeyListeners();
        this.iDeliveryAddress.addKeyListeners();
        this.iUseInvoiceForDelivery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SSTenderPanel.this.iUseInvoiceForDelivery.isSelected()) {
                    SSTenderPanel.this.iDeliveryAddress.setFocus();
                } else {
                    SSTenderPanel.this.iInvoiceAddress.setFocus();
                }
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.tender.panel.SSTenderPanel");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iCurrency=").append(this.iCurrency);
        sb.append(", iCurrencyCalculatorButton=").append(this.iCurrencyCalculatorButton);
        sb.append(", iCurrencyRate=").append(this.iCurrencyRate);
        sb.append(", iCustomer=").append(this.iCustomer);
        sb.append(", iCustomerName=").append(this.iCustomerName);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iDefaultAccounts=").append(this.iDefaultAccounts);
        sb.append(", iDelayInterest=").append(this.iDelayInterest);
        sb.append(", iDeliveryAddress=").append(this.iDeliveryAddress);
        sb.append(", iDeliveryTerm=").append(this.iDeliveryTerm);
        sb.append(", iDeliveryWay=").append(this.iDeliveryWay);
        sb.append(", iEuSaleCommodity=").append(this.iEuSaleCommodity);
        sb.append(", iEuSaleYhirdPartCommodity=").append(this.iEuSaleYhirdPartCommodity);
        sb.append(", iExpires=").append(this.iExpires);
        sb.append(", iInputVerifier=").append(this.iInputVerifier);
        sb.append(", iInvoiceAddress=").append(this.iInvoiceAddress);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iNetSum=").append(this.iNetSum);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iOurContactPerson=").append(this.iOurContactPerson);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iPaymentTerm=").append(this.iPaymentTerm);
        sb.append(", iRoundingSum=").append(this.iRoundingSum);
        sb.append(", iSavecustomerandproducts=").append(this.iSavecustomerandproducts);
        sb.append(", iTable=").append(this.iTable);
        sb.append(", iTaxFree=").append(this.iTaxFree);
        sb.append(", iTaxLabel1=").append(this.iTaxLabel1);
        sb.append(", iTaxLabel2=").append(this.iTaxLabel2);
        sb.append(", iTaxLabel3=").append(this.iTaxLabel3);
        sb.append(", iTaxRate1=").append(this.iTaxRate1);
        sb.append(", iTaxRate2=").append(this.iTaxRate2);
        sb.append(", iTaxRate3=").append(this.iTaxRate3);
        sb.append(", iTaxSum1=").append(this.iTaxSum1);
        sb.append(", iTaxSum2=").append(this.iTaxSum2);
        sb.append(", iTaxSum3=").append(this.iTaxSum3);
        sb.append(", iTender=").append(this.iTender);
        sb.append(", iText=").append(this.iText);
        sb.append(", iTotalSum=").append(this.iTotalSum);
        sb.append(", iUseInvoiceForDelivery=").append(this.iUseInvoiceForDelivery);
        sb.append(", iYourContactPerson=").append(this.iYourContactPerson);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        JCheckBox jCheckBox;
        SSBigDecimalTextField sSBigDecimalTextField;
        SSBigDecimalTextField sSBigDecimalTextField2;
        SSBigDecimalTextField sSBigDecimalTextField3;
        SSDefaultAccountPanel sSDefaultAccountPanel;
        JCheckBox jCheckBox2;
        SSAdressPanel sSAdressPanel;
        SSBigDecimalTextField sSBigDecimalTextField4;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JTextArea jTextArea;
        SSAdressPanel sSAdressPanel2;
        JCheckBox jCheckBox5;
        SSBigDecimalTextField sSBigDecimalTextField5;
        SSDateChooser sSDateChooser;
        SSDateChooser sSDateChooser2;
        SSButton sSButton;
        JFormattedTextField jFormattedTextField;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        SSBigDecimalTextField sSBigDecimalTextField6;
        SSBigDecimalTextField sSBigDecimalTextField7;
        SSBigDecimalTextField sSBigDecimalTextField8;
        SSBigDecimalTextField sSBigDecimalTextField9;
        SSBigDecimalTextField sSBigDecimalTextField10;
        SSBigDecimalTextField sSBigDecimalTextField11;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        SSTable sSTable;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), 4, 2, false, false));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(5, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("tenderframe.panel.1"), null, jPanel2, null);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, new Dimension(-1, 120), null, null));
        this.iTable = sSTable = new SSTable();
        jScrollPane.setViewportView(sSTable);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 6, new Insets(0, 2, 4, 2), 2, 0, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("tenderframe.netsum"));
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxLabel1 = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("tenderframe.tax"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(80, -1), null));
        this.iTaxLabel2 = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("tenderframe.tax"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxLabel3 = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("tenderframe.tax"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("book").getString("tenderframe.rounding"));
        jPanel3.add((Component)jLabel5, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("book").getString("tenderframe.totalsum"));
        jPanel3.add((Component)jLabel6, new GridConstraints(0, 5, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iNetSum = sSBigDecimalTextField11 = new SSBigDecimalTextField();
        sSBigDecimalTextField11.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField11, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.iTaxSum1 = sSBigDecimalTextField10 = new SSBigDecimalTextField();
        sSBigDecimalTextField10.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField10, new GridConstraints(1, 1, 1, 1, 8, 1, 3, 3, null, new Dimension(100, -1), null));
        this.iTaxSum2 = sSBigDecimalTextField9 = new SSBigDecimalTextField();
        sSBigDecimalTextField9.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField9, new GridConstraints(1, 2, 1, 1, 8, 1, 3, 3, null, new Dimension(100, -1), null));
        this.iTaxSum3 = sSBigDecimalTextField8 = new SSBigDecimalTextField();
        sSBigDecimalTextField8.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField8, new GridConstraints(1, 3, 1, 1, 8, 1, 3, 3, null, new Dimension(100, -1), null));
        this.iRoundingSum = sSBigDecimalTextField7 = new SSBigDecimalTextField();
        sSBigDecimalTextField7.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField7, new GridConstraints(1, 4, 1, 1, 0, 1, 7, 3, null, null, null));
        this.iTotalSum = sSBigDecimalTextField6 = new SSBigDecimalTextField();
        sSBigDecimalTextField6.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField6, new GridConstraints(1, 5, 1, 1, 0, 1, 7, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(7, 6, new Insets(4, 4, 4, 4), 4, 1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("book").getString("tenderframe.number"));
        jPanel4.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("book").getString("tenderframe.date"));
        jPanel4.add((Component)jLabel8, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("book").getString("tenderframe.customernr"));
        jPanel4.add((Component)jLabel9, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("book").getString("tenderframe.customername"));
        jPanel4.add((Component)jLabel10, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iCustomerName = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("book").getString("tenderframe.ourcontactperson"));
        jPanel4.add((Component)jLabel11, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iOurContactPerson = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("book").getString("tenderframe.yourcontactperson"));
        jPanel4.add((Component)jLabel12, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iYourContactPerson = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        this.iNumber = jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setEditable(false);
        jPanel4.add((Component)jFormattedTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        SSEditableTableComboBox sSEditableTableComboBox = new SSEditableTableComboBox();
        this.iCurrency = sSEditableTableComboBox;
        jPanel4.add(sSEditableTableComboBox, new GridConstraints(5, 4, 1, 1, 4, 0, 7, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        this.iCurrencyCalculatorButton = sSButton = new SSButton();
        sSButton.setIconName("ICON_CALCULATOR16");
        sSButton.setToolTipText(ResourceBundle.getBundle("book").getString("tenderframe.currencycalculator"));
        jPanel4.add((Component)sSButton, new GridConstraints(5, 5, 1, 1, 6, 0, 3, 3, new Dimension(20, 20), new Dimension(20, 20), new Dimension(20, 20)));
        SSEditableTableComboBox sSEditableTableComboBox2 = new SSEditableTableComboBox();
        this.iDeliveryWay = sSEditableTableComboBox2;
        jPanel4.add(sSEditableTableComboBox2, new GridConstraints(4, 4, 1, 1, 4, 0, 7, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        SSEditableTableComboBox sSEditableTableComboBox3 = new SSEditableTableComboBox();
        this.iDeliveryTerm = sSEditableTableComboBox3;
        jPanel4.add(sSEditableTableComboBox3, new GridConstraints(3, 4, 1, 1, 4, 0, 7, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        SSEditableTableComboBox sSEditableTableComboBox4 = new SSEditableTableComboBox();
        this.iPaymentTerm = sSEditableTableComboBox4;
        jPanel4.add(sSEditableTableComboBox4, new GridConstraints(2, 4, 1, 1, 4, 0, 7, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("book").getString("tenderframe.currency"));
        jPanel4.add((Component)jLabel13, new GridConstraints(5, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel14 = new JLabel();
        this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("book").getString("tenderframe.deliveryway"));
        jPanel4.add((Component)jLabel14, new GridConstraints(4, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel15 = new JLabel();
        this.$$$loadLabelText$$$(jLabel15, ResourceBundle.getBundle("book").getString("tenderframe.deliveryterm"));
        jPanel4.add((Component)jLabel15, new GridConstraints(3, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel16 = new JLabel();
        this.$$$loadLabelText$$$(jLabel16, ResourceBundle.getBundle("book").getString("tenderframe.paymentterm"));
        jPanel4.add((Component)jLabel16, new GridConstraints(2, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel17 = new JLabel();
        this.$$$loadLabelText$$$(jLabel17, ResourceBundle.getBundle("book").getString("tenderframe.expires"));
        jPanel4.add((Component)jLabel17, new GridConstraints(1, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDate = sSDateChooser2 = new SSDateChooser();
        sSDateChooser2.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel4.add((Component)sSDateChooser2, new GridConstraints(0, 4, 1, 1, 4, 0, 3, 3, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, -1)));
        this.iExpires = sSDateChooser = new SSDateChooser();
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel4.add((Component)sSDateChooser, new GridConstraints(1, 4, 1, 1, 4, 0, 3, 3, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, -1)));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iCustomer = sSTableComboBox;
        jPanel4.add(sSTableComboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(150, -1), null));
        this.iCurrencyRate = sSBigDecimalTextField5 = new SSBigDecimalTextField();
        sSBigDecimalTextField5.setFocusTraversalPolicyProvider(false);
        sSBigDecimalTextField5.setFractionDigits(5);
        ((JTextComponent)sSBigDecimalTextField5).setText("1,0000");
        jPanel4.add((Component)sSBigDecimalTextField5, new GridConstraints(6, 4, 1, 1, 4, 0, 7, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        JLabel jLabel18 = new JLabel();
        jLabel18.setText("Valutakurs");
        jPanel4.add((Component)jLabel18, new GridConstraints(6, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iSavecustomerandproducts = jCheckBox5 = new JCheckBox();
        jCheckBox5.setVerticalTextPosition(0);
        jCheckBox5.setHorizontalAlignment(2);
        jCheckBox5.setSelected(true);
        jCheckBox5.setInheritsPopupMenu(false);
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("book").getString("tenderframe.dontsavecustomerandproducts"));
        jCheckBox5.setVerticalAlignment(3);
        jPanel2.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 10, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(6, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("tenderframe.panel.2"), null, jPanel5, null);
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iInvoiceAddress = sSAdressPanel2 = new SSAdressPanel();
        sSAdressPanel2.setTitle(ResourceBundle.getBundle("book").getString("tenderframe.invoiceaddress"));
        jPanel6.add((Component)sSAdressPanel2, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 4, 0, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel7.add((Component)jScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, new Dimension(-1, 60), null, null));
        this.iText = jTextArea = new JTextArea();
        jScrollPane2.setViewportView(jTextArea);
        JLabel jLabel19 = new JLabel();
        this.$$$loadLabelText$$$(jLabel19, ResourceBundle.getBundle("book").getString("tenderframe.tendertext"));
        jPanel7.add((Component)jLabel19, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel5.add((Component)jPanel8, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.iEuSaleCommodity = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("book").getString("customerframe.eusalecommodity"));
        jPanel8.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iEuSaleYhirdPartCommodity = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("book").getString("customerframe.eusalethirdpartcommodity"));
        jPanel8.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(1, 3, new Insets(4, 4, 4, 4), 2, 1, false, false));
        jPanel5.add((Component)jPanel9, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel20 = new JLabel();
        this.$$$loadLabelText$$$(jLabel20, ResourceBundle.getBundle("book").getString("tenderframe.delayinterest"));
        jPanel9.add((Component)jLabel20, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDelayInterest = sSBigDecimalTextField4 = new SSBigDecimalTextField();
        sSBigDecimalTextField4.setFractionDigits(2);
        jPanel9.add((Component)sSBigDecimalTextField4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        JLabel jLabel21 = new JLabel();
        jLabel21.setText("%");
        jPanel9.add((Component)jLabel21, new GridConstraints(0, 2, 1, 1, 8, 0, 6, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(1, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel5.add((Component)jPanel10, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iDeliveryAddress = sSAdressPanel = new SSAdressPanel();
        sSAdressPanel.setTitle(ResourceBundle.getBundle("book").getString("tenderframe.deliveryaddress"));
        jPanel10.add((Component)sSAdressPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.iUseInvoiceForDelivery = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("book").getString("customerframe.useinvoiceasdelivery"));
        ((Component)jCheckBox2).setEnabled(true);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("tenderframe.panel.3"), null, jPanel11, null);
        Spacer spacer4 = new Spacer();
        jPanel11.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel11.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iDefaultAccounts = sSDefaultAccountPanel = new SSDefaultAccountPanel();
        jPanel11.add((Component)sSDefaultAccountPanel, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayoutManager(4, 3, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel11.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel12.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel22 = new JLabel();
        this.$$$loadLabelText$$$(jLabel22, ResourceBundle.getBundle("book").getString("companyframe.taxrate1"));
        jPanel12.add((Component)jLabel22, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel23 = new JLabel();
        this.$$$loadLabelText$$$(jLabel23, ResourceBundle.getBundle("book").getString("companyframe.taxrate2"));
        jPanel12.add((Component)jLabel23, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel24 = new JLabel();
        this.$$$loadLabelText$$$(jLabel24, ResourceBundle.getBundle("book").getString("companyframe.taxrate3"));
        jPanel12.add((Component)jLabel24, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxRate1 = sSBigDecimalTextField3 = new SSBigDecimalTextField();
        jPanel12.add((Component)sSBigDecimalTextField3, new GridConstraints(1, 1, 1, 1, 8, 0, 7, 3, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, -1)));
        JLabel jLabel25 = new JLabel();
        jLabel25.setText("%");
        jPanel12.add((Component)jLabel25, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel26 = new JLabel();
        jLabel26.setText("%");
        jPanel12.add((Component)jLabel26, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel27 = new JLabel();
        jLabel27.setText("%");
        jPanel12.add((Component)jLabel27, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxRate2 = sSBigDecimalTextField2 = new SSBigDecimalTextField();
        jPanel12.add((Component)sSBigDecimalTextField2, new GridConstraints(2, 1, 1, 1, 8, 0, 7, 3, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, -1)));
        this.iTaxRate3 = sSBigDecimalTextField = new SSBigDecimalTextField();
        jPanel12.add((Component)sSBigDecimalTextField, new GridConstraints(3, 1, 1, 1, 8, 0, 7, 3, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, 20)));
        this.iTaxFree = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("tenderframe.taxfree"));
        jPanel12.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class ContributionRateColumn
    extends SSTableColumn<SSSaleRow> {
        public ContributionRateColumn() {
            super(SSBundle.getBundle().getString("salerowtable.column.12"));
        }

        private BigDecimal getExchangeRate() {
            BigDecimal iValue = SSTenderPanel.this.iCurrencyRate.getValue();
            if (iValue != null) {
                return iValue;
            }
            SSCurrency iSelected = (SSCurrency)SSTenderPanel.this.iCurrency.getSelected();
            if (iSelected != null) {
                return iSelected.getExchangeRate();
            }
            return null;
        }

        @Override
        public Object getValue(SSSaleRow iRow) {
            SSProduct iProduct = iRow.getProduct();
            if (iProduct == null) {
                return null;
            }
            BigDecimal iInprice = SSProductMath.getInprice(iProduct, SSTenderPanel.this.iDate.getDate());
            BigDecimal iUnitprice = iRow.getUnitprice();
            BigDecimal iExchangeRate = this.getExchangeRate();
            if (iInprice == null || iUnitprice == null) {
                return null;
            }
            if (iExchangeRate != null) {
                return iUnitprice.multiply(iExchangeRate).subtract(iInprice);
            }
            return iUnitprice.subtract(iInprice);
        }

        @Override
        public void setValue(SSSaleRow iObject, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return BigDecimal.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    }
}

