/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;

public class SSButtonGroup
implements ActionListener {
    protected List<AbstractButton> iButtons = new LinkedList<AbstractButton>();
    protected boolean iAllowNoneSelected;
    protected AbstractButton iSelected;
    boolean iUpdating;

    public SSButtonGroup() {
        this(false);
    }

    public SSButtonGroup(boolean iAllowNoneSelected) {
        this.iAllowNoneSelected = iAllowNoneSelected;
    }

    public boolean isAllowNoneSelected() {
        return this.iAllowNoneSelected;
    }

    public void setAllowNoneSelected(boolean iAllowNoneSelected) {
        this.iAllowNoneSelected = iAllowNoneSelected;
    }

    public void add(AbstractButton iButton) {
        if (iButton == null || this.iButtons.contains(iButton)) {
            return;
        }
        this.iButtons.add(iButton);
        if (iButton.isSelected()) {
            this.setSelected(iButton);
        }
        iButton.addActionListener(this);
    }

    public void remove(AbstractButton iButton) {
        if (iButton == null) {
            return;
        }
        this.iButtons.remove(iButton);
        if (iButton == this.iSelected) {
            this.iSelected = null;
        }
        iButton.addActionListener(this);
    }

    public int getButtonCount() {
        return this.iButtons == null ? 0 : this.iButtons.size();
    }

    public List<AbstractButton> getButtons() {
        return Collections.unmodifiableList(this.iButtons);
    }

    public AbstractButton getSelected() {
        return this.iSelected;
    }

    private void setSelected(AbstractButton iButton) {
        this.iSelected = iButton;
        for (AbstractButton iCurrent : this.iButtons) {
            iCurrent.removeActionListener(this);
            iCurrent.setSelected(iCurrent == this.iSelected);
            iCurrent.addActionListener(this);
        }
    }

    private boolean setUpdating(boolean iNewUpdating) {
        if (this.iUpdating && iNewUpdating) {
            return true;
        }
        this.iUpdating = iNewUpdating;
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton iButton = (AbstractButton)e.getSource();
        if (iButton.isSelected()) {
            this.setSelected(iButton);
        } else if (this.iAllowNoneSelected) {
            this.setSelected(null);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.SSButtonGroup");
        sb.append("{iAllowNoneSelected=").append(this.iAllowNoneSelected);
        sb.append(", iButtons=").append(this.iButtons);
        sb.append(", iSelected=").append(this.iSelected);
        sb.append(", iUpdating=").append(this.iUpdating);
        sb.append('}');
        return sb.toString();
    }
}

