/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.components;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.graphics.SSIcon;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSEditableTableComboBox<T extends SSTableSearchable>
extends JPanel {
    private JButton iEditButton;
    private JPopupMenu iPopup;
    private EditingFactory<T> iFactory;
    private SSTableComboBox<T> iComboBox = new SSTableComboBox();

    public SSEditableTableComboBox() {
        this.iEditButton = new JButton("...");
        this.iEditButton.setPreferredSize(new Dimension(20, 20));
        this.iEditButton.setMaximumSize(new Dimension(20, 20));
        this.iEditButton.setMinimumSize(new Dimension(20, 20));
        this.createLayout();
        this.iPopup = new JPopupMenu();
        JMenuItem iMenuItem = new JMenuItem("L\u00e4gg till...");
        iMenuItem.setIcon(SSIcon.getIcon("ICON_NEW16", SSIcon.IconState.NORMAL));
        iMenuItem.setDisabledIcon(SSIcon.getIcon("ICON_NEW16", SSIcon.IconState.DISABLED));
        iMenuItem.setRolloverIcon(SSIcon.getIcon("ICON_NEW16", SSIcon.IconState.HIGHLIGHTED));
        iMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object iSelected;
                if (SSEditableTableComboBox.this.iFactory != null && (iSelected = SSEditableTableComboBox.this.iFactory.newAction()) != null) {
                    if (SSEditableTableComboBox.this.iComboBox.getModel() != null) {
                        SSEditableTableComboBox.this.iComboBox.getModel().fireTableDataChanged();
                    }
                    SSEditableTableComboBox.this.iComboBox.setModel(SSEditableTableComboBox.this.iComboBox.getModel().getDropdownmodel());
                    SSEditableTableComboBox.this.iComboBox.setSelected(iSelected, true);
                }
            }
        });
        this.iPopup.add(iMenuItem);
        iMenuItem = new JMenuItem("\u00c4ndra...");
        iMenuItem.setIcon(SSIcon.getIcon("ICON_EDIT16", SSIcon.IconState.NORMAL));
        iMenuItem.setDisabledIcon(SSIcon.getIcon("ICON_EDIT16", SSIcon.IconState.DISABLED));
        iMenuItem.setRolloverIcon(SSIcon.getIcon("ICON_EDIT16", SSIcon.IconState.HIGHLIGHTED));
        iMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object iSelected = SSEditableTableComboBox.this.iComboBox.getSelected();
                if (SSEditableTableComboBox.this.iFactory != null && iSelected != null) {
                    SSEditableTableComboBox.this.iFactory.editAction(iSelected);
                    if (SSEditableTableComboBox.this.iComboBox.getModel() != null) {
                        SSEditableTableComboBox.this.iComboBox.getModel().fireTableDataChanged();
                    }
                    SSEditableTableComboBox.this.iComboBox.setModel(SSEditableTableComboBox.this.iComboBox.getModel().getDropdownmodel());
                    SSEditableTableComboBox.this.iComboBox.setSelected(iSelected, true);
                }
            }
        });
        this.iPopup.add(iMenuItem);
        iMenuItem = new JMenuItem("Ta bort...");
        iMenuItem.setIcon(SSIcon.getIcon("ICON_DELETE16", SSIcon.IconState.NORMAL));
        iMenuItem.setDisabledIcon(SSIcon.getIcon("ICON_DELETE16", SSIcon.IconState.DISABLED));
        iMenuItem.setRolloverIcon(SSIcon.getIcon("ICON_DELETE16", SSIcon.IconState.HIGHLIGHTED));
        iMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object iSelected = SSEditableTableComboBox.this.iComboBox.getSelected();
                if (SSEditableTableComboBox.this.iFactory != null && iSelected != null) {
                    SSEditableTableComboBox.this.iFactory.deleteAction(iSelected);
                    if (SSEditableTableComboBox.this.iComboBox.getModel() != null) {
                        SSEditableTableComboBox.this.iComboBox.getModel().fireTableDataChanged();
                    }
                    SSEditableTableComboBox.this.iComboBox.setModel(SSEditableTableComboBox.this.iComboBox.getModel().getDropdownmodel());
                    SSEditableTableComboBox.this.iComboBox.setSelected(null, true);
                }
            }
        });
        this.iPopup.add(iMenuItem);
        this.iEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSEditableTableComboBox.this.iPopup.show(SSEditableTableComboBox.this.iEditButton, 0, SSEditableTableComboBox.this.iEditButton.getHeight());
            }
        });
    }

    public void dispose() {
        ActionListener[] iActionListeners;
        for (ActionListener iActionListener : iActionListeners = this.iEditButton.getActionListeners()) {
            this.iEditButton.removeActionListener(iActionListener);
        }
        this.iEditButton.removeAll();
        this.iEditButton = null;
        this.iPopup.removeAll();
        this.iPopup = null;
        this.iFactory = null;
        this.iComboBox.dispose();
        this.iComboBox = null;
    }

    protected void createLayout() {
        GridBagLayout iLayout = new GridBagLayout();
        GridBagConstraints iConstraints = new GridBagConstraints();
        this.setLayout(iLayout);
        iConstraints.insets = new Insets(0, 0, 0, 0);
        iConstraints.fill = 1;
        iConstraints.weightx = 1.0;
        iConstraints.weighty = 1.0;
        iLayout.setConstraints(this.iComboBox, iConstraints);
        this.add(this.iComboBox);
        iConstraints.fill = 0;
        iConstraints.weightx = 0.0;
        iLayout.setConstraints(this.iEditButton, iConstraints);
        this.add(this.iEditButton);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.iComboBox.setEnabled(enabled);
        this.iEditButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setEditingFactory(EditingFactory<T> pFactory) {
        this.iFactory = pFactory;
    }

    public SSTableComboBox<T> getComboBox() {
        return this.iComboBox;
    }

    public T getSelected() {
        return this.iComboBox.getSelected();
    }

    public void setSelected(T pSelected) {
        this.iComboBox.setSelected(pSelected);
    }

    public void setSelected(T pSelected, boolean pNotifyListeners) {
        this.iComboBox.setSelected(pSelected, pNotifyListeners);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox");
        sb.append("{iComboBox=").append(this.iComboBox);
        sb.append(", iEditButton=").append(this.iEditButton);
        sb.append(", iFactory=").append(this.iFactory);
        sb.append(", iPopup=").append(this.iPopup);
        sb.append('}');
        return sb.toString();
    }

    public static interface EditingFactory<T extends SSTableSearchable> {
        public T newAction();

        public void editAction(T var1);

        public void deleteAction(T var1);
    }
}

