/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.components;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SSLocalizedTextField
extends JPanel {
    private List<Locale> iLocales = new LinkedList<Locale>();
    private Map<Locale, String> iDescriptions = new HashMap<Locale, String>();
    private Map<Locale, String> iValues = new HashMap<Locale, String>();
    private Map<Locale, JTextField> iTextFields = new HashMap<Locale, JTextField>();

    private void createLayout() {
        GridBagLayout iLayout = new GridBagLayout();
        GridBagConstraints iConstraints = new GridBagConstraints();
        this.removeAll();
        this.setLayout(iLayout);
        iConstraints.insets = new Insets(1, 2, 1, 2);
        for (Locale iLocale : this.iLocales) {
            String iDescription = this.iDescriptions.get(iLocale);
            String iValue = this.iValues.get(iLocale);
            JLabel iLabel = new JLabel(iDescription);
            JTextField iTextField = new JTextField(iValue);
            iTextField.setPreferredSize(new Dimension(380, iTextField.getPreferredSize().height));
            iTextField.getDocument().addDocumentListener(new MyDocumentListener(iTextField, iLocale));
            iConstraints.fill = 0;
            iConstraints.weightx = 0.0;
            iConstraints.gridwidth = -1;
            iLayout.setConstraints(iLabel, iConstraints);
            this.add(iLabel);
            iConstraints.fill = 2;
            iConstraints.weightx = 1.0;
            iConstraints.gridwidth = 0;
            iLayout.setConstraints(iTextField, iConstraints);
            this.add(iTextField);
            this.iTextFields.put(iLocale, iTextField);
        }
    }

    public void addLocale(Locale iLocale, String iDescription) {
        this.addLocale(iLocale, iDescription, null);
    }

    public void addLocale(Locale iLocale, String iDescription, String iValue) {
        this.iLocales.add(iLocale);
        this.iDescriptions.put(iLocale, iDescription);
        this.iValues.put(iLocale, iValue);
        this.createLayout();
    }

    public Map<Locale, String> getValues() {
        for (Locale iLocale : this.iLocales) {
            this.iValues.put(iLocale, this.iTextFields.get(iLocale).getText());
        }
        return this.iValues;
    }

    public void setValues(Map<Locale, String> iValues) {
        this.iValues = new HashMap<Locale, String>();
        this.iValues.putAll(iValues);
        for (Locale iLocale : this.iLocales) {
            this.iTextFields.get(iLocale).setText(iValues.get(iLocale));
        }
    }

    public String getValue(Locale iLocale) {
        return this.iValues.get(iLocale);
    }

    public void setValue(Locale iLocale, String value) {
        this.iValues.put(iLocale, value);
        this.setValues(this.iValues);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.components.SSLocalizedTextField");
        sb.append("{iDescriptions=").append(this.iDescriptions);
        sb.append(", iLocales=").append(this.iLocales);
        sb.append(", iTextFields=").append(this.iTextFields);
        sb.append(", iValues=").append(this.iValues);
        sb.append('}');
        return sb.toString();
    }

    private class MyDocumentListener
    implements DocumentListener {
        private Locale iLocale;
        private JTextField iTextField;

        public MyDocumentListener(JTextField iTextField, Locale iLocale) {
            this.iLocale = iLocale;
            this.iTextField = iTextField;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            String iValue = this.iTextField.getText();
            SSLocalizedTextField.this.iValues.put(this.iLocale, iValue);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.util.components.SSLocalizedTextField.MyDocumentListener");
            sb.append("{iLocale=").append(this.iLocale);
            sb.append(", iTextField=").append(this.iTextField);
            sb.append('}');
            return sb.toString();
        }
    }
}

