/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;

public class SSMenuButton<T extends JButton>
extends SSButton {
    private JPopupMenu iPopup;

    public SSMenuButton() {
        this.createPopup();
    }

    public SSMenuButton(String pIcon) {
        super(pIcon);
        this.createPopup();
    }

    public SSMenuButton(String pIcon, String pBundleName) {
        super(pIcon, pBundleName);
        this.createPopup();
    }

    private void createPopup() {
        this.iPopup = new JPopupMenu();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSMenuButton.this.iPopup.show(SSMenuButton.this, 0, SSMenuButton.this.getHeight());
            }
        });
    }

    public T add(T iComponent) {
        this.iPopup.add((Component)iComponent);
        return iComponent;
    }

    public JMenuItem add(String pBundleName, ActionListener iListener) {
        JMenuItem iMenuItem = new JMenuItem();
        if (iBundle.hasKey(pBundleName + ".title")) {
            iMenuItem.setText(iBundle.getString(pBundleName + ".title"));
        }
        if (iBundle.hasKey(pBundleName + ".tooltip")) {
            iMenuItem.setToolTipText(iBundle.getString(pBundleName + ".tooltip"));
        }
        iMenuItem.addActionListener(iListener);
        this.iPopup.add(iMenuItem);
        this.iPopup.pack();
        return iMenuItem;
    }

    public void addSeparator() {
        this.iPopup.addSeparator();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.components.SSMenuButton");
        sb.append("{iPopup=").append(this.iPopup);
        sb.append('}');
        return sb.toString();
    }
}

