/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Document;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSTextField;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSTableComboBox<T extends SSTableSearchable>
extends JPanel {
    protected SSTextField iTextField;
    protected JButton iDropdownButton;
    protected JPopupMenu iPopup;
    protected SSTable iTable;
    protected SSTableModel<T> iModel;
    private List<T> iObjects;
    private int[] iSearchColumns;
    private boolean iAllowCustomValues = false;
    private T iSelected = null;
    private List<SSSelectionListener> iSelectionListeners = new LinkedList<SSSelectionListener>();
    protected CellEditor iEditor;
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public SSTableComboBox() {
        this.iSearchColumns = EMPTY_INT_ARRAY;
        this.iModel = this.createDefaultModel();
        this.iTextField = new SSTextField();
        this.iDropdownButton = new SSButton("ICON_DROPDOWN16");
        this.iDropdownButton.setMinimumSize(new Dimension(20, 20));
        this.iDropdownButton.setMaximumSize(new Dimension(20, 20));
        this.iDropdownButton.setPreferredSize(new Dimension(20, 20));
        this.createLayout();
        this.iTable = new SSTable();
        this.iTable.setSelectionMode(0);
        this.iPopup = new JPopupMenu();
        this.iPopup.add(new JScrollPane(this.iTable));
        this.iPopup.setPreferredSize(new Dimension(350, 200));
        this.iDropdownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SSTableComboBox.this.iPopup.isVisible()) {
                    SSTableComboBox.this.iPopup.show(SSTableComboBox.this.iTextField, 0, SSTableComboBox.this.getHeight());
                }
                SSTableComboBox.this.iModel.setObjects(SSTableComboBox.this.iObjects);
            }
        });
        AbstractAction iSelectNull = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTableComboBox.this.setSelected(null, true);
                if (SSTableComboBox.this.iEditor != null) {
                    SSTableComboBox.this.iEditor.stopCellEditing();
                    SSTableComboBox.this.iEditor.transferFocusToTable();
                }
                SSTableComboBox.this.stopEdit();
            }
        };
        AbstractAction iSelectAndClose = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int iIndex = SSTableComboBox.this.iTable.getSelectedRow();
                if (iIndex < 0 || iIndex >= SSTableComboBox.this.iModel.getRowCount()) {
                    return;
                }
                SSTableSearchable iObject = (SSTableSearchable)SSTableComboBox.this.iModel.getObject(iIndex);
                SSTableComboBox.this.setSelected(iObject, true);
                if (SSTableComboBox.this.iEditor != null) {
                    SSTableComboBox.this.iEditor.stopCellEditing();
                    SSTableComboBox.this.iEditor.transferFocusToTable();
                }
                SSTableComboBox.this.stopEdit();
            }
        };
        AbstractAction iFocusTable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTableComboBox.this.iTable.requestFocus();
            }
        };
        this.iTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!SSTableComboBox.this.isEnabled()) {
                    return;
                }
                if (e.getKeyCode() == 10 || e.getKeyCode() == 27 || e.getKeyCode() == 127) {
                    return;
                }
                if (SSTableComboBox.this.searchTable()) {
                    if (SSTableComboBox.this.iModel != null && SSTableComboBox.this.iModel.getRowCount() > 0) {
                        SSTableComboBox.this.iSelected = (SSTableSearchable)SSTableComboBox.this.iModel.getObject(0);
                        SSTableComboBox.this.iTable.setRowSelectionInterval(0, 0);
                    } else {
                        SSTableComboBox.this.iSelected = null;
                    }
                } else {
                    SSTableComboBox.this.iSelected = null;
                }
                if (!SSTableComboBox.this.iAllowCustomValues) {
                    SSTableComboBox.this.iTextField.setForeground(SSTableComboBox.this.iSelected == null ? Color.RED : Color.BLACK);
                }
                SSTableComboBox.this.startEdit();
            }
        });
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTableComboBox.this.iTextField.getActionMap().get("SELECT_ROW_AND_CLOSE_DROP_DOWN").actionPerformed(null);
            }
        });
        this.iTextField.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "SELECT_NULL");
        this.iTextField.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "SELECT_ROW_AND_CLOSE_DROP_DOWN");
        this.iTextField.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), "FOCUS_DROP_DOWN_TABLE");
        this.iTextField.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), "FOCUS_DROP_DOWN_TABLE");
        this.iTable.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "SELECT_ROW_AND_CLOSE_DROP_DOWN");
        this.iTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "SELECT_ROW_AND_CLOSE_DROP_DOWN");
        this.iTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 64), "SELECT_ROW_AND_CLOSE_DROP_DOWN");
        this.iTextField.getActionMap().put("SELECT_NULL", iSelectNull);
        this.iTextField.getActionMap().put("FOCUS_DROP_DOWN_TABLE", iFocusTable);
        this.iTextField.getActionMap().put("SELECT_ROW_AND_CLOSE_DROP_DOWN", iSelectAndClose);
        this.iTable.getActionMap().put("SELECT_ROW_AND_CLOSE_DROP_DOWN", iSelectAndClose);
    }

    private SSTableModel<T> createDefaultModel() {
        return new SSTableModel<T>(){

            @Override
            public Class getType() {
                return null;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return null;
            }
        };
    }

    protected void createLayout() {
        GridBagLayout iLayout = new GridBagLayout();
        GridBagConstraints iConstraints = new GridBagConstraints();
        this.setLayout(iLayout);
        iConstraints.insets = new Insets(0, 0, 0, 0);
        iConstraints.fill = 1;
        iConstraints.weightx = 1.0;
        iConstraints.weighty = 1.0;
        iLayout.setConstraints(this.iTextField, iConstraints);
        this.add(this.iTextField);
        iConstraints.fill = 0;
        iConstraints.weightx = 0.0;
        iLayout.setConstraints(this.iDropdownButton, iConstraints);
        this.add(this.iDropdownButton);
    }

    public void setModel(SSTableModel<T> iModel) {
        this.iModel = iModel;
        this.iObjects = iModel.getObjects();
        this.iTable.setModel(iModel);
        int iTotalWidth = 0;
        int iIndex = 0;
        for (SSTableColumn<T> iColumn : iModel.getColumns()) {
            int iWidth = iColumn.getDefaultWidth();
            TableCellEditor iEditor = iColumn.getCellEditor();
            TableCellRenderer iRenderer = iColumn.getCellRenderer();
            this.iTable.getColumnModel().getColumn(iIndex).setPreferredWidth(iWidth);
            this.iTable.getColumnModel().getColumn(iIndex).setCellEditor(iEditor);
            this.iTable.getColumnModel().getColumn(iIndex).setCellRenderer(iRenderer);
            ++iIndex;
            iTotalWidth += iWidth;
        }
        this.iPopup.setPreferredSize(new Dimension(iTotalWidth + 20, 150));
    }

    public SSTableModel<T> getModel() {
        return this.iModel;
    }

    public void setSearchColumns(int ... pSearchColumns) {
        this.iSearchColumns = pSearchColumns;
    }

    public void setAllowCustomValues(boolean iAllowCustomValues) {
        this.iAllowCustomValues = iAllowCustomValues;
        if (iAllowCustomValues) {
            this.iTextField.setForeground(Color.BLACK);
        } else {
            this.iTextField.setForeground(this.iSelected == null ? Color.RED : Color.BLACK);
        }
    }

    public boolean doAllowCustomValues() {
        return this.iAllowCustomValues;
    }

    public void setSelected(T pSelected, boolean pNotifyListeners) {
        this.iSelected = pSelected;
        if (this.iSelected != null) {
            this.iTextField.setText(this.iSelected.toRenderString());
        } else {
            this.iTextField.setText("");
        }
        if (this.iAllowCustomValues) {
            this.iTextField.setForeground(Color.BLACK);
        } else {
            this.iTextField.setForeground(this.iSelected == null ? Color.RED : Color.BLACK);
        }
        if (pNotifyListeners) {
            this.notifySelectionListeners((SSTableSearchable)pSelected);
        }
    }

    public void setSelected(T pSelected) {
        this.setSelected(pSelected, false);
    }

    public T getSelected() {
        if (this.iSelected == null && !this.iAllowCustomValues && this.iModel.getRowCount() > 0) {
            return (T)((SSTableSearchable)this.iModel.getObject(0));
        }
        return this.iSelected;
    }

    public T getFirst() {
        if (!this.iObjects.isEmpty()) {
            return (T)((SSTableSearchable)this.iObjects.get(0));
        }
        return null;
    }

    public String getText() {
        if (this.iAllowCustomValues) {
            return this.iTextField.getText();
        }
        return this.iSelected == null ? null : this.iSelected.toRenderString();
    }

    public void setText(String pText) {
        this.iTextField.setText(pText);
        this.searchTable();
    }

    public Object getValue() {
        if (this.iSelected != null) {
            return this.iSelected;
        }
        if (this.iAllowCustomValues) {
            return this.iTextField.getText();
        }
        return null;
    }

    private boolean searchTable() {
        String iText = this.iTextField.getText();
        if (this.iSearchColumns.length == 0) {
            return true;
        }
        LinkedList<T> iVisible = new LinkedList<T>();
        this.iModel.setObjects(this.iObjects);
        int size = this.iObjects.size();
        block0: for (int i = 0; i < size; ++i) {
            for (int c : this.iSearchColumns) {
                Object value = this.iModel.getValueAt(i, c);
                if (!this.compareTo(c, iText, value)) continue;
                iVisible.add(this.iModel.getObject(i));
                continue block0;
            }
        }
        this.iModel.setObjects(iVisible);
        this.iModel.fireTableDataChanged();
        return !iVisible.isEmpty();
    }

    protected boolean compareTo(int column, String text, Object value) {
        if (text == null || text.length() == 0) {
            return true;
        }
        if (value == null) {
            return false;
        }
        String iString = value.toString();
        return iString.toLowerCase().startsWith(text.toLowerCase());
    }

    public void startEdit() {
        this.iPopup.show(this.iTextField, 0, this.getHeight());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SSTableComboBox.this.iTextField.requestFocusInWindow();
            }
        });
    }

    public void stopEdit() {
        this.iModel.setObjects(this.iObjects);
        this.iModel.fireTableDataChanged();
        this.iPopup.setVisible(false);
    }

    public void cancelCellEditing() {
        this.stopEdit();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        super.processKeyBinding(ks, e, condition, pressed);
        return this.iTextField.processKeyBinding(ks, e, condition, pressed);
    }

    public void addChangeListener(final ActionListener pAction) {
        this.iTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                pAction.actionPerformed(null);
            }
        });
    }

    public void addSelectionListener(SSSelectionListener<T> pAction) {
        this.iSelectionListeners.add(pAction);
    }

    protected void notifySelectionListeners(SSTableSearchable pSelected) {
        for (SSSelectionListener iSelectionListener : this.iSelectionListeners) {
            iSelectionListener.selected(pSelected);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.iTextField.setEditable(enabled);
        this.iDropdownButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public Document getDocument() {
        return this.iTextField.getDocument();
    }

    public SSTable getTable() {
        return this.iTable;
    }

    public void dispose() {
        ActionListener[] iActionListeners;
        KeyListener[] iKeyListeners;
        for (KeyListener iKeyListener : iKeyListeners = this.iTextField.getKeyListeners()) {
            this.iTextField.removeKeyListener(iKeyListener);
        }
        this.iTextField.removeAll();
        this.iTextField = null;
        for (ActionListener iActionListener : iActionListeners = this.iDropdownButton.getActionListeners()) {
            this.iDropdownButton.removeActionListener(iActionListener);
        }
        this.iDropdownButton.removeAll();
        this.iDropdownButton = null;
        this.iPopup.removeAll();
        this.iPopup = null;
        this.iTable.dispose();
        this.iTable.removeAll();
        this.iTable = null;
        this.iModel = null;
        this.iSelected = null;
        this.iSelectionListeners.removeAll(this.iSelectionListeners);
        this.iSelectionListeners = null;
        if (this.iEditor != null) {
            this.iEditor.dispose();
        }
        this.iEditor = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox");
        sb.append("{iAllowCustomValues=").append(this.iAllowCustomValues);
        sb.append(", iDropdownButton=").append(this.iDropdownButton);
        sb.append(", iEditor=").append(this.iEditor);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iObjects=").append(this.iObjects);
        sb.append(", iPopup=").append(this.iPopup);
        sb.append(", iSearchColumns=").append(this.iSearchColumns == null ? "null" : "");
        for (int i = 0; this.iSearchColumns != null && i < this.iSearchColumns.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.iSearchColumns[i]);
        }
        sb.append(", iSelected=").append(this.iSelected);
        sb.append(", iSelectionListeners=").append(this.iSelectionListeners);
        sb.append(", iTable=").append(this.iTable);
        sb.append(", iTextField=").append(this.iTextField);
        sb.append('}');
        return sb.toString();
    }

    public static class CellEditor<T extends SSTableSearchable>
    extends AbstractCellEditor
    implements TableCellEditor {
        private SSTableComboBox<T> iComboBox = new SSTableComboBox();
        private JTable iCurrentTable;
        private int iCurrentRow;
        private int iCurrentColumn;

        public CellEditor() {
            this.iComboBox.iEditor = this;
        }

        public CellEditor(SSTableModel<T> pModel) {
            this();
            this.setModel(pModel);
        }

        public void dispose() {
            if (this.iCurrentTable != null) {
                this.iCurrentTable.removeAll();
            }
            this.iCurrentTable = null;
            this.iComboBox = null;
        }

        protected void setModel(SSTableModel<T> pModel) {
            this.iComboBox.setModel(pModel);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.iCurrentTable = table;
            this.iCurrentRow = row;
            this.iCurrentColumn = column;
            if (value instanceof SSTableSearchable) {
                this.iComboBox.setSelected((SSTableSearchable)value, false);
            } else if (value == null) {
                this.iComboBox.iTextField.setText("");
                this.iComboBox.setSelected(null);
            } else {
                this.iComboBox.iTextField.setText(value.toString());
                ((SSTableComboBox)this.iComboBox).searchTable();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((CellEditor)CellEditor.this).iComboBox.iTextField.requestFocusInWindow();
                }
            });
            this.iComboBox.iTextField.selectAll();
            return this.iComboBox;
        }

        public Component getComponent() {
            return this.iComboBox.iTextField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.iComboBox.getValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 2;
            }
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean startCellEditing(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.iComboBox.iPopup.setVisible(false);
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.iComboBox.iPopup.setVisible(false);
            this.fireEditingCanceled();
        }

        private void transferFocusToTable() {
            this.iCurrentTable.changeSelection(this.iCurrentRow, this.iCurrentColumn, false, false);
            this.iCurrentTable.requestFocusInWindow();
        }

        public void setSearchColumns(int ... pSearchColumns) {
            this.iComboBox.setSearchColumns(pSearchColumns);
        }

        public void setAllowCustomValues(boolean iAllowCustomValues) {
            this.iComboBox.setAllowCustomValues(iAllowCustomValues);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox.CellEditor");
            sb.append("{iComboBox=").append(this.iComboBox);
            sb.append(", iCurrentColumn=").append(this.iCurrentColumn);
            sb.append(", iCurrentRow=").append(this.iCurrentRow);
            sb.append(", iCurrentTable=").append(this.iCurrentTable);
            sb.append('}');
            return sb.toString();
        }
    }
}

