/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSTextField;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSTableComboBoxOld<T extends SSTableSearchable>
extends JPanel {
    protected SSTextField iTextField;
    protected JButton iDropdownButton;
    protected JPopupMenu iPopup;
    protected SSTable iTable;
    protected SSDefaultTableModel<T> iModel;
    private List<T> iObjects;
    private int[] iSearchColumns;
    private boolean iAllowCustomValues = false;
    private T iSelected = null;
    private List<SSSelectionListener> iSelectionListeners = new LinkedList<SSSelectionListener>();
    protected CellEditor iEditor;
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public SSTableComboBoxOld() {
        this.iSearchColumns = EMPTY_INT_ARRAY;
        this.iModel = this.createDefaultModel();
        this.iTextField = new SSTextField();
        this.iDropdownButton = new SSButton("ICON_DROPDOWN16");
        this.iDropdownButton.setPreferredSize(new Dimension(20, 20));
        this.iDropdownButton.setMaximumSize(new Dimension(20, 20));
        this.iDropdownButton.setMinimumSize(new Dimension(20, 20));
        this.createLayout();
        this.iTable = new SSTable();
        this.iTable.setSelectionMode(0);
        this.iPopup = new JPopupMenu();
        this.iPopup.add(new JScrollPane(this.iTable));
        this.iPopup.setPreferredSize(new Dimension(350, 200));
        this.iPopup.setLightWeightPopupEnabled(true);
        this.iDropdownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTableComboBoxOld.this.startEdit();
                SSTableComboBoxOld.this.searchTable();
            }
        });
        AbstractAction iSelectNull = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTableComboBoxOld.this.setSelected(null);
                SSTableComboBoxOld.this.notifySelectionListeners(SSTableComboBoxOld.this.iSelected);
                if (SSTableComboBoxOld.this.iEditor != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTableComboBoxOld.this.iEditor.stopCellEditing();
                            SSTableComboBoxOld.this.iEditor.transferFocusToTable();
                        }
                    });
                }
                SSTableComboBoxOld.this.stopEdit();
            }
        };
        final AbstractAction iSelectAndClose = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = SSTableComboBoxOld.this.iTable.getSelectedRow();
                if (selected >= 0 && SSTableComboBoxOld.this.iModel.getRowCount() > selected) {
                    SSTableSearchable value = (SSTableSearchable)SSTableComboBoxOld.this.iModel.getObject(selected);
                    SSTableComboBoxOld.this.setSelected(value);
                    SSTableComboBoxOld.this.notifySelectionListeners(SSTableComboBoxOld.this.iSelected);
                }
                if (SSTableComboBoxOld.this.iEditor != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSTableComboBoxOld.this.iEditor.stopCellEditing();
                            SSTableComboBoxOld.this.iEditor.transferFocusToTable();
                        }
                    });
                }
                SSTableComboBoxOld.this.stopEdit();
            }
        };
        AbstractAction iFocusTable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTableComboBoxOld.this.iTable.requestFocus();
            }
        };
        this.iTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!SSTableComboBoxOld.this.isEnabled()) {
                    return;
                }
                if (e.getKeyCode() == 10 || e.getKeyCode() == 27) {
                    return;
                }
                if (SSTableComboBoxOld.this.searchTable()) {
                    if (SSTableComboBoxOld.this.iModel != null && SSTableComboBoxOld.this.iModel.getRowCount() > 0) {
                        SSTableComboBoxOld.this.iSelected = (SSTableSearchable)SSTableComboBoxOld.this.iModel.getObject(0);
                        SSTableComboBoxOld.this.iTable.setRowSelectionInterval(0, 0);
                    } else {
                        SSTableComboBoxOld.this.iSelected = null;
                    }
                } else {
                    SSTableComboBoxOld.this.iSelected = null;
                }
                if (!SSTableComboBoxOld.this.iAllowCustomValues) {
                    SSTableComboBoxOld.this.iTextField.setForeground(SSTableComboBoxOld.this.iSelected == null ? Color.RED : Color.BLACK);
                }
                SSTableComboBoxOld.this.startEdit();
                SSTableComboBoxOld.this.iTextField.requestFocus();
            }
        });
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iSelectAndClose.actionPerformed(null);
            }
        });
        this.iTextField.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "SELECT_NULL");
        this.iTextField.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "SELECT_ROW_AND_CLOSE_DROP_DOWN");
        this.iTextField.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), "FOCUS_DROP_DOWN_TABLE");
        this.iTextField.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), "FOCUS_DROP_DOWN_TABLE");
        this.iTable.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "SELECT_ROW_AND_CLOSE_DROP_DOWN");
        this.iTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "SELECT_ROW_AND_CLOSE_DROP_DOWN");
        this.iTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 64), "SELECT_ROW_AND_CLOSE_DROP_DOWN");
        this.iTextField.getActionMap().put("SELECT_NULL", iSelectNull);
        this.iTextField.getActionMap().put("FOCUS_DROP_DOWN_TABLE", iFocusTable);
        this.iTextField.getActionMap().put("SELECT_ROW_AND_CLOSE_DROP_DOWN", iSelectAndClose);
        this.iTable.getActionMap().put("SELECT_ROW_AND_CLOSE_DROP_DOWN", iSelectAndClose);
    }

    private SSDefaultTableModel<T> createDefaultModel() {
        return new SSDefaultTableModel<T>(){

            @Override
            public Class getType() {
                return null;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return null;
            }
        };
    }

    protected void createLayout() {
        this.setLayout(new BorderLayout());
        JPanel iPanel = new JPanel();
        iPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iDropdownButton, "Center");
        this.add((Component)this.iTextField, "Center");
        this.add((Component)iPanel, "East");
    }

    public void setModel(SSDefaultTableModel<T> iModel) {
        this.iModel = iModel;
        this.iObjects = iModel.getObjects();
        this.iTable.setModel(iModel);
    }

    public void setSearchColumns(int ... pSearchColumns) {
        this.iSearchColumns = pSearchColumns;
    }

    public void setColumnWidths(int ... pColumnWidths) {
        int index = 0;
        for (int pColumnWidth : pColumnWidths) {
            this.iTable.getColumnModel().getColumn(index).setPreferredWidth(pColumnWidth);
            ++index;
        }
    }

    public void setPopupSize(Dimension pPopupSize) {
        this.iPopup.setPreferredSize(pPopupSize);
    }

    public void setPopupSize(int pWidth, int pHeight) {
        this.setPopupSize(new Dimension(pWidth, pHeight));
    }

    public void setAllowCustomValues(boolean iAllowCustomValues) {
        this.iAllowCustomValues = iAllowCustomValues;
        if (iAllowCustomValues) {
            this.iTextField.setForeground(Color.BLACK);
        } else {
            this.iTextField.setForeground(this.iSelected == null ? Color.RED : Color.BLACK);
        }
    }

    public boolean doAllowCustomValues() {
        return this.iAllowCustomValues;
    }

    public void setSelected(T pSelected, boolean pNotifyListeners) {
        this.iSelected = pSelected;
        if (this.iSelected != null) {
            this.iTextField.setText(this.iSelected.toRenderString());
        } else {
            this.iTextField.setText("");
        }
        if (this.iAllowCustomValues) {
            this.iTextField.setForeground(Color.BLACK);
        } else {
            this.iTextField.setForeground(this.iSelected == null ? Color.RED : Color.BLACK);
        }
        if (pNotifyListeners) {
            this.notifySelectionListeners((SSTableSearchable)pSelected);
        }
    }

    public void setSelected(T pSelected) {
        this.setSelected(pSelected, false);
    }

    public T getSelected() {
        return this.iSelected;
    }

    public boolean hasSelected() {
        return this.iSelected != null;
    }

    public T getFirst() {
        if (!this.iObjects.isEmpty()) {
            return (T)((SSTableSearchable)this.iObjects.get(0));
        }
        return null;
    }

    public String getText() {
        if (this.iAllowCustomValues) {
            return this.iTextField.getText();
        }
        return this.iSelected == null ? null : this.iSelected.toRenderString();
    }

    public void setText(String pText) {
        this.iTextField.setText(pText);
        this.searchTable();
    }

    private boolean searchTable() {
        String iText = this.iTextField.getText();
        if (this.iSearchColumns.length == 0) {
            return true;
        }
        LinkedList<T> iVisible = new LinkedList<T>();
        this.iModel.setObjects(this.iObjects);
        int size = this.iObjects.size();
        block0: for (int i = 0; i < size; ++i) {
            for (int c : this.iSearchColumns) {
                Object value = this.iModel.getValueAt(i, c);
                if (!this.compareTo(c, iText, value)) continue;
                iVisible.add(this.iModel.getObject(i));
                continue block0;
            }
        }
        this.iModel.setObjects(iVisible);
        this.iModel.fireTableDataChanged();
        return !iVisible.isEmpty();
    }

    protected boolean compareTo(int column, String text, Object value) {
        if (value == null || text == null) {
            return true;
        }
        String iString = value.toString();
        return iString.length() == 0 || iString.toLowerCase().startsWith(text.toLowerCase());
    }

    public void startEdit() {
        this.iPopup.show(this, 0, this.getHeight());
    }

    public void stopEdit() {
        this.iModel.setObjects(this.iObjects);
        this.iModel.fireTableDataChanged();
        this.iPopup.setVisible(false);
    }

    public void cancelCellEditing() {
        this.stopEdit();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        super.processKeyBinding(ks, e, condition, pressed);
        return this.iTextField.processKeyBinding(ks, e, condition, pressed);
    }

    public void addChangeListener(final ActionListener pAction) {
        this.iTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                pAction.actionPerformed(null);
            }
        });
    }

    public void addSelectionListener(SSSelectionListener<T> pAction) {
        this.iSelectionListeners.add(pAction);
    }

    private void notifySelectionListeners(SSTableSearchable pSelected) {
        for (SSSelectionListener iSelectionListener : this.iSelectionListeners) {
            iSelectionListener.selected(pSelected);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.iTextField.setEditable(enabled);
        this.iDropdownButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public Document getDocument() {
        return this.iTextField.getDocument();
    }

    public SSDefaultTableModel<T> getModel() {
        return this.iModel;
    }

    public static CellEditor<?> createAsCellEditor(SSDefaultTableModel<?> iModel) {
        return new CellEditor(iModel);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.components.SSTableComboBoxOld");
        sb.append("{iAllowCustomValues=").append(this.iAllowCustomValues);
        sb.append(", iDropdownButton=").append(this.iDropdownButton);
        sb.append(", iEditor=").append(this.iEditor);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iObjects=").append(this.iObjects);
        sb.append(", iPopup=").append(this.iPopup);
        sb.append(", iSearchColumns=").append(this.iSearchColumns == null ? "null" : "");
        for (int i = 0; this.iSearchColumns != null && i < this.iSearchColumns.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.iSearchColumns[i]);
        }
        sb.append(", iSelected=").append(this.iSelected);
        sb.append(", iSelectionListeners=").append(this.iSelectionListeners);
        sb.append(", iTable=").append(this.iTable);
        sb.append(", iTextField=").append(this.iTextField);
        sb.append('}');
        return sb.toString();
    }

    public static class CellEditor<T extends SSTableSearchable>
    extends DefaultCellEditor {
        private SSTableComboBoxOld<T> iComboBox = new SSTableComboBoxOld();
        private JTable iCurrentTable;
        private int iCurrentRow;
        private int iCurrentColumn;

        public CellEditor() {
            super(new JTextField());
            this.iComboBox.iEditor = this;
        }

        public CellEditor(SSDefaultTableModel<T> pModel) {
            this();
            this.setModel(pModel);
        }

        protected void setModel(SSDefaultTableModel<T> pModel) {
            this.iComboBox.setModel(pModel);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.iCurrentTable = table;
            this.iCurrentRow = row;
            this.iCurrentColumn = column;
            if (value != null && value instanceof SSTableSearchable) {
                ((SSTableComboBoxOld)this.iComboBox).iSelected = (SSTableSearchable)value;
                this.iComboBox.iTextField.setText(((SSTableSearchable)value).toRenderString());
                if (((SSTableComboBoxOld)this.iComboBox).searchTable()) {
                    this.iComboBox.iTable.setRowSelectionInterval(0, 0);
                }
            } else {
                if (value == null) {
                    this.iComboBox.iTextField.setText("");
                } else {
                    this.iComboBox.iTextField.setText(value.toString());
                }
                ((SSTableComboBoxOld)this.iComboBox).searchTable();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((CellEditor)CellEditor.this).iComboBox.iTextField.requestFocus();
                }
            });
            return this.iComboBox;
        }

        @Override
        public Component getComponent() {
            return this.iComboBox.iTextField;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.iComboBox.getSelected() == null && this.iComboBox.doAllowCustomValues()) {
                return this.iComboBox.getText();
            }
            return this.iComboBox.getSelected();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            MouseEvent e;
            if (anEvent == null) {
                return true;
            }
            if (anEvent instanceof MouseEvent && (e = (MouseEvent)anEvent).getClickCount() != 2) {
                return false;
            }
            JTable table = (JTable)anEvent.getSource();
            TableModel model = table.getModel();
            int row = table.getSelectedRow();
            int col = table.getSelectedColumn();
            return row == -1 || model.isCellEditable(row, col);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.iComboBox.iPopup.setVisible(false);
            return super.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.iComboBox.iPopup.setVisible(false);
            super.fireEditingCanceled();
        }

        private void transferFocusToTable() {
            this.iCurrentTable.changeSelection(this.iCurrentRow, this.iCurrentColumn, false, false);
            this.iCurrentTable.requestFocusInWindow();
        }

        public void setSearchColumns(int ... pSearchColumns) {
            this.iComboBox.setSearchColumns(pSearchColumns);
        }

        public void setColumnWidths(int ... pColumnWidths) {
            this.iComboBox.setColumnWidths(pColumnWidths);
        }

        public void setPopupSize(Dimension pPopupSize) {
            this.iComboBox.setPopupSize(pPopupSize);
        }

        public void setPopupSize(int pWidth, int pHeight) {
            this.iComboBox.setPopupSize(pWidth, pHeight);
        }

        public void setAllowCustomValues(boolean iAllowCustomValues) {
            this.iComboBox.setAllowCustomValues(iAllowCustomValues);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.util.components.SSTableComboBoxOld.CellEditor");
            sb.append("{iComboBox=").append(this.iComboBox);
            sb.append(", iCurrentColumn=").append(this.iCurrentColumn);
            sb.append(", iCurrentRow=").append(this.iCurrentRow);
            sb.append(", iCurrentTable=").append(this.iCurrentTable);
            sb.append('}');
            return sb.toString();
        }
    }
}

