/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.datechooser.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SSDayChooser
implements ActionListener {
    private static Color WEEK_COLOR = new Color(100, 100, 100);
    private static Color BACKGROUND_COLOR = new Color(210, 228, 238);
    private static Color sundayForeground = new Color(164, 0, 0);
    private static Color weekdayForeground = new Color(0, 90, 164);
    private static Color SELECTED_COLOR = new Color(160, 160, 160);
    private JPanel iPanel;
    private JPanel iDayPanel;
    private JPanel iDayNamePanel;
    private JPanel iWeekNamePanel;
    private List<DayButton> iDayButtons;
    private List<JLabel> iDayNames;
    private List<JLabel> iWeekNames;
    private Date iDate;
    private List<ActionListener> iChangeListeners;

    public SSDayChooser() {
        JLabel iLabel;
        int i;
        this.$$$setupUI$$$();
        this.iChangeListeners = new LinkedList<ActionListener>();
        this.iPanel.setBackground(BACKGROUND_COLOR);
        this.iDayPanel.setLayout(new GridLayout(6, 7));
        this.iDayPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.iDayNamePanel.setLayout(new GridLayout(1, 7));
        this.iDayNamePanel.setOpaque(false);
        this.iDayNamePanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.iWeekNamePanel.setLayout(new GridLayout(6, 1));
        this.iWeekNamePanel.setOpaque(false);
        this.iWeekNamePanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.iDayButtons = new LinkedList<DayButton>();
        for (i = 0; i < 42; ++i) {
            DayButton iButton = new DayButton();
            iButton.setText(Integer.toString(i + 1));
            iButton.addActionListener(this);
            iButton.setContentAreaFilled(true);
            this.iDayButtons.add(iButton);
            this.iDayPanel.add(iButton);
        }
        this.iDayNames = new LinkedList<JLabel>();
        for (i = 0; i < 7; ++i) {
            iLabel = new JLabel();
            iLabel.setOpaque(false);
            iLabel.setHorizontalAlignment(0);
            iLabel.setVerticalAlignment(0);
            this.iDayNames.add(iLabel);
            this.iDayNamePanel.add(iLabel);
        }
        this.iWeekNames = new LinkedList<JLabel>();
        for (i = 0; i < 6; ++i) {
            iLabel = new JLabel();
            iLabel.setOpaque(false);
            iLabel.setHorizontalAlignment(0);
            iLabel.setVerticalAlignment(0);
            iLabel.setForeground(WEEK_COLOR);
            this.iWeekNames.add(iLabel);
            this.iWeekNamePanel.add(iLabel);
        }
        this.setDate(new Date());
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
        this.updateDayColumns();
        this.updateDays();
        this.updateWeeks();
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    private void updateDayColumns() {
        Calendar iCalendar = Calendar.getInstance();
        String[] iDayNames = new DateFormatSymbols().getShortWeekdays();
        int day = iCalendar.getFirstDayOfWeek();
        for (JLabel iLabel : this.iDayNames) {
            iLabel.setText(iDayNames[day]);
            if (day == 1) {
                iLabel.setForeground(sundayForeground);
            } else {
                iLabel.setForeground(weekdayForeground);
            }
            if (day < 7) {
                ++day;
                continue;
            }
            day -= 6;
        }
    }

    private void updateWeeks() {
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTime(this.iDate);
        iCalendar.set(5, 1);
        for (JLabel iLabel : this.iWeekNames) {
            int iWeekNumber = iCalendar.get(3);
            if (iWeekNumber < 10) {
                iLabel.setText('0' + Integer.toString(iWeekNumber));
            } else {
                iLabel.setText(Integer.toString(iWeekNumber));
            }
            iCalendar.add(3, 1);
        }
    }

    private void updateDays() {
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTime(this.iDate);
        int iMonth = iCalendar.get(2);
        iCalendar.set(5, 1);
        int iStart = iCalendar.get(7) - iCalendar.getFirstDayOfWeek();
        if (iStart < 0) {
            iStart += 7;
        }
        int iStop = iStart + iCalendar.getActualMaximum(5);
        DateFormat iFormat = DateFormat.getDateInstance(1);
        int iIndex = 0;
        for (DayButton iButton : this.iDayButtons) {
            int iDay = iCalendar.get(5);
            if (iIndex >= iStart && iIndex < iStop) {
                Date iCurrentDate = iCalendar.getTime();
                iButton.setVisible(true);
                iButton.setText(Integer.toString(iDay));
                iButton.setToolTipText(iFormat.format(iCurrentDate));
                iButton.setDate(iCurrentDate);
                if (iCurrentDate.equals(this.iDate)) {
                    iButton.setBackground(SELECTED_COLOR);
                } else {
                    iButton.setBackground(new JButton().getBackground());
                }
                iCalendar.add(5, 1);
            } else {
                iButton.setVisible(false);
                iButton.setDate(null);
            }
            ++iIndex;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof DayButton) {
            DayButton iButton = (DayButton)e.getSource();
            this.iDate = iButton.getDate();
            this.notifyChangeListeners();
        }
    }

    public void addChangeListener(ActionListener iActionListener) {
        this.iChangeListeners.add(iActionListener);
    }

    private void notifyChangeListeners() {
        ActionEvent iEvent = new ActionEvent(this, 0, "day");
        for (ActionListener iActionListener : this.iChangeListeners) {
            iActionListener.actionPerformed(iEvent);
        }
    }

    public void dispose() {
        this.iPanel.removeAll();
        this.iPanel = null;
        this.iDayPanel.removeAll();
        this.iDayPanel = null;
        this.iDayNamePanel.removeAll();
        this.iDayNamePanel = null;
        this.iWeekNamePanel.removeAll();
        this.iWeekNamePanel = null;
        for (DayButton iDayButton : this.iDayButtons) {
            ActionListener[] iActionListeners;
            for (ActionListener iActionListener : iActionListeners = iDayButton.getActionListeners()) {
                iDayButton.removeActionListener(iActionListener);
            }
        }
        this.iDayButtons.removeAll(this.iDayButtons);
        this.iDayButtons = null;
        this.iDayNames.removeAll(this.iDayNames);
        this.iDayNames = null;
        this.iWeekNames.removeAll(this.iWeekNames);
        this.iWeekNames = null;
        this.iDate = null;
        this.iChangeListeners.removeAll(this.iChangeListeners);
        this.iChangeListeners = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.datechooser.panel.SSDayChooser");
        sb.append("{iChangeListeners=").append(this.iChangeListeners);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iDayButtons=").append(this.iDayButtons);
        sb.append(", iDayNamePanel=").append(this.iDayNamePanel);
        sb.append(", iDayNames=").append(this.iDayNames);
        sb.append(", iDayPanel=").append(this.iDayPanel);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iWeekNamePanel=").append(this.iWeekNamePanel);
        sb.append(", iWeekNames=").append(this.iWeekNames);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.iPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), 0, 0, false, false));
        this.iDayPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.iDayNamePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 1, null, null, null));
        this.iWeekNamePanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 1, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private class DayButton
    extends JButton {
        private Date iDate;

        public DayButton() {
            this.setMinimumSize(new Dimension(27, 21));
            this.setMaximumSize(new Dimension(27, 21));
            this.setPreferredSize(new Dimension(27, 21));
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setFocusPainted(false);
            this.setOpaque(false);
        }

        public Date getDate() {
            return this.iDate;
        }

        public void setDate(Date iDate) {
            this.iDate = iDate;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.util.datechooser.panel.SSDayChooser.DayButton");
            sb.append("{iDate=").append(this.iDate);
            sb.append('}');
            return sb.toString();
        }
    }
}

