/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.datechooser.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractSpinnerModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;

public class SSMonthChooser
implements ItemListener {
    private JPanel iPanel;
    private JComboBox iComboBox;
    private JSpinner iSpinner;
    private Date iDate;
    private List<ActionListener> iChangeListeners;

    public SSMonthChooser() {
        this.$$$setupUI$$$();
        this.iChangeListeners = new LinkedList<ActionListener>();
        this.iComboBox = new JComboBox();
        this.iComboBox.addItemListener(this);
        this.iComboBox.setBorder(BorderFactory.createEmptyBorder());
        this.iComboBox.setLightWeightPopupEnabled(true);
        this.iSpinner.setEditor(this.iComboBox);
        this.iSpinner.setModel(new MonthSpinnerModel());
        this.updateMonthNames();
        this.setDate(new Date());
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTime(iDate);
        ComboBoxModel iComboBoxModel = this.iComboBox.getModel();
        int iIndex = iCalendar.get(2);
        iComboBoxModel.setSelectedItem(iComboBoxModel.getElementAt(iIndex));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int iMonth = this.iComboBox.getSelectedIndex();
        if (this.iDate != null && iMonth >= 0) {
            Calendar iCalendar = Calendar.getInstance();
            iCalendar.setTime(this.iDate);
            int iDay = iCalendar.get(5);
            iCalendar.set(5, 1);
            iCalendar.set(2, iMonth);
            if (iDay > iCalendar.getActualMaximum(5)) {
                iCalendar.set(5, iCalendar.getActualMaximum(5));
            } else {
                iCalendar.set(5, iDay);
            }
            this.iDate = iCalendar.getTime();
            this.notifyChangeListeners();
        }
    }

    public void addChangeListener(ActionListener iActionListener) {
        this.iChangeListeners.add(iActionListener);
    }

    private void notifyChangeListeners() {
        ActionEvent iEvent = new ActionEvent(this, 0, "month");
        for (ActionListener iActionListener : this.iChangeListeners) {
            iActionListener.actionPerformed(iEvent);
        }
    }

    private void updateMonthNames() {
        String[] iMonths = new DateFormatSymbols().getMonths();
        this.iComboBox.removeAllItems();
        for (int i = 0; i < 12; ++i) {
            this.iComboBox.addItem(iMonths[i]);
        }
    }

    public void dispose() {
        ItemListener[] iItemListeners;
        this.iPanel.removeAll();
        this.iPanel = null;
        for (ItemListener iItemListener : iItemListeners = this.iComboBox.getItemListeners()) {
            this.iComboBox.removeItemListener(iItemListener);
        }
        this.iComboBox.removeAllItems();
        this.iComboBox = null;
        this.iSpinner.removeAll();
        this.iSpinner = null;
        this.iDate = null;
        this.iChangeListeners.removeAll(this.iChangeListeners);
        this.iChangeListeners = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.datechooser.panel.SSMonthChooser");
        sb.append("{iChangeListeners=").append(this.iChangeListeners);
        sb.append(", iComboBox=").append(this.iComboBox);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iSpinner=").append(this.iSpinner);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JSpinner jSpinner;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.iSpinner = jSpinner = new JSpinner();
        jPanel.add((Component)jSpinner, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private class MonthSpinnerModel
    extends AbstractSpinnerModel {
        private MonthSpinnerModel() {
        }

        @Override
        public Object getValue() {
            return SSMonthChooser.this.iComboBox.getSelectedItem();
        }

        @Override
        public void setValue(Object value) {
            SSMonthChooser.this.iComboBox.setSelectedItem(value);
        }

        @Override
        public Object getNextValue() {
            int iIndex = SSMonthChooser.this.iComboBox.getSelectedIndex();
            if (iIndex < 11) {
                return SSMonthChooser.this.iComboBox.getItemAt(iIndex + 1);
            }
            return SSMonthChooser.this.iComboBox.getItemAt(0);
        }

        @Override
        public Object getPreviousValue() {
            int iIndex = SSMonthChooser.this.iComboBox.getSelectedIndex();
            if (iIndex > 0) {
                return SSMonthChooser.this.iComboBox.getItemAt(iIndex - 1);
            }
            return SSMonthChooser.this.iComboBox.getItemAt(11);
        }
    }
}

