/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.datechooser.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SSYearChooser
extends JPanel
implements ChangeListener,
CaretListener,
ActionListener {
    private JPanel iPanel;
    private JSpinner iSpinner;
    private JTextField iTextField;
    private SpinnerNumberModel iModel;
    private Date iDate;
    private List<ActionListener> iChangeListeners;

    public SSYearChooser() {
        this.$$$setupUI$$$();
        this.setLayout(new BorderLayout());
        this.add((Component)this.iPanel, "Center");
        Calendar iCalendar = Calendar.getInstance();
        this.iChangeListeners = new LinkedList<ActionListener>();
        this.iTextField = new JTextField();
        this.iTextField.setBorder(BorderFactory.createEmptyBorder());
        this.iTextField.setHorizontalAlignment(4);
        this.iTextField.addCaretListener(this);
        this.iTextField.addActionListener(this);
        this.iModel = new SpinnerNumberModel();
        this.iModel.setMinimum(Integer.valueOf(iCalendar.getMinimum(1)));
        this.iModel.setMaximum(Integer.valueOf(iCalendar.getMaximum(1)));
        this.iModel.addChangeListener(this);
        this.iSpinner.setEditor(this.iTextField);
        this.iSpinner.setModel(this.iModel);
        this.setDate(new Date());
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTime(iDate);
        this.iSpinner.setValue(iCalendar.get(1));
    }

    public void addChangeListener(ActionListener iActionListener) {
        this.iChangeListeners.add(iActionListener);
    }

    private void notifyChangeListeners() {
        ActionEvent iEvent = new ActionEvent(this, 0, "year");
        for (ActionListener iActionListener : this.iChangeListeners) {
            iActionListener.actionPerformed(iEvent);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Calendar iCalendar = Calendar.getInstance();
        Number iNumber = this.iModel.getNumber();
        this.iTextField.setText(iNumber.toString());
        iCalendar.setTime(this.iDate);
        iCalendar.set(1, iNumber.intValue());
        this.iDate = iCalendar.getTime();
        this.notifyChangeListeners();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int iValue;
        Calendar iCalendar = Calendar.getInstance();
        try {
            iValue = Integer.decode(this.iTextField.getText());
        }
        catch (NumberFormatException e1) {
            this.iTextField.setForeground(Color.RED);
            return;
        }
        int iMin = iCalendar.getMinimum(1);
        int iMax = iCalendar.getMaximum(1);
        if (iValue < iMin || iValue > iMax) {
            this.iTextField.setForeground(Color.RED);
        } else {
            this.iTextField.setForeground(Color.BLACK);
        }
        this.iTextField.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            int iValue = Integer.decode(this.iTextField.getText());
            this.iModel.setValue(iValue);
        }
        catch (NumberFormatException e1) {
            e1.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dispose() {
        void var6_11;
        ChangeListener[] iChangeListenerss;
        this.iPanel.removeAll();
        this.iPanel = null;
        this.iSpinner.removeAll();
        this.iSpinner = null;
        ActionListener[] iActionListeners = this.iTextField.getActionListeners();
        CaretListener[] iCaretListeners = this.iTextField.getCaretListeners();
        for (ActionListener actionListener : iActionListeners) {
            this.iTextField.removeActionListener(actionListener);
        }
        for (EventListener eventListener : iCaretListeners) {
            this.iTextField.removeCaretListener((CaretListener)eventListener);
        }
        this.iTextField.removeAll();
        this.iTextField = null;
        ChangeListener[] changeListenerArray = iChangeListenerss = this.iModel.getChangeListeners();
        int n = changeListenerArray.length;
        boolean bl = false;
        while (var6_11 < n) {
            ChangeListener iChangeListener = changeListenerArray[var6_11];
            this.iModel.removeChangeListener(iChangeListener);
            ++var6_11;
        }
        this.iModel = null;
        this.iDate = null;
        this.iChangeListeners.removeAll(this.iChangeListeners);
        this.iChangeListeners = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.datechooser.panel.SSYearChooser");
        sb.append("{iChangeListeners=").append(this.iChangeListeners);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iSpinner=").append(this.iSpinner);
        sb.append(", iTextField=").append(this.iTextField);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JSpinner jSpinner;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.iSpinner = jSpinner = new JSpinner();
        jPanel.add((Component)jSpinner, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }
}

