/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.dialogs;

import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.graphics.SSIcon;

public class SSConfirmDialog {
    private String iTitle;
    private String iMessage;

    public SSConfirmDialog(String pBundleName) {
        this.iMessage = SSBundle.getBundle().getString(pBundleName + ".message");
        this.iTitle = SSBundle.getBundle().getString(pBundleName + ".title");
    }

    public SSConfirmDialog(String pBundleName, Object ... pMessageFormat) {
        this.iTitle = SSBundle.getBundle().getString(pBundleName + ".title");
        this.iMessage = String.format(SSBundle.getBundle().getString(pBundleName + ".message"), pMessageFormat);
    }

    public int openDialog(JFrame iFrame) {
        ImageIcon iIcon = SSIcon.getIcon("ICON_DIALOG_INFORMATION");
        JOptionPane optionPane = new JOptionPane(this.iMessage, 1, 0, iIcon);
        optionPane.setValue(-1);
        SSDialog dialog = new SSDialog(iFrame, this.iTitle);
        dialog.setOptionPane(optionPane);
        dialog.pack();
        return dialog.showDialog(iFrame);
    }

    public int openDialog(JDialog iDialog) {
        ImageIcon iIcon = SSIcon.getIcon("ICON_DIALOG_INFORMATION");
        JOptionPane optionPane = new JOptionPane(this.iMessage, 1, 0, iIcon);
        optionPane.setValue(-1);
        SSDialog dialog = new SSDialog(iDialog, this.iTitle);
        dialog.setOptionPane(optionPane);
        dialog.pack();
        return dialog.showDialog(iDialog);
    }

    public static int showDialog(JFrame iFrame, String iTitle, String iMessage) {
        ImageIcon iIcon = SSIcon.getIcon("ICON_DIALOG_INFORMATION");
        JOptionPane optionPane = new JOptionPane(iMessage, 1, 0, iIcon);
        optionPane.setValue(-1);
        SSDialog dialog = new SSDialog(iFrame, iTitle);
        dialog.setOptionPane(optionPane);
        dialog.pack();
        return dialog.showDialog(iFrame);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.dialogs.SSConfirmDialog");
        sb.append("{iMessage='").append(this.iMessage).append('\'');
        sb.append(", iTitle='").append(this.iTitle).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

