/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.dialogs;

import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.graphics.SSIcon;

public class SSQueryDialog {
    private JOptionPane iOptionPane;

    public SSQueryDialog(JFrame iFrame, String pBundleName) {
        this(iFrame, 0, pBundleName);
    }

    public SSQueryDialog(JFrame iFrame, ResourceBundle iBundle, String pBundleName, Object ... pMessageFormat) {
        String title = iBundle.getString(pBundleName + ".title");
        String message = String.format(iBundle.getString(pBundleName + ".message"), pMessageFormat);
        this.openDialog(iFrame, 0, title, message);
    }

    public SSQueryDialog(JFrame iFrame, int pOptionType, String pBundleName) {
        String title = SSBundle.getBundle().getString(pBundleName + ".title");
        String message = SSBundle.getBundle().getString(pBundleName + ".message");
        this.openDialog(iFrame, pOptionType, title, message);
    }

    public SSQueryDialog(JFrame iFrame, int pOptionType, String iTitle, String iMessage) {
        this.openDialog(iFrame, pOptionType, iTitle, iMessage);
    }

    private int openDialog(JFrame iFrame, int pOptionType, String pTitle, String pMessage) {
        ImageIcon iIcon = SSIcon.getIcon("ICON_DIALOG_INFORMATION");
        this.iOptionPane = new JOptionPane(pMessage, 3, pOptionType, iIcon);
        this.iOptionPane.setValue(-1);
        SSDialog dialog = new SSDialog(iFrame, pTitle);
        dialog.setOptionPane(this.iOptionPane);
        dialog.pack();
        dialog.setLocationRelativeTo(iFrame);
        dialog.setVisible();
        return (Integer)this.iOptionPane.getValue();
    }

    public int getResponce() {
        return this.iOptionPane == null ? -1 : (Integer)this.iOptionPane.getValue();
    }

    public static int showDialog(JFrame iFrame, String pBundleName) {
        SSQueryDialog iDialog = new SSQueryDialog(iFrame, pBundleName);
        return iDialog.getResponce();
    }

    public static int showDialog(JFrame iFrame, ResourceBundle iBundle, String pBundleName, Object ... pMessageFormat) {
        SSQueryDialog iDialog = new SSQueryDialog(iFrame, iBundle, pBundleName, pMessageFormat);
        return iDialog.getResponce();
    }

    public static int showDialog(JFrame iFrame, int pOptionType, String pBundleName) {
        SSQueryDialog iDialog = new SSQueryDialog(iFrame, pOptionType, pBundleName);
        return iDialog.getResponce();
    }

    public static int showDialog(JFrame iFrame, int pOptionType, String pTitle, String iMessage) {
        SSQueryDialog iDialog = new SSQueryDialog(iFrame, pOptionType, pTitle, iMessage);
        return iDialog.getResponce();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog");
        sb.append("{iOptionPane=").append(this.iOptionPane);
        sb.append('}');
        return sb.toString();
    }
}

