/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.filechooser.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class SSImagePreview
extends JComponent
implements PropertyChangeListener {
    private ImageIcon iThumbnail;
    private File iFile;

    public SSImagePreview(JFileChooser pFileChooser) {
        this.setPreferredSize(new Dimension(100, 50));
        pFileChooser.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.iFile == null) {
            this.iThumbnail = null;
            return;
        }
        ImageIcon tmpIcon = new ImageIcon(this.iFile.getPath());
        if (tmpIcon != null) {
            this.iThumbnail = tmpIcon.getIconWidth() > 90 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(90, -1, 1)) : tmpIcon;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.iFile = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.iFile = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.iThumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.iThumbnail == null) {
            this.loadImage();
        }
        if (this.iThumbnail != null) {
            int x = this.getWidth() / 2 - this.iThumbnail.getIconWidth() / 2;
            int y = 0;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.iThumbnail.paintIcon(this, g, x, y);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.filechooser.util.SSImagePreview");
        sb.append("{iFile=").append(this.iFile);
        sb.append(", iThumbnail=").append(this.iThumbnail);
        sb.append('}');
        return sb.toString();
    }
}

