/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.frame;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import se.swedsoft.bookkeeping.data.util.SSConfig;
import se.swedsoft.bookkeeping.gui.util.frame.SSInternalFrame;

public class SSFrameManager {
    private static final int FRAME_OFFSET = 20;
    private static final int FRAME_RESET = 20;
    private static SSFrameManager cInstance;
    private Set<SSInternalFrame> iFrames = new HashSet<SSInternalFrame>();
    private List<ActionListener> iFrameListeners = new LinkedList<ActionListener>();

    public static SSFrameManager getInstance() {
        if (cInstance == null) {
            cInstance = new SSFrameManager();
        }
        return cInstance;
    }

    private SSFrameManager() {
    }

    public Set<SSInternalFrame> getFrames() {
        return Collections.unmodifiableSet(this.iFrames);
    }

    public synchronized void addFrame(SSInternalFrame iFrame) {
        this.iFrames.add(iFrame);
        iFrame.addInternalFrameListener(new FrameListener(iFrame));
        this.notifyFrameListeners();
    }

    public synchronized void removeFrame(SSInternalFrame iFrame) {
        this.iFrames.remove(iFrame);
        this.notifyFrameListeners();
    }

    public void addFrameListener(ActionListener iActionListener) {
        this.iFrameListeners.add(iActionListener);
    }

    private void notifyFrameListeners() {
        ActionEvent iAction = new ActionEvent(this, 0, "");
        for (ActionListener iActionListener : this.iFrameListeners) {
            iActionListener.actionPerformed(iAction);
        }
    }

    public synchronized void cascade() {
        LinkedList<SSInternalFrame> iFramesToCascade = new LinkedList<SSInternalFrame>(this.iFrames);
        Collections.sort(iFramesToCascade, new Comparator<SSInternalFrame>(){

            @Override
            public int compare(SSInternalFrame o1, SSInternalFrame o2) {
                String iTitle1 = o1.getTitle();
                String iTitle2 = o2.getTitle();
                if (iTitle1 == null || iTitle2 == null) {
                    return 0;
                }
                return iTitle1.compareTo(iTitle2);
            }
        });
        int iFrameCounter = 1;
        for (SSInternalFrame iFrame : iFramesToCascade) {
            int x = iFrameCounter * 20;
            int y = iFrameCounter * 20;
            if (iFrameCounter == 20) {
                iFrameCounter = 0;
            }
            ++iFrameCounter;
            iFrame.setLocation(x, y);
            iFrame.deIconize();
            this.storeFrame(iFrame);
        }
    }

    public synchronized void close() {
        HashSet<SSInternalFrame> iFramesToClose = new HashSet<SSInternalFrame>(this.iFrames);
        this.iFrames.clear();
        for (SSInternalFrame iFrame : iFramesToClose) {
            this.storeFrame(iFrame);
            iFrame.setVisible(false);
            iFrame.dispose();
        }
        this.notifyFrameListeners();
    }

    public void storeFrame(SSInternalFrame iFrame) {
        String iName = iFrame.getClass().getName();
        Point iLocation = iFrame.getLocation();
        Dimension iSize = iFrame.getSize();
        if (iLocation != null) {
            SSConfig.getInstance().set(iName + ".location", iLocation);
        }
        if (iSize != null) {
            SSConfig.getInstance().set(iName + ".size", iSize);
        }
    }

    public void restoreFrame(SSInternalFrame iFrame) {
        String iName = iFrame.getClass().getName();
        Point iLocation = (Point)SSConfig.getInstance().get(iName + ".location");
        Dimension iSize = (Dimension)SSConfig.getInstance().get(iName + ".size");
        if (iSize != null) {
            if (iSize.width < 80) {
                iSize.width = 80;
            }
            if (iSize.height < 60) {
                iSize.height = 60;
            }
            iFrame.setSize(iSize);
        }
        if (iLocation != null) {
            if (iLocation.x < 0) {
                iLocation.x = 20 * (this.iFrames.size() % 20);
            }
            if (iLocation.y < 0) {
                iLocation.y = 20 * (this.iFrames.size() % 20);
            }
            iFrame.setLocation(iLocation);
        }
    }

    public void storeAllFrames() {
        HashSet<SSInternalFrame> iFramesToStore = new HashSet<SSInternalFrame>(this.iFrames);
        for (SSInternalFrame iFrame : iFramesToStore) {
            this.storeFrame(iFrame);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.frame.SSFrameManager");
        sb.append("{iFrameListeners=").append(this.iFrameListeners);
        sb.append(", iFrames=").append(this.iFrames);
        sb.append('}');
        return sb.toString();
    }

    private class FrameListener
    extends InternalFrameAdapter {
        private SSInternalFrame iFrame;

        public FrameListener(SSInternalFrame iFrame) {
            this.iFrame = iFrame;
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent e) {
            SSFrameManager.this.restoreFrame(this.iFrame);
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            SSFrameManager.this.storeFrame(this.iFrame);
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            SSFrameManager.this.removeFrame(this.iFrame);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.util.frame.SSFrameManager.FrameListener");
            sb.append("{iFrame=").append(this.iFrame);
            sb.append('}');
            return sb.toString();
        }
    }
}

