/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.graphics;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import se.swedsoft.bookkeeping.app.Path;

public class SSImage {
    private static Map<String, BufferedImage> graphics = new HashMap<String, BufferedImage>();

    private SSImage() {
        throw new AssertionError((Object)"Don't instantiate this class");
    }

    private static void loadImage(String name, String filename) {
        if (graphics.containsKey(name)) {
            System.out.println("(SSImage): Already loaded image: " + name);
            return;
        }
        URL url = Path.class.getResource("/graphics/" + filename);
        BufferedImage image = null;
        try {
            image = ImageIO.read(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (image != null) {
            graphics.put(name, image);
        } else {
            System.out.println("(SSImage): Failed to load image: " + filename);
        }
    }

    public static boolean hasImage(String name) {
        return graphics.containsKey(name);
    }

    public static BufferedImage getImage(String name) {
        if (!graphics.containsKey(name)) {
            System.out.println("(SSImage): Image not found: " + name);
        }
        return graphics.get(name);
    }

    static {
        SSImage.loadImage("BACKGROUND", "Background.png");
        SSImage.loadImage("LOGO", "logo.png");
        SSImage.loadImage("OCRAVI", "OCRAvi.png");
        SSImage.loadImage("OCRBackground", "OCRBackground.png");
        SSImage.loadImage("CHECK", "Check.png");
        SSImage.loadImage("SERVER", "Server.png");
        SSImage.loadImage("ICON_LOGO", "Logo_Icon16.png");
    }
}

