/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.model;

import java.math.BigDecimal;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.table.TableCellRenderer;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSCurrencyDialog;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSCurrencyTableModel
extends SSTableModel<SSCurrency> {
    public static SSTableColumn<SSCurrency> COLUMN_NAME = new SSTableColumn<SSCurrency>(SSBundle.getBundle().getString("currencytable.column.1")){

        @Override
        public Object getValue(SSCurrency iCurrency) {
            return iCurrency.getName();
        }

        @Override
        public void setValue(SSCurrency iCurrency, Object iValue) {
            iCurrency.setName((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<SSCurrency> COLUMN_DESCRIPTION = new SSTableColumn<SSCurrency>(SSBundle.getBundle().getString("currencytable.column.2")){

        @Override
        public Object getValue(SSCurrency iCurrency) {
            return iCurrency.getDescription();
        }

        @Override
        public void setValue(SSCurrency iCurrency, Object iValue) {
            iCurrency.setDescription((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 200;
        }
    };
    public static SSTableColumn<SSCurrency> COLUMN_EXCHANGERATE = new SSTableColumn<SSCurrency>(SSBundle.getBundle().getString("currencytable.column.3")){

        @Override
        public Object getValue(SSCurrency iCurrency) {
            return iCurrency.getExchangeRate();
        }

        @Override
        public void setValue(SSCurrency iCurrency, Object iValue) {
            iCurrency.setExchangeRate((BigDecimal)iValue);
        }

        @Override
        public Class getColumnClass() {
            return BigDecimal.class;
        }

        @Override
        public int getDefaultWidth() {
            return 80;
        }

        @Override
        public TableCellRenderer getCellRenderer() {
            return new SSBigDecimalCellRenderer(8);
        }
    };

    public SSCurrencyTableModel() {
        super(SSDB.getInstance().getCurrencies());
    }

    public SSCurrencyTableModel(List<SSCurrency> iCurrencies) {
        super(iCurrencies);
    }

    @Override
    public Class getType() {
        return SSCurrency.class;
    }

    public SSCurrencyTableModel getDropdownmodel() {
        return SSCurrencyTableModel.getDropDownModel(SSDB.getInstance().getCurrencies());
    }

    public static SSCurrencyTableModel getDropDownModel() {
        return SSCurrencyTableModel.getDropDownModel(SSDB.getInstance().getCurrencies());
    }

    public static SSCurrencyTableModel getDropDownModel(List<SSCurrency> iCurrencies) {
        SSCurrencyTableModel iModel = new SSCurrencyTableModel(iCurrencies);
        iModel.addColumn(COLUMN_NAME);
        iModel.addColumn(COLUMN_DESCRIPTION);
        iModel.addColumn(COLUMN_EXCHANGERATE);
        return iModel;
    }

    public static SSEditableTableComboBox.EditingFactory<SSCurrency> getEditingFactory(final JDialog iOwner) {
        return new SSEditableTableComboBox.EditingFactory<SSCurrency>(){

            @Override
            public SSCurrency newAction() {
                SSCurrencyDialog iDialog = new SSCurrencyDialog(iOwner);
                if (iDialog.showDialog() == 0) {
                    SSCurrency iCurrency = new SSCurrency();
                    iCurrency.setName(iDialog.getName());
                    iCurrency.setDescription(iDialog.getDescription());
                    iCurrency.setExchangeRate(iDialog.getExchangeRate());
                    SSDB.getInstance().addCurrency(iCurrency);
                    return iCurrency;
                }
                return null;
            }

            @Override
            public void editAction(SSCurrency iSelected) {
                SSCurrencyDialog iDialog = new SSCurrencyDialog(iOwner);
                iDialog.setName(iSelected.getName());
                iDialog.setDescription(iSelected.getDescription());
                iDialog.setExchangeRate(iSelected.getExchangeRate());
                if (iDialog.showDialog() == 0) {
                    iSelected.setName(iDialog.getName());
                    iSelected.setDescription(iDialog.getDescription());
                    iSelected.setExchangeRate(iDialog.getExchangeRate());
                    SSDB.getInstance().updateCurrency(iSelected);
                }
            }

            @Override
            public void deleteAction(SSCurrency iSelected) {
                SSDB.getInstance().deleteCurrency(iSelected);
            }
        };
    }
}

