/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.model;

import java.util.List;
import javax.swing.JDialog;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSNameDescriptionDialog;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSPaymentTermTableModel
extends SSTableModel<SSPaymentTerm> {
    public static SSTableColumn<SSPaymentTerm> COLUMN_NAME = new SSTableColumn<SSPaymentTerm>(SSBundle.getBundle().getString("currencytable.column.1")){

        @Override
        public Object getValue(SSPaymentTerm iCurrency) {
            return iCurrency.getName();
        }

        @Override
        public void setValue(SSPaymentTerm iCurrency, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<SSPaymentTerm> COLUMN_DESCRIPTION = new SSTableColumn<SSPaymentTerm>(SSBundle.getBundle().getString("currencytable.column.2")){

        @Override
        public Object getValue(SSPaymentTerm iCurrency) {
            return iCurrency.getDescription();
        }

        @Override
        public void setValue(SSPaymentTerm iCurrency, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 200;
        }
    };

    public SSPaymentTermTableModel() {
        super(SSDB.getInstance().getPaymentTerms());
    }

    public SSPaymentTermTableModel(List<SSPaymentTerm> iPaymentTerms) {
        super(iPaymentTerms);
    }

    @Override
    public Class getType() {
        return SSPaymentTerm.class;
    }

    public SSPaymentTermTableModel getDropdownmodel() {
        return SSPaymentTermTableModel.getDropDownModel();
    }

    public static SSPaymentTermTableModel getDropDownModel() {
        SSPaymentTermTableModel iModel = new SSPaymentTermTableModel();
        iModel.addColumn(COLUMN_NAME);
        iModel.addColumn(COLUMN_DESCRIPTION);
        return iModel;
    }

    public static SSEditableTableComboBox.EditingFactory<SSPaymentTerm> getEditingFactory(final JDialog iOwner) {
        return new SSEditableTableComboBox.EditingFactory<SSPaymentTerm>(){

            @Override
            public SSPaymentTerm newAction() {
                SSNameDescriptionDialog iDialog = new SSNameDescriptionDialog(iOwner, SSBundle.getBundle().getString("paymenttermtable.title"));
                if (iDialog.showDialog() == 0) {
                    SSPaymentTerm iPaymentTerm = new SSPaymentTerm();
                    iPaymentTerm.setName(iDialog.getName());
                    iPaymentTerm.setDescription(iDialog.getDescription());
                    SSDB.getInstance().addPaymentTerm(iPaymentTerm);
                    return iPaymentTerm;
                }
                return null;
            }

            @Override
            public void editAction(SSPaymentTerm iSelected) {
                SSNameDescriptionDialog iDialog = new SSNameDescriptionDialog(iOwner, SSBundle.getBundle().getString("paymenttermtable.title"));
                iDialog.setName(iSelected.getName());
                iDialog.setDescription(iSelected.getDescription());
                if (iDialog.showDialog() == 0) {
                    iSelected.setName(iDialog.getName());
                    iSelected.setDescription(iDialog.getDescription());
                    SSDB.getInstance().updatePaymentTerm(iSelected);
                }
            }

            @Override
            public void deleteAction(SSPaymentTerm iSelected) {
                SSDB.getInstance().deletePaymentTerm(iSelected);
            }
        };
    }
}

