/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.model;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSTaxCodeTableModel
extends SSTableModel<SSTaxCode> {
    private Map<SSTaxCode, BigDecimal> iValues;

    public SSTaxCodeTableModel() {
        super(SSTaxCode.values());
        this.iValues = new HashMap<SSTaxCode, BigDecimal>();
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.iValues.put(SSTaxCode.TAXRATE_0, new BigDecimal(0));
            this.iValues.put(SSTaxCode.TAXRATE_1, iCompany.getTaxRate1());
            this.iValues.put(SSTaxCode.TAXRATE_2, iCompany.getTaxRate2());
            this.iValues.put(SSTaxCode.TAXRATE_3, iCompany.getTaxRate3());
        }
    }

    public SSTaxCodeTableModel(Map<SSTaxCode, BigDecimal> iValues) {
        super(SSTaxCode.values());
        this.iValues = iValues;
    }

    @Override
    public Class getType() {
        return SSTaxCode.class;
    }

    public SSTableColumn<SSTaxCode> getValueColumn() {
        return new ValueColumn();
    }

    public static SSTaxCodeTableModel getDropDownModel() {
        SSTaxCodeTableModel iModel = new SSTaxCodeTableModel();
        iModel.addColumn(iModel.getValueColumn());
        iModel.sort();
        return iModel;
    }

    public static SSTaxCodeTableModel getDropDownModel(Map<SSTaxCode, BigDecimal> iValues) {
        SSTaxCodeTableModel iModel = new SSTaxCodeTableModel(iValues);
        iModel.addColumn(iModel.getValueColumn());
        iModel.sort();
        return iModel;
    }

    public void sort() {
        Collections.sort(this.getObjects(), new Comparator<SSTaxCode>(){

            @Override
            public int compare(SSTaxCode o1, SSTaxCode o2) {
                BigDecimal iValue1 = (BigDecimal)SSTaxCodeTableModel.this.iValues.get(o1);
                BigDecimal iValue2 = (BigDecimal)SSTaxCodeTableModel.this.iValues.get(o2);
                return iValue1 == null || iValue2 == null ? 0 : iValue1.compareTo(iValue2);
            }
        });
        this.fireTableDataChanged();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.model.SSTaxCodeTableModel");
        sb.append("{iValues=").append(this.iValues);
        sb.append('}');
        return sb.toString();
    }

    private class ValueColumn
    extends SSTableColumn<SSTaxCode> {
        public ValueColumn() {
            super("");
        }

        @Override
        public Object getValue(SSTaxCode iTaxCode) {
            BigDecimal iValue = (BigDecimal)SSTaxCodeTableModel.this.iValues.get(iTaxCode);
            DecimalFormat iFormat = new DecimalFormat("0");
            return iFormat.format(iValue) + '%';
        }

        @Override
        public void setValue(SSTaxCode iInvoice, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 250;
        }
    }
}

