/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.table.editors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableCellEditor;

public class SSBigDecimalCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JFormattedTextField iTextField;

    public SSBigDecimalCellEditor(int maxFractionDigits) {
        NumberFormat iFormat = NumberFormat.getNumberInstance();
        iFormat.setMinimumFractionDigits(maxFractionDigits);
        iFormat.setMaximumFractionDigits(maxFractionDigits);
        this.iTextField = new JFormattedTextField(iFormat);
        this.iTextField.setHorizontalAlignment(11);
        this.iTextField.setFocusLostBehavior(3);
        this.iTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "commintchanges");
        this.iTextField.getActionMap().put("commintchanges", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSBigDecimalCellEditor.this.fireEditingStopped();
            }
        });
        this.iTextField.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SSBigDecimalCellEditor.this.iTextField.selectAll();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        try {
            this.iTextField.commitEdit();
        }
        catch (ParseException e1) {
            return null;
        }
        Object iValue = this.iTextField.getValue();
        if (iValue instanceof BigDecimal) {
            return iValue;
        }
        if (iValue instanceof Number) {
            Number iNumber = (Number)iValue;
            return new BigDecimal(iNumber.doubleValue());
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Number) {
            Number iValue = (Number)value;
            this.iTextField.setValue(iValue);
            this.iTextField.selectAll();
        } else {
            this.iTextField.setValue(null);
            this.iTextField.selectAll();
        }
        return this.iTextField;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            MouseEvent iMouseEvent = (MouseEvent)e;
            return iMouseEvent.getClickCount() >= 2;
        }
        return super.isCellEditable(e);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellEditor");
        sb.append("{iTextField=").append(this.iTextField);
        sb.append('}');
        return sb.toString();
    }
}

