/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.table.editors;

import java.text.NumberFormat;
import javax.swing.table.DefaultTableCellRenderer;

public class SSBigDecimalCellRenderer
extends DefaultTableCellRenderer {
    private int iFractionDigits;
    private boolean iShowNullValues;

    public SSBigDecimalCellRenderer(int pFractionDigits) {
        this(pFractionDigits, false);
    }

    public SSBigDecimalCellRenderer(int pFractionDigits, boolean pShowNullValues) {
        this.iFractionDigits = pFractionDigits;
        this.iShowNullValues = pShowNullValues;
        this.setHorizontalAlignment(4);
    }

    @Override
    protected void setValue(Object value) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumFractionDigits(this.iFractionDigits);
        format.setMaximumFractionDigits(this.iFractionDigits);
        format.setGroupingUsed(true);
        if (value != null) {
            this.setText(format.format(value));
        } else if (this.iShowNullValues) {
            this.setText(format.format(0.0));
        } else {
            this.setText("");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellRenderer");
        sb.append("{iFractionDigits=").append(this.iFractionDigits);
        sb.append(", iShowNullValues=").append(this.iShowNullValues);
        sb.append('}');
        return sb.toString();
    }
}

