/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.table.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;

public class SSDateCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JPanel iPanel;
    private JFormattedTextField iTextField;
    private JButton iButton;
    private SSDateChooser iDateChooser;
    private Date iDate;

    public SSDateCellEditor() {
        DateFormat iFormat = DateFormat.getDateInstance(3);
        this.iDateChooser = new SSDateChooser();
        this.iDateChooser.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSDateCellEditor.this.setDate(SSDateCellEditor.this.iDateChooser.getDate());
            }
        });
        this.iTextField = new JFormattedTextField(iFormat);
        this.iTextField.setHorizontalAlignment(11);
        this.iTextField.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSDateCellEditor.this.setDate((Date)SSDateCellEditor.this.iTextField.getValue());
            }
        });
        this.iButton = new SSButton("ICON_CALENDAR16");
        this.iButton.setToolTipText(SSBundle.getBundle().getString("date.tooltip"));
        this.iButton.setPreferredSize(new Dimension(20, 20));
        this.iButton.setMaximumSize(new Dimension(20, 20));
        this.iButton.setMinimumSize(new Dimension(20, 20));
        this.iButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSDateCellEditor.this.iDateChooser.setDate(SSDateCellEditor.this.iDate);
                SSDateCellEditor.this.iDateChooser.show(SSDateCellEditor.this.iButton, 0, SSDateCellEditor.this.iButton.getHeight());
            }
        });
        this.iPanel = new JPanel();
        this.iPanel.setLayout(new BorderLayout());
        this.iPanel.add((Component)this.iTextField, "Center");
        this.iPanel.add((Component)this.iButton, "East");
    }

    @Override
    public Object getCellEditorValue() {
        return this.iDate;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Date) {
            this.setDate((Date)value);
        } else {
            this.setDate(new Date());
        }
        return this.iPanel;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            MouseEvent iMouseEvent = (MouseEvent)e;
            return iMouseEvent.getClickCount() >= 2;
        }
        return super.isCellEditable(e);
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
        this.iTextField.setValue(iDate);
        this.iDateChooser.setDate(iDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.table.editors.SSDateCellEditor");
        sb.append("{iButton=").append(this.iButton);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iDateChooser=").append(this.iDateChooser);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iTextField=").append(this.iTextField);
        sb.append('}');
        return sb.toString();
    }
}

