/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.table.editors;

import java.text.NumberFormat;
import javax.swing.table.DefaultTableCellRenderer;

public class SSIntegerRenderer
extends DefaultTableCellRenderer {
    private boolean iShowNullValues;

    public SSIntegerRenderer() {
        this(false);
    }

    public SSIntegerRenderer(boolean pShowNullValues) {
        this.iShowNullValues = pShowNullValues;
        this.setHorizontalAlignment(4);
    }

    @Override
    protected void setValue(Object value) {
        NumberFormat iFormat = NumberFormat.getNumberInstance();
        iFormat.setMinimumFractionDigits(0);
        iFormat.setMaximumFractionDigits(0);
        iFormat.setGroupingUsed(false);
        if (value != null) {
            this.setText(iFormat.format(value));
        } else if (this.iShowNullValues) {
            this.setText(iFormat.format(0.0));
        } else {
            this.setText("");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.table.editors.SSIntegerRenderer");
        sb.append("{iShowNullValues=").append(this.iShowNullValues);
        sb.append('}');
        return sb.toString();
    }
}

