/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.table.editors;

import java.text.NumberFormat;
import javax.swing.table.DefaultTableCellRenderer;

public class SSPercentCellRenderer
extends DefaultTableCellRenderer {
    int iFractionDigits;
    boolean iShowNullValues;

    public SSPercentCellRenderer(int pFractionDigits) {
        this(pFractionDigits, false);
    }

    public SSPercentCellRenderer(int pFractionDigits, boolean pShowNullValues) {
        this.iFractionDigits = pFractionDigits;
        this.iShowNullValues = pShowNullValues;
        this.setHorizontalAlignment(4);
    }

    @Override
    protected void setValue(Object value) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumFractionDigits(this.iFractionDigits);
        format.setMaximumFractionDigits(this.iFractionDigits);
        format.setGroupingUsed(true);
        if (value != null) {
            this.setText(format.format(value) + '%');
        } else if (this.iShowNullValues) {
            this.setText(format.format(0L) + '%');
        } else {
            this.setText("");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.table.editors.SSPercentCellRenderer");
        sb.append("{iFractionDigits=").append(this.iFractionDigits);
        sb.append(", iShowNullValues=").append(this.iShowNullValues);
        sb.append('}');
        return sb.toString();
    }
}

