/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.table.model;

import java.util.List;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public abstract class SSEditableTableModel<T>
extends SSTableModel<T> {
    private T iEditing = this.newObject();
    private static final String EMPTY_STRING = "";

    public SSEditableTableModel() {
    }

    public SSEditableTableModel(List<T> pObjects) {
        super(pObjects);
    }

    public SSEditableTableModel(T ... pObjects) {
        super(pObjects);
    }

    @Override
    public int getRowCount() {
        return super.getRowCount() + 1;
    }

    @Override
    public T getObject(int row) {
        if (row == super.getRowCount()) {
            return this.iEditing;
        }
        return super.getObject(row);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex);
        if (rowIndex == super.getRowCount() && aValue != null && !EMPTY_STRING.equals(aValue)) {
            this.add(this.iEditing);
            this.iEditing = this.newObject();
        }
    }

    @Override
    public void setObjects(List<T> pObjects) {
        super.setObjects(pObjects);
        this.iEditing = this.newObject();
    }

    @Override
    public void setObjects(T ... pObjects) {
        super.setObjects(pObjects);
        this.iEditing = this.newObject();
    }

    public abstract T newObject();

    public T getEditObject() {
        return this.iEditing;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.table.model.SSEditableTableModel");
        sb.append("{EMPTY_STRING='").append(EMPTY_STRING).append('\'');
        sb.append(", iEditing=").append(this.iEditing);
        sb.append('}');
        return sb.toString();
    }
}

