/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.voucher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSProgressDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSExcelFileChooser;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSSIEFileChooser;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.voucher.SSVoucherDialog;
import se.swedsoft.bookkeeping.gui.voucher.util.SSVoucherTableModel;
import se.swedsoft.bookkeeping.importexport.excel.SSVoucherExporter;
import se.swedsoft.bookkeeping.importexport.excel.SSVoucherImporter;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEImporter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;
import se.swedsoft.bookkeeping.print.report.SSVoucherListPrinter;

public class SSVoucherFrame
extends SSDefaultTableFrame {
    private static SSVoucherFrame cInstance;
    private SSTable iTable;
    private SSVoucherTableModel iModel;

    public static SSVoucherFrame getInstance() {
        return cInstance;
    }

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSVoucherFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        cInstance.updateFrame();
    }

    public static void closeFrame() {
        if (cInstance != null) {
            cInstance.setVisible(false);
        }
    }

    private SSVoucherFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        super(pMainFrame, SSBundle.getBundle().getString("voucherframe.title"), pWidth, pHeight);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "voucherframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucherDialog.newDialog(SSVoucherFrame.this.getMainFrame(), SSVoucherFrame.this.iModel);
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "voucherframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucher iSelected = (SSVoucher)SSVoucherFrame.this.iModel.getSelectedRow(SSVoucherFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSVoucherFrame.this.getVoucher(iSelected);
                }
                if (iSelected != null) {
                    SSVoucherDialog.editDialog(SSVoucherFrame.this.getMainFrame(), iSelected, SSVoucherFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSVoucherFrame.this.getMainFrame(), "voucherframe.vouchergone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_CREATECHANGE", "voucherframe.createchangebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucher iSelected = (SSVoucher)SSVoucherFrame.this.iModel.getSelectedRow(SSVoucherFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSVoucherFrame.this.getVoucher(iSelected);
                }
                if (iSelected != null) {
                    SSVoucherDialog.copyDialog(SSVoucherFrame.this.getMainFrame(), iSelected, SSVoucherFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSVoucherFrame.this.getMainFrame(), "voucherframe.vouchergone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_IMPORT", "voucherframe.importbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
                if (!SSPostLock.applyLock(lockString)) {
                    new SSErrorDialog(SSVoucherFrame.this.getMainFrame(), "voucheriscreated");
                    return;
                }
                SSExcelFileChooser iFilechooser = SSExcelFileChooser.getInstance();
                int iResponce = iFilechooser.showOpenDialog(SSVoucherFrame.this.getMainFrame());
                if (iResponce == 0) {
                    SSVoucherImporter iImporter = new SSVoucherImporter(iFilechooser.getSelectedFile());
                    try {
                        iImporter.Import();
                    }
                    catch (IOException ex) {
                        SSPostLock.removeLock(lockString);
                        SSErrorDialog.showDialog(SSVoucherFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    catch (SSImportException ex) {
                        SSPostLock.removeLock(lockString);
                        SSErrorDialog.showDialog(SSVoucherFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    SSVoucherFrame.this.iModel.fireTableDataChanged();
                } else {
                    SSPostLock.removeLock(lockString);
                }
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EXPORT", "voucherframe.exportbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iItems;
                SSExcelFileChooser iFilechooser = SSExcelFileChooser.getInstance();
                List iSelected = SSVoucherFrame.this.iModel.getSelectedRows(SSVoucherFrame.this.iTable);
                if (iSelected != null) {
                    int select = SSQueryDialog.showDialog((JFrame)SSVoucherFrame.this.getMainFrame(), 1, SSVoucherFrame.this.getTitle(), SSBundle.getBundle().getString("voucherframe.import.allorselected"));
                    switch (select) {
                        case 0: {
                            iItems = SSVoucherFrame.this.getVouchers(iSelected);
                            break;
                        }
                        case 1: {
                            iItems = SSDB.getInstance().getVouchers();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    iItems = SSDB.getInstance().getVouchers();
                }
                iFilechooser.setSelectedFile(new File("Verifikationer.xls"));
                if (iFilechooser.showSaveDialog(SSVoucherFrame.this.getMainFrame()) == 0) {
                    SSVoucherExporter iExporter = new SSVoucherExporter(iFilechooser.getSelectedFile(), iItems);
                    try {
                        iExporter.export();
                    }
                    catch (IOException ex) {
                        SSErrorDialog.showDialog(SSVoucherFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    catch (SSExportException ex) {
                        SSErrorDialog.showDialog(SSVoucherFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                }
            }
        });
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_TASKLIST24", "voucherframe.importsiebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
                if (!SSPostLock.applyLock(lockString)) {
                    new SSErrorDialog(SSVoucherFrame.this.getMainFrame(), "voucheriscreated");
                    return;
                }
                SSSIEFileChooser iFileChooser = SSSIEFileChooser.getInstance();
                int iResponce = iFileChooser.showOpenDialog(SSVoucherFrame.this.getMainFrame());
                if (iResponce == 0) {
                    SSSIEImporter iImporter = new SSSIEImporter(iFileChooser.getSelectedFile());
                    try {
                        iImporter.doImportVouchers();
                        SSPostLock.removeLock(lockString);
                    }
                    catch (SSImportException ex) {
                        SSPostLock.removeLock(lockString);
                        SSErrorDialog.showDialog(SSVoucherFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    SSVoucherFrame.this.iModel.fireTableDataChanged();
                } else {
                    SSPostLock.removeLock(lockString);
                }
            }
        });
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_PRINT", "voucherframe.printbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucherFrame.this.printVouchers();
            }
        });
        iToolBar.add(iButton);
        return iToolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSVoucherTableModel();
        this.iModel.addColumn(SSVoucherTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSVoucherTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSVoucherTableModel.COLUMN_DESCRIPTION);
        this.iModel.addColumn(SSVoucherTableModel.COLUMN_SUM);
        this.iModel.addColumn(SSVoucherTableModel.COLUMN_CORRECTS);
        this.iModel.addColumn(SSVoucherTableModel.COLUMN_CORRECTEDBY);
        this.iModel.setupTable(this.iTable);
        this.iTable.setDefaultRenderer(SSVoucher.class, new SSVoucherCellRenderer());
        this.iTable.setDefaultEditor(SSVoucher.class, new SSVoucherCellEditor());
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucher iSelected = (SSVoucher)SSVoucherFrame.this.iModel.getSelectedRow(SSVoucherFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                Integer iNumber = iSelected.getNumber();
                iSelected = SSVoucherFrame.this.getVoucher(iSelected);
                if (iSelected != null) {
                    SSVoucherDialog.editDialog(SSVoucherFrame.this.getMainFrame(), iSelected, SSVoucherFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSVoucherFrame.this.getMainFrame(), "voucherframe.vouchergone", iNumber);
                }
            }
        });
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return iPanel;
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getVouchers());
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return true;
    }

    public SSVoucherTableModel getModel() {
        return this.iModel;
    }

    private void deleteSelectedVouchers(List<SSVoucher> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "voucherframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSVoucher iVoucher : delete) {
                if (SSPostLock.isLocked("voucher" + iVoucher.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "voucherframe.voucheropen", iVoucher.getNumber());
                    continue;
                }
                SSDB.getInstance().deleteVoucher(iVoucher);
            }
        }
    }

    private SSVoucher getVoucher(SSVoucher iVoucher) {
        return SSDB.getInstance().getVoucher(iVoucher);
    }

    private List<SSVoucher> getVouchers(List<SSVoucher> iVouchers) {
        return SSDB.getInstance().getVouchers(iVouchers);
    }

    private void printVouchers() {
        SSVoucherListPrinter iPrinter;
        if (this.iTable.getSelectedRowCount() > 0) {
            SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), 1, "voucherframe.print");
            switch (iDialog.getResponce()) {
                case 0: {
                    List<SSVoucher> iVouchers = this.getVouchers(this.iModel.getObjects(this.iTable.getSelectedRows()));
                    iPrinter = new SSVoucherListPrinter(iVouchers);
                    break;
                }
                case 1: {
                    iPrinter = new SSVoucherListPrinter(SSDB.getInstance().getVouchers());
                    break;
                }
                default: {
                    return;
                }
            }
        } else {
            iPrinter = new SSVoucherListPrinter(SSDB.getInstance().getVouchers());
        }
        SSProgressDialog.runProgress(this.getMainFrame(), new Runnable(){

            @Override
            public void run() {
                iPrinter.preview(SSVoucherFrame.this.getMainFrame());
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.voucher.SSVoucherFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }

    private static class SSVoucherCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        protected void setValue(Object value) {
            if (value != null) {
                SSVoucher iVoucher = (SSVoucher)value;
                this.setText(Integer.toString(iVoucher.getNumber()));
            } else {
                this.setText("");
            }
        }
    }

    private class SSVoucherCellEditor
    extends DefaultCellEditor {
        private SSVoucherCellRenderer iRenderer;

        public SSVoucherCellEditor() {
            super(new JTextField());
            this.iRenderer = new SSVoucherCellRenderer();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value != null) {
                final SSVoucher iVoucher = (SSVoucher)value;
                Component c = this.iRenderer.getTableCellRendererComponent(table, value, isSelected, true, row, column);
                JButton iButton = new JButton("...");
                iButton.setMaximumSize(new Dimension(18, 18));
                iButton.setPreferredSize(new Dimension(18, 18));
                iButton.setSize(new Dimension(18, 18));
                iButton.setToolTipText(SSBundle.getBundle().getString("voucherframe.gotovoucher.tooltip"));
                iButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int index = SSVoucherFrame.this.iModel.indexOf(iVoucher);
                        SSVoucherFrame.this.iTable.editCellAt(-1, -1);
                        if (index >= 0) {
                            SSVoucherFrame.this.iTable.setRowSelectionInterval(index, index);
                            SSVoucherFrame.this.iTable.scrollRectToVisible(SSVoucherFrame.this.iTable.getCellRect(index, 0, true));
                        }
                    }
                });
                JPanel iPanel = new JPanel();
                iPanel.setLayout(new BorderLayout());
                iPanel.add(c, "Center");
                iPanel.add((Component)iButton, "East");
                return iPanel;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.voucher.SSVoucherFrame.SSVoucherCellEditor");
            sb.append("{iRenderer=").append(this.iRenderer);
            sb.append('}');
            return sb.toString();
        }
    }
}

