/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.voucher.dialogs;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.common.SSVATCode;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.SSInputVerifier;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSConfirmDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSVATCodeTableModel;

public class SSAddAccountDialog
extends SSDialog {
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private JTextField iAccountNr;
    private JTextField iDescription;
    private JTextField iSruCode;
    private JTextField iReportCode;
    private JCheckBox iProjectRequired;
    private JCheckBox iResultUnitRequired;
    private SSTableComboBox<SSVATCode> iVatCode;
    private SSInputVerifier iInputVerifier;

    public SSAddAccountDialog(final SSMainFrame iDialog) {
        super(iDialog, "L\u00e4gg till konto");
        this.$$$setupUI$$$();
        SSVATCodeTableModel iModel = new SSVATCodeTableModel();
        iModel.addColumn(SSVATCodeTableModel.COLUMN_NAME);
        iModel.addColumn(SSVATCodeTableModel.COLUMN_DESCRIPTION);
        this.iVatCode.setModel(iModel);
        this.add((Component)this.iPanel, "Center");
        this.pack();
        this.iButtonPanel.addOkActionListener(new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccount iAccount = new SSAccount();
                try {
                    iAccount.setNumber(Integer.parseInt(SSAddAccountDialog.this.iAccountNr.getText()));
                }
                catch (NumberFormatException ex) {
                    SSErrorDialog.showDialog(iDialog, "Felaktigt kontonummer", "Kontonummret f\u00e5r bara inneh\u00e5lla siffror.");
                    return;
                }
                SSNewAccountingYear iCurrentYear = SSDB.getInstance().getCurrentYear();
                LinkedList<SSAccount> iExistingAccounts = new LinkedList<SSAccount>(iCurrentYear.getAccounts());
                if (iExistingAccounts.contains(iAccount)) {
                    if ((iAccount = (SSAccount)iExistingAccounts.get(iExistingAccounts.indexOf(iAccount))).isActive()) {
                        SSErrorDialog.showDialog(iDialog, "Dubblett", "Kontot " + iAccount.getNumber() + " existerar redan.");
                        return;
                    }
                    int result = SSConfirmDialog.showDialog(iDialog, "Kontot inaktivt", "Kontot " + iAccount.getNumber() + " \u00e4r inaktivt. Vill du aktivera det?");
                    if (result != 0) return;
                    iAccount.setActive(true);
                    SSDB.getInstance().updateAccountingYear(iCurrentYear);
                } else {
                    iAccount.setDescription(SSAddAccountDialog.this.iDescription.getText());
                    iAccount.setVATCode(SSAddAccountDialog.this.iVatCode.getSelected() == null ? null : ((SSVATCode)SSAddAccountDialog.this.iVatCode.getSelected()).getName());
                    iAccount.setSRUCode(SSAddAccountDialog.this.iSruCode.getText());
                    iAccount.setReportCode(SSAddAccountDialog.this.iReportCode.getText());
                    iAccount.setProjectRequired(SSAddAccountDialog.this.iProjectRequired.isSelected());
                    iAccount.setResultUnitRequired(SSAddAccountDialog.this.iResultUnitRequired.isSelected());
                    iCurrentYear.getAccountPlan().addAccount(iAccount);
                    iCurrentYear.getAccountPlan().setAccounts(iCurrentYear.getAccountPlan().getAccounts());
                    SSDB.getInstance().updateAccountingYear(iCurrentYear);
                }
                SSAddAccountDialog.this.closeDialog(0);
            }
        });
        this.iButtonPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAddAccountDialog.this.closeDialog(2);
            }
        });
        this.getRootPane().setDefaultButton(this.iButtonPanel.getOkButton());
        this.iInputVerifier = new SSInputVerifier();
        this.iInputVerifier.add(this.iAccountNr);
        this.iInputVerifier.add(this.iDescription);
        this.iInputVerifier.addListener(new SSInputVerifier.SSVerifierListener(){

            @Override
            public void updated(SSInputVerifier iVerifier, boolean iValid) {
                SSAddAccountDialog.this.iButtonPanel.getOkButton().setEnabled(iValid);
            }
        });
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public static void showDialog(SSMainFrame iMainFrame) {
        SSAddAccountDialog iDialog = new SSAddAccountDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.showDialog();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.voucher.dialogs.SSAddAccountDialog");
        sb.append("{iAccountNr=").append(this.iAccountNr);
        sb.append(", iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iDescription=").append(this.iDescription);
        sb.append(", iInputVerifier=").append(this.iInputVerifier);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iProjectRequired=").append(this.iProjectRequired);
        sb.append(", iReportCode=").append(this.iReportCode);
        sb.append(", iResultUnitRequired=").append(this.iResultUnitRequired);
        sb.append(", iSruCode=").append(this.iSruCode);
        sb.append(", iVatCode=").append(this.iVatCode);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField3;
        JTextField jTextField4;
        SSButtonPanel sSButtonPanel;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(7, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Kontonummer:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Beskrivning:");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Momskod:");
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("SRU-kod:");
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Rapportkod:");
        jPanel2.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Projekt kr\u00e4vs:");
        jPanel2.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Resultatenhet kr\u00e4vs:");
        jPanel2.add((Component)jLabel7, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDescription = jTextField4 = new JTextField();
        jPanel2.add((Component)jTextField4, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, new Dimension(200, -1), null, new Dimension(200, -1)));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iVatCode = sSTableComboBox;
        jPanel2.add(sSTableComboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, new Dimension(75, -1), null, null));
        this.iReportCode = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, new Dimension(50, -1), null, new Dimension(50, -1)));
        this.iProjectRequired = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iResultUnitRequired = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jPanel2.add((Component)jCheckBox, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iAccountNr = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, new Dimension(50, -1), null, new Dimension(50, -1)));
        this.iSruCode = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, new Dimension(50, -1), null, new Dimension(50, -1)));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }
}

