/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.voucher.util;

import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.model.SSEditableTableModel;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.voucher.panel.SSVoucherPanel;

public class SSVoucherRowTableModel
extends SSEditableTableModel<SSVoucherRow> {
    private int iReadOnlyCount;
    public static SSTableColumn<SSVoucherRow> COLUMN_ACCOUNT = new SSTableColumn<SSVoucherRow>(SSBundle.getBundle().getString("voucherrowtable.column.1")){

        @Override
        public Object getValue(SSVoucherRow iVoucherRow) {
            SSAccount iAccount = iVoucherRow.getAccount(SSDB.getInstance().getAccounts());
            return iAccount != null ? iAccount : iVoucherRow.getAccountNr();
        }

        @Override
        public void setValue(SSVoucherRow iVoucherRow, Object iValue) {
            if (iValue instanceof SSAccount) {
                SSVoucherPanel.iAccountChanged = true;
                iVoucherRow.setAccount((SSAccount)iValue);
            }
        }

        @Override
        public Class getColumnClass() {
            return SSAccount.class;
        }

        @Override
        public int getDefaultWidth() {
            return 60;
        }

        @Override
        public boolean isEditable(int iRow) {
            return iRow >= ((SSVoucherRowTableModel)this.getModel()).iReadOnlyCount;
        }
    };
    public static SSTableColumn<SSVoucherRow> COLUMN_DESCRIPTION = new SSTableColumn<SSVoucherRow>(SSBundle.getBundle().getString("voucherrowtable.column.2")){

        @Override
        public Object getValue(SSVoucherRow iVoucherRow) {
            SSAccount iAccount = iVoucherRow.getAccount(SSDB.getInstance().getAccounts());
            return iAccount != null ? iAccount.getDescription() : null;
        }

        @Override
        public void setValue(SSVoucherRow iVoucherRow, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 260;
        }

        @Override
        public boolean isEditable(int iRow) {
            return false;
        }
    };
    public static SSTableColumn<SSVoucherRow> COLUMN_DEBET = new SSTableColumn<SSVoucherRow>(SSBundle.getBundle().getString("voucherrowtable.column.3")){

        @Override
        public Object getValue(SSVoucherRow iVoucherRow) {
            return iVoucherRow.getDebet();
        }

        @Override
        public void setValue(SSVoucherRow iVoucherRow, Object iValue) {
            SSVoucherPanel.iDebetChanged = true;
            iVoucherRow.setDebet((BigDecimal)iValue);
            iVoucherRow.setCredit(null);
        }

        @Override
        public Class getColumnClass() {
            return BigDecimal.class;
        }

        @Override
        public int getDefaultWidth() {
            return 85;
        }

        @Override
        public boolean isEditable(int iRow) {
            return iRow >= ((SSVoucherRowTableModel)this.getModel()).iReadOnlyCount;
        }
    };
    public static SSTableColumn<SSVoucherRow> COLUMN_CREDIT = new SSTableColumn<SSVoucherRow>(SSBundle.getBundle().getString("voucherrowtable.column.4")){

        @Override
        public Object getValue(SSVoucherRow iVoucherRow) {
            return iVoucherRow.getCredit();
        }

        @Override
        public void setValue(SSVoucherRow iVoucherRow, Object iValue) {
            SSVoucherPanel.iCreditChanged = true;
            iVoucherRow.setDebet(null);
            iVoucherRow.setCredit((BigDecimal)iValue);
        }

        @Override
        public Class getColumnClass() {
            return BigDecimal.class;
        }

        @Override
        public int getDefaultWidth() {
            return 85;
        }

        @Override
        public boolean isEditable(int iRow) {
            return iRow >= ((SSVoucherRowTableModel)this.getModel()).iReadOnlyCount;
        }
    };
    public static SSTableColumn<SSVoucherRow> COLUMN_PROJECT = new SSTableColumn<SSVoucherRow>(SSBundle.getBundle().getString("voucherrowtable.column.5")){

        @Override
        public Object getValue(SSVoucherRow iVoucherRow) {
            return iVoucherRow.getProject();
        }

        @Override
        public void setValue(SSVoucherRow iVoucherRow, Object iValue) {
            iVoucherRow.setProject((SSNewProject)iValue);
        }

        @Override
        public Class getColumnClass() {
            return SSNewProject.class;
        }

        @Override
        public int getDefaultWidth() {
            return 80;
        }

        @Override
        public boolean isEditable(int iRow) {
            return iRow >= ((SSVoucherRowTableModel)this.getModel()).iReadOnlyCount;
        }
    };
    public static SSTableColumn<SSVoucherRow> COLUMN_RESULTUNIT = new SSTableColumn<SSVoucherRow>(SSBundle.getBundle().getString("voucherrowtable.column.6")){

        @Override
        public Object getValue(SSVoucherRow iVoucherRow) {
            return iVoucherRow.getResultUnit();
        }

        @Override
        public void setValue(SSVoucherRow iVoucherRow, Object iValue) {
            iVoucherRow.setResultUnit((SSNewResultUnit)iValue);
        }

        @Override
        public Class getColumnClass() {
            return SSNewResultUnit.class;
        }

        @Override
        public int getDefaultWidth() {
            return 80;
        }

        @Override
        public boolean isEditable(int iRow) {
            return iRow >= ((SSVoucherRowTableModel)this.getModel()).iReadOnlyCount;
        }
    };
    public static SSTableColumn<SSVoucherRow> COLUMN_EDITED_DATE = new SSTableColumn<SSVoucherRow>(SSBundle.getBundle().getString("voucherrowtable.column.7")){

        @Override
        public Object getValue(SSVoucherRow iVoucherRow) {
            return iVoucherRow.getEditedDate();
        }

        @Override
        public void setValue(SSVoucherRow iVoucherRow, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return Date.class;
        }

        @Override
        public int getDefaultWidth() {
            return 75;
        }

        @Override
        public boolean isEditable(int iRow) {
            return false;
        }
    };
    public static SSTableColumn<SSVoucherRow> COLUMN_EDITED_SIGNATURE = new SSTableColumn<SSVoucherRow>(SSBundle.getBundle().getString("voucherrowtable.column.8")){

        @Override
        public Object getValue(SSVoucherRow iVoucherRow) {
            return iVoucherRow.getEditedSignature();
        }

        @Override
        public void setValue(SSVoucherRow iVoucherRow, Object iValue) {
            iVoucherRow.setEditedSignature((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 75;
        }

        @Override
        public boolean isEditable(int iRow) {
            return true;
        }
    };
    public static Color COLOR_CROSSED = new Color(255, 211, 211);
    public static Color COLOR_CROSSED_SELECTED = new Color(255, 192, 192);
    public static Color COLOR_ADDED = new Color(211, 211, 255);
    public static Color COLOR_ADDED_SELECTED = new Color(192, 192, 255);

    @Override
    public SSVoucherRow newObject() {
        if (this.iReadOnlyCount > 0 && this.getEditObject() != null) {
            ((SSVoucherRow)this.getEditObject()).setAdded(null);
            ((SSVoucherRow)this.getEditObject()).setEditedDate(new Date());
        }
        return new SSVoucherRow();
    }

    @Override
    public Class getType() {
        return SSVoucherRow.class;
    }

    public void setObjects(List<SSVoucherRow> iObjects, boolean iEditing) {
        this.iReadOnlyCount = iEditing ? iObjects.size() : 0;
        super.setObjects(iObjects);
    }

    public boolean allowDeletion(SSVoucherRow iSelected) {
        return this.indexOf(iSelected) >= this.iReadOnlyCount;
    }

    public boolean allowMarking(SSVoucherRow iSelected) {
        int index = this.indexOf(iSelected);
        return index >= 0 && index < this.iReadOnlyCount;
    }

    public void setupTable(SSTable iTable, boolean iUsePainter) {
        super.setupTable(iTable);
        if (iUsePainter) {
            iTable.setCustomPainter(new SSVoucherRowPainter());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.voucher.util.SSVoucherRowTableModel");
        sb.append("{iReadOnlyCount=").append(this.iReadOnlyCount);
        sb.append('}');
        return sb.toString();
    }

    private class SSVoucherRowPainter
    implements SSTable.SSCustomPainter {
        private SSVoucherRowPainter() {
        }

        @Override
        public void update(JTable iTable, Component c, int row, int col, boolean selected, boolean editable) {
            SSVoucherRow iRow = (SSVoucherRow)SSVoucherRowTableModel.this.getObject(row);
            if (iRow.isCrossed()) {
                if (selected) {
                    c.setBackground(COLOR_CROSSED_SELECTED);
                } else {
                    c.setBackground(COLOR_CROSSED);
                }
            } else if (iRow.isAdded()) {
                if (selected) {
                    c.setBackground(COLOR_ADDED_SELECTED);
                } else {
                    c.setBackground(COLOR_ADDED);
                }
            }
        }
    }
}

