/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.voucher.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.gui.util.SSBundle;

public class SSVoucherVerifier
implements PropertyChangeListener,
TableModelListener,
ActionListener {
    private static ResourceBundle bundle = SSBundle.getBundle();
    private SSVoucher iVoucher;
    private List<JComponent> iComponents;
    private boolean iValid;
    private String iError;
    private OnUpdate iOnUpdate;

    public SSVoucherVerifier(JComponent ... pComponents) {
        this.iVoucher = null;
        this.iComponents = new LinkedList<JComponent>();
        this.iError = null;
        this.iOnUpdate = null;
        this.iValid = false;
        this.iComponents.addAll(Arrays.asList(pComponents));
    }

    public SSVoucherVerifier(SSVoucher pVoucher, JComponent ... pComponents) {
        this.iVoucher = pVoucher;
        this.iComponents = new LinkedList<JComponent>();
        this.iError = null;
        this.iOnUpdate = null;
        this.iComponents.addAll(Arrays.asList(pComponents));
    }

    public void setVoucher(SSVoucher pVoucher) {
        this.iVoucher = pVoucher;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.update();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.update();
    }

    private boolean validate() {
        BigDecimal iCreditSum;
        this.iError = null;
        String description = this.iVoucher.getDescription();
        if (description == null || description.length() == 0) {
            this.iError = bundle.getString("voucherframe.error.1");
            return false;
        }
        if (this.iVoucher.getRows().isEmpty()) {
            this.iError = bundle.getString("voucherframe.error.2");
            return false;
        }
        for (SSVoucherRow iRow : this.iVoucher.getRows()) {
            if (iRow.isCrossed()) {
                if (iRow.getEditedSignature() != null) continue;
                this.iError = bundle.getString("voucherframe.error.7");
                return false;
            }
            if (iRow.getAccount() == null) {
                this.iError = bundle.getString("voucherframe.error.3");
                return false;
            }
            if (iRow.getDebet() == null && iRow.getCredit() == null) {
                this.iError = bundle.getString("voucherframe.error.4");
                return false;
            }
            if (iRow.getAccount().isProjectRequired() && iRow.getProject() == null) {
                this.iError = bundle.getString("voucherframe.error.9");
                return false;
            }
            if (iRow.getAccount().isResultUnitRequired() && iRow.getResultUnit() == null) {
                this.iError = bundle.getString("voucherframe.error.10");
                return false;
            }
            if (!iRow.isAdded() || iRow.getEditedSignature() != null) continue;
            this.iError = bundle.getString("voucherframe.error.5");
            return false;
        }
        BigDecimal iDebetSum = SSVoucherMath.getDebetSum(this.iVoucher);
        if (iDebetSum.subtract(iCreditSum = SSVoucherMath.getCreditSum(this.iVoucher)).setScale(2, RoundingMode.HALF_UP).signum() != 0) {
            this.iError = bundle.getString("voucherframe.error.6");
            return false;
        }
        if (iDebetSum.setScale(2, RoundingMode.HALF_UP).signum() == 0) {
            for (SSVoucherRow iRow : this.iVoucher.getRows()) {
                if (iRow.isCrossed()) continue;
                this.iError = bundle.getString("voucherframe.error.8");
                return false;
            }
        }
        return true;
    }

    public void update() {
        if (this.iVoucher == null) {
            return;
        }
        this.iValid = this.validate();
        if (this.iOnUpdate != null) {
            this.iOnUpdate.update(this.iValid, this.iError);
        }
        this.setComponentsEnabled(this.iValid);
    }

    private void setComponentsEnabled(boolean enabled) {
        for (JComponent iComponent : this.iComponents) {
            iComponent.setEnabled(enabled);
        }
    }

    public boolean isValid() {
        return this.iValid;
    }

    public String getError() {
        return this.iError;
    }

    public void setOnUpdate(OnUpdate pOnUpdate) {
        this.iOnUpdate = pOnUpdate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.voucher.util.SSVoucherVerifier");
        sb.append("{iComponents=").append(this.iComponents);
        sb.append(", iError='").append(this.iError).append('\'');
        sb.append(", iOnUpdate=").append(this.iOnUpdate);
        sb.append(", iValid=").append(this.iValid);
        sb.append(", iVoucher=").append(this.iVoucher);
        sb.append('}');
        return sb.toString();
    }

    public static interface OnUpdate {
        public void update(boolean var1, String var2);
    }
}

