/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.vouchertemplate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.SSVoucherTemplate;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSExcelFileChooser;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.vouchertemplate.util.SSVoucherTemplateTableModel;
import se.swedsoft.bookkeeping.importexport.excel.SSVoucherTemplateExporter;
import se.swedsoft.bookkeeping.importexport.excel.SSVoucherTemplateImporter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SSVoucherTemplateFrame
extends SSDefaultTableFrame {
    private SSTable iTable;
    private SSVoucherTemplateTableModel iModel;
    private static SSVoucherTemplateFrame cInstance;

    public static void showFrame(SSMainFrame iMainFrame) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSVoucherTemplateFrame(iMainFrame, 400, 300);
        }
        cInstance.setInCenter(iMainFrame);
        cInstance.setVisible(true);
    }

    public static SSVoucherTemplateFrame getInstance() {
        return cInstance;
    }

    public SSVoucherTemplateFrame(SSMainFrame frame, int width, int height) {
        super(frame, SSBundle.getBundle().getString("vouchertemplateframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_IMPORT", "vouchertemplateframe.importbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSExcelFileChooser iFilechooser = SSExcelFileChooser.getInstance();
                if (iFilechooser.showOpenDialog(SSVoucherTemplateFrame.this.getMainFrame()) == 0) {
                    SSVoucherTemplateImporter iImporter = new SSVoucherTemplateImporter(iFilechooser.getSelectedFile());
                    try {
                        iImporter.Import();
                    }
                    catch (IOException ex) {
                        SSErrorDialog.showDialog(SSVoucherTemplateFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    catch (SSImportException ex) {
                        SSErrorDialog.showDialog(SSVoucherTemplateFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    SSVoucherTemplateFrame.this.iModel.fireTableDataChanged();
                }
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EXPORT", "vouchertemplateframe.exportbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iItems;
                SSExcelFileChooser iFilechooser = SSExcelFileChooser.getInstance();
                List iSelected = SSVoucherTemplateFrame.this.iModel.getSelectedRows(SSVoucherTemplateFrame.this.iTable);
                if (iSelected != null) {
                    int select = SSQueryDialog.showDialog((JFrame)SSVoucherTemplateFrame.this.getMainFrame(), 1, SSVoucherTemplateFrame.this.getTitle(), SSBundle.getBundle().getString("vouchertemplateframe.import.allorselected"));
                    switch (select) {
                        case 0: {
                            iItems = SSVoucherTemplateFrame.this.getVoucherTemplates(iSelected);
                            break;
                        }
                        case 1: {
                            iItems = SSDB.getInstance().getVoucherTemplates();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    iItems = SSDB.getInstance().getVoucherTemplates();
                }
                iFilechooser.setSelectedFile(new File("Konteringsmallar.xls"));
                if (iFilechooser.showSaveDialog(SSVoucherTemplateFrame.this.getMainFrame()) == 0) {
                    SSVoucherTemplateExporter iExporter = new SSVoucherTemplateExporter(iFilechooser.getSelectedFile(), iItems);
                    try {
                        iExporter.export();
                    }
                    catch (IOException ex) {
                        SSErrorDialog.showDialog(SSVoucherTemplateFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    catch (SSExportException ex) {
                        SSErrorDialog.showDialog(SSVoucherTemplateFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                }
            }
        });
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "vouchertemplateframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSVoucherTemplateFrame.this.iTable.getSelectedRows();
                List toDelete = SSVoucherTemplateFrame.this.iModel.getObjects(selected);
                SSVoucherTemplateFrame.this.deleteSelectedTemplates(toDelete);
            }
        });
        iToolBar.add(iButton);
        this.iTable.addSelectionDependentComponent(iButton);
        return iToolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSVoucherTemplateTableModel();
        this.iModel.addColumn(SSVoucherTemplateTableModel.COLUMN_DESCRIPTION);
        this.iModel.addColumn(SSVoucherTemplateTableModel.COLUMN_DATE);
        this.iModel.setupTable(this.iTable);
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return iPanel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return true;
    }

    private SSVoucherTemplate getSelected() {
        int selected = this.iTable.getSelectedRow();
        if (selected >= 0) {
            return (SSVoucherTemplate)this.iModel.getObject(selected);
        }
        return null;
    }

    private void deleteSelectedTemplates(List<SSVoucherTemplate> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "vouchertemplateframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSVoucherTemplate iVoucherTemplate : delete) {
                SSDB.getInstance().deleteVoucherTemplate(iVoucherTemplate);
            }
        }
    }

    private List<SSVoucherTemplate> getVoucherTemplates(List<SSVoucherTemplate> iVoucherTemplates) {
        return SSDB.getInstance().getVoucherTemplates(iVoucherTemplates);
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getVoucherTemplates());
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.vouchertemplate.SSVoucherTemplateFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

