/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelCell;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelRow;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelSheet;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SSAccountPlanImporter {
    private static final ResourceBundle cBundle = SSBundle.getBundle();
    private static String cName = cBundle.getString("importaccountplan.field_name");
    private static String cType = cBundle.getString("importaccountplan.field_type");
    private static String cYear = cBundle.getString("importaccountplan.field_year");
    private static String cStart = cBundle.getString("importaccountplan.field_start");
    private File iFile;

    public SSAccountPlanImporter(File iFile) {
        this.iFile = iFile;
    }

    public void doImport() throws IOException, SSImportException {
        SSAccountPlanImporter.doImport(this.iFile);
    }

    public static void doImport(File iFile) throws IOException {
        SSAccountPlanImporter.doImport(new FileInputStream(iFile));
    }

    public static void doImport(InputStream iInputStream) throws IOException {
        WorkbookSettings iSettings = new WorkbookSettings();
        iSettings.setLocale(new Locale("sv", "SE"));
        iSettings.setEncoding("windows-1252");
        iSettings.setExcelDisplayLanguage("SE");
        iSettings.setExcelRegionalSettings("SE");
        SSAccountPlan iAccountPlan = new SSAccountPlan();
        try {
            Workbook iWorkbook = Workbook.getWorkbook(iInputStream, iSettings);
            if (iWorkbook.getNumberOfSheets() == 0) {
                throw new SSImportException(cBundle, "importaccountplan.nosheets");
            }
            Sheet iSheet = iWorkbook.getSheet(0);
            SSAccountPlanImporter.readAccountPlan(new SSExcelSheet(iSheet), iAccountPlan);
            iWorkbook.close();
        }
        catch (BiffException e) {
            throw new SSImportException(e.getLocalizedMessage());
        }
        for (SSAccountPlan pAccountPlan : SSDB.getInstance().getAccountPlans()) {
            if (!iAccountPlan.getName().equals(pAccountPlan.getName())) continue;
            new SSErrorDialog(SSMainFrame.getInstance(), "accountplanframe.duplicate", iAccountPlan.getName());
            return;
        }
        SSDB.getInstance().addAccountPlan(iAccountPlan);
    }

    private static void readAccountPlan(SSExcelSheet pSheet, SSAccountPlan pAccountPlan) {
        int iRowStart = Integer.MAX_VALUE;
        for (SSExcelRow iRow : pSheet.getRows()) {
            if (iRow.empty()) continue;
            String c = iRow.getString(0);
            if (c.startsWith(cName)) {
                pAccountPlan.setName(iRow.getString(1));
                continue;
            }
            if (c.startsWith(cType)) {
                pAccountPlan.setType(iRow.getString(1));
                continue;
            }
            if (c.startsWith(cYear)) {
                pAccountPlan.setAssessementYear(iRow.getString(1));
                continue;
            }
            if (c.startsWith(cStart)) {
                iRowStart = iRow.getInteger(1);
                continue;
            }
            if (iRow.getRow() < iRowStart - 1) continue;
            SSAccount iAccount = new SSAccount();
            for (SSExcelCell iCell : iRow.getCells()) {
                switch (iCell.getColumn()) {
                    case 0: {
                        iAccount.setNumber(iCell.getInteger());
                        break;
                    }
                    case 1: {
                        iAccount.setDescription(iCell.getString());
                        break;
                    }
                    case 2: {
                        iAccount.setVATCode(iCell.getString());
                        break;
                    }
                    case 3: {
                        iAccount.setSRUCode(iCell.getString());
                        break;
                    }
                    case 4: {
                        iAccount.setReportCode(iCell.getString());
                    }
                }
            }
            pAccountPlan.addAccount(iAccount);
        }
        if (pAccountPlan.getAccounts().isEmpty()) {
            throw new SSImportException(cBundle, "importaccountplan.fileempty");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.excel.SSAccountPlanImporter");
        sb.append("{iFile=").append(this.iFile);
        sb.append('}');
        return sb.toString();
    }
}

