/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.excel;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import se.swedsoft.bookkeeping.app.Path;
import se.swedsoft.bookkeeping.data.SSAddress;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInformationDialog;
import se.swedsoft.bookkeeping.importexport.dialog.SSImportReportDialog;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelCell;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelRow;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelSheet;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SSCustomerImporter {
    private File iFile;
    private Map<String, Integer> iColumns;

    public SSCustomerImporter(File iFile) {
        this.iFile = iFile;
        this.iColumns = new HashMap<String, Integer>();
    }

    public void Import() throws SSImportException {
        WorkbookSettings iSettings = new WorkbookSettings();
        iSettings.setLocale(new Locale("sv", "SE"));
        iSettings.setEncoding("windows-1252");
        iSettings.setExcelDisplayLanguage("SE");
        iSettings.setExcelRegionalSettings("SE");
        List<SSCustomer> iCustomers = null;
        try {
            Workbook iWorkbook = Workbook.getWorkbook(this.iFile, iSettings);
            if (iWorkbook.getNumberOfSheets() == 0) {
                throw new SSImportException(SSBundle.getBundle(), "customerframe.import.nosheets");
            }
            Sheet iSheet = iWorkbook.getSheet(0);
            iCustomers = this.importCustomers(new SSExcelSheet(iSheet));
            iWorkbook.close();
        }
        catch (BiffException e) {
            throw new SSImportException(e.getLocalizedMessage());
        }
        catch (IOException e1) {
            throw new SSImportException(e1.getLocalizedMessage());
        }
        boolean iResult = this.showImportReport(iCustomers);
        if (iCustomers != null && iResult) {
            for (SSCustomer iCustomer : iCustomers) {
                if (SSDB.getInstance().getCustomers().contains(iCustomer)) continue;
                SSDB.getInstance().addCustomer(iCustomer);
            }
        }
    }

    private void getColumnIndexes(SSExcelRow iColumns) {
        this.iColumns.clear();
        int iIndex = 0;
        for (SSExcelCell iColumn : iColumns.getCells()) {
            String iName = iColumn.getString();
            if (iName != null && iName.length() > 0) {
                if (iName.equalsIgnoreCase("Kund-id")) {
                    this.iColumns.put("Kund-id", iIndex);
                } else if (iName.equalsIgnoreCase("Namn")) {
                    this.iColumns.put("Namn", iIndex);
                } else if (iName.equalsIgnoreCase("Telefon1")) {
                    this.iColumns.put("Telefon1", iIndex);
                } else if (iName.equalsIgnoreCase("Telefon2")) {
                    this.iColumns.put("Telefon2", iIndex);
                } else if (iName.equalsIgnoreCase("Fax")) {
                    this.iColumns.put("Fax", iIndex);
                } else if (iName.equalsIgnoreCase("Epost")) {
                    this.iColumns.put("Epost", iIndex);
                } else if (iName.equalsIgnoreCase("Kontaktperson")) {
                    this.iColumns.put("Kontaktperson", iIndex);
                } else if (iName.equalsIgnoreCase("Organisationsnummer")) {
                    this.iColumns.put("Organisationsnummer", iIndex);
                } else if (iName.equalsIgnoreCase("Bankgiro")) {
                    this.iColumns.put("Bankgiro", iIndex);
                } else if (iName.equalsIgnoreCase("Plusgiro")) {
                    this.iColumns.put("Plusgiro", iIndex);
                } else if (iName.equalsIgnoreCase("Fakturaadress.Namn")) {
                    this.iColumns.put("Fakturaadress.Namn", iIndex);
                } else if (iName.equalsIgnoreCase("Fakturaadress.Adress1")) {
                    this.iColumns.put("Fakturaadress.Adress1", iIndex);
                } else if (iName.equalsIgnoreCase("Fakturaadress.Adress2")) {
                    this.iColumns.put("Fakturaadress.Adress2", iIndex);
                } else if (iName.equalsIgnoreCase("Fakturaadress.Postnummer")) {
                    this.iColumns.put("Fakturaadress.Postnummer", iIndex);
                } else if (iName.equalsIgnoreCase("Fakturaadress.Postort")) {
                    this.iColumns.put("Fakturaadress.Postort", iIndex);
                } else if (iName.equalsIgnoreCase("Fakturaadress.Land")) {
                    this.iColumns.put("Fakturaadress.Land", iIndex);
                } else if (iName.equalsIgnoreCase("Leveransadress.Namn")) {
                    this.iColumns.put("Leveransadress.Namn", iIndex);
                } else if (iName.equalsIgnoreCase("Leveransadress.Adress1")) {
                    this.iColumns.put("Leveransadress.Adress1", iIndex);
                } else if (iName.equalsIgnoreCase("Leveransadress.Adress2")) {
                    this.iColumns.put("Leveransadress.Adress2", iIndex);
                } else if (iName.equalsIgnoreCase("Leveransadress.Postnummer")) {
                    this.iColumns.put("Leveransadress.Postnummer", iIndex);
                } else if (iName.equalsIgnoreCase("Leveransadress.Postort")) {
                    this.iColumns.put("Leveransadress.Postort", iIndex);
                } else if (iName.equalsIgnoreCase("Leveransadress.Land")) {
                    this.iColumns.put("Leveransadress.Land", iIndex);
                } else {
                    throw new SSImportException("Ogiltigt kolumnnamn i importfilen: %s", iName);
                }
            }
            ++iIndex;
        }
    }

    private List<SSCustomer> importCustomers(SSExcelSheet pSheet) {
        List<SSExcelRow> iRows = pSheet.getRows();
        if (iRows.size() < 2) {
            throw new SSImportException(SSBundle.getBundle(), "customerframe.import.norows");
        }
        this.getColumnIndexes(iRows.get(0));
        LinkedList<SSCustomer> iCustomers = new LinkedList<SSCustomer>();
        for (int row = 1; row < iRows.size(); ++row) {
            SSExcelRow iRow = iRows.get(row);
            if (iRow.empty()) continue;
            List<SSExcelCell> iCells = iRow.getCells();
            SSCustomer iCustomer = new SSCustomer();
            for (int col = 0; col < iCells.size(); ++col) {
                SSExcelCell iCell = iCells.get(col);
                String iValue = iCell.getString();
                if (this.iColumns.containsKey("Kund-id") && this.iColumns.get("Kund-id") == col) {
                    iCustomer.setNumber(iValue);
                }
                if (this.iColumns.containsKey("Namn") && this.iColumns.get("Namn") == col) {
                    iCustomer.setName(iValue);
                }
                if (this.iColumns.containsKey("Telefon1") && this.iColumns.get("Telefon1") == col) {
                    iCustomer.setPhone1(iValue);
                }
                if (this.iColumns.containsKey("Telefon2") && this.iColumns.get("Telefon2") == col) {
                    iCustomer.setPhone2(iValue);
                }
                if (this.iColumns.containsKey("Fax") && this.iColumns.get("Fax") == col) {
                    iCustomer.setTelefax(iValue);
                }
                if (this.iColumns.containsKey("Epost") && this.iColumns.get("Epost") == col) {
                    iCustomer.setEMail(iValue);
                }
                if (this.iColumns.containsKey("Kontaktperson") && this.iColumns.get("Kontaktperson") == col) {
                    iCustomer.setYourContactPerson(iValue);
                }
                if (this.iColumns.containsKey("Organisationsnummer") && this.iColumns.get("Organisationsnummer") == col) {
                    iCustomer.setRegistrationNumber(iValue);
                }
                if (this.iColumns.containsKey("Bankgiro") && this.iColumns.get("Bankgiro") == col) {
                    iCustomer.setBankgiro(iValue);
                }
                if (this.iColumns.containsKey("Plusgiro") && this.iColumns.get("Plusgiro") == col) {
                    iCustomer.setPlusgiro(iValue);
                }
                if (this.iColumns.containsKey("Fakturaadress.Namn") && this.iColumns.get("Fakturaadress.Namn") == col) {
                    iCustomer.getInvoiceAddress().setName(iValue);
                }
                if (this.iColumns.containsKey("Fakturaadress.Adress1") && this.iColumns.get("Fakturaadress.Adress1") == col) {
                    iCustomer.getInvoiceAddress().setAddress1(iValue);
                }
                if (this.iColumns.containsKey("Fakturaadress.Adress2") && this.iColumns.get("Fakturaadress.Adress2") == col) {
                    iCustomer.getInvoiceAddress().setAddress2(iValue);
                }
                if (this.iColumns.containsKey("Fakturaadress.Postnummer") && this.iColumns.get("Fakturaadress.Postnummer") == col) {
                    iCustomer.getInvoiceAddress().setZipCode(iValue);
                }
                if (this.iColumns.containsKey("Fakturaadress.Postort") && this.iColumns.get("Fakturaadress.Postort") == col) {
                    iCustomer.getInvoiceAddress().setCity(iValue);
                }
                if (this.iColumns.containsKey("Fakturaadress.Land") && this.iColumns.get("Fakturaadress.Land") == col) {
                    iCustomer.getInvoiceAddress().setCountry(iValue);
                }
                if (this.iColumns.containsKey("Leveransadress.Namn") && this.iColumns.get("Leveransadress.Namn") == col) {
                    iCustomer.getDeliveryAddress().setName(iValue);
                }
                if (this.iColumns.containsKey("Leveransadress.Adress1") && this.iColumns.get("Leveransadress.Adress1") == col) {
                    iCustomer.getDeliveryAddress().setAddress1(iValue);
                }
                if (this.iColumns.containsKey("Leveransadress.Adress2") && this.iColumns.get("Leveransadress.Adress2") == col) {
                    iCustomer.getDeliveryAddress().setAddress2(iValue);
                }
                if (this.iColumns.containsKey("Leveransadress.Postnummer") && this.iColumns.get("Leveransadress.Postnummer") == col) {
                    iCustomer.getDeliveryAddress().setZipCode(iValue);
                }
                if (this.iColumns.containsKey("Leveransadress.Postort") && this.iColumns.get("Leveransadress.Postort") == col) {
                    iCustomer.getDeliveryAddress().setCity(iValue);
                }
                if (!this.iColumns.containsKey("Leveransadress.Land") || this.iColumns.get("Leveransadress.Land") != col) continue;
                iCustomer.getDeliveryAddress().setCountry(iValue);
            }
            if (iCustomer.getNumber() == null || iCustomer.getNumber().length() <= 0) continue;
            iCustomers.add(iCustomer);
        }
        return iCustomers;
    }

    private boolean showImportReport(List<SSCustomer> iCustomers) {
        SSImportReportDialog iDialog = new SSImportReportDialog(SSMainFrame.getInstance(), SSBundle.getBundle().getString("customerframe.import.report"));
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("F\u00f6ljande kolumner har importerats fr\u00e5n kundfilen:<br>");
        sb.append("<ul>");
        if (this.iColumns.containsKey("Kund-id")) {
            sb.append("<li>").append("Kund-id").append("</li>");
        }
        if (this.iColumns.containsKey("Namn")) {
            sb.append("<li>").append("Namn").append("</li>");
        }
        if (this.iColumns.containsKey("Telefon1")) {
            sb.append("<li>").append("Telefon1").append("</li>");
        }
        if (this.iColumns.containsKey("Telefon2")) {
            sb.append("<li>").append("Telefon2").append("</li>");
        }
        if (this.iColumns.containsKey("Fax")) {
            sb.append("<li>").append("Fax").append("</li>");
        }
        if (this.iColumns.containsKey("Epost")) {
            sb.append("<li>").append("Epost").append("</li>");
        }
        if (this.iColumns.containsKey("Kontaktperson")) {
            sb.append("<li>").append("Kontaktperson").append("</li>");
        }
        if (this.iColumns.containsKey("Organisationsnummer")) {
            sb.append("<li>").append("Organisationsnummer").append("</li>");
        }
        if (this.iColumns.containsKey("Bankgiro")) {
            sb.append("<li>").append("Bankgiro").append("</li>");
        }
        if (this.iColumns.containsKey("Plusgiro")) {
            sb.append("<li>").append("Plusgiro").append("</li>");
        }
        if (this.iColumns.containsKey("Fakturaadress.Namn")) {
            sb.append("<li>").append("Fakturaadress.Namn").append("</li>");
        }
        if (this.iColumns.containsKey("Fakturaadress.Adress1")) {
            sb.append("<li>").append("Fakturaadress.Adress1").append("</li>");
        }
        if (this.iColumns.containsKey("Fakturaadress.Adress2")) {
            sb.append("<li>").append("Fakturaadress.Adress2").append("</li>");
        }
        if (this.iColumns.containsKey("Fakturaadress.Postnummer")) {
            sb.append("<li>").append("Fakturaadress.Postnummer").append("</li>");
        }
        if (this.iColumns.containsKey("Fakturaadress.Postort")) {
            sb.append("<li>").append("Fakturaadress.Postort").append("</li>");
        }
        if (this.iColumns.containsKey("Fakturaadress.Land")) {
            sb.append("<li>").append("Fakturaadress.Land").append("</li>");
        }
        if (this.iColumns.containsKey("Leveransadress.Namn")) {
            sb.append("<li>").append("Leveransadress.Namn").append("</li>");
        }
        if (this.iColumns.containsKey("Leveransadress.Adress1")) {
            sb.append("<li>").append("Leveransadress.Adress1").append("</li>");
        }
        if (this.iColumns.containsKey("Leveransadress.Adress2")) {
            sb.append("<li>").append("Leveransadress.Adress2").append("</li>");
        }
        if (this.iColumns.containsKey("Leveransadress.Postnummer")) {
            sb.append("<li>").append("Leveransadress.Postnummer").append("</li>");
        }
        if (this.iColumns.containsKey("Leveransadress.Postort")) {
            sb.append("<li>").append("Leveransadress.Postort").append("</li>");
        }
        if (this.iColumns.containsKey("Leveransadress.Land")) {
            sb.append("<li>").append("Leveransadress.Land").append("</li>");
        }
        sb.append("</ul>");
        sb.append("F\u00f6ljande kunder kommer att importeras:<br>");
        sb.append("<ul>");
        for (SSCustomer iCustomer : iCustomers) {
            sb.append("<li>");
            sb.append(iCustomer);
            sb.append("</li>");
        }
        sb.append("</ul>");
        sb.append("Forts\u00e4tt med importeringen ?");
        sb.append("</html>");
        iDialog.setText(sb.toString());
        iDialog.setSize(640, 480);
        iDialog.setLocationRelativeTo(SSMainFrame.getInstance());
        return iDialog.showDialog() == 0;
    }

    public void doImport() throws SSImportException {
        LinkedList<SSCustomer> iCustomers = new LinkedList<SSCustomer>();
        try {
            DocumentBuilderFactory iDocBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder iDocBuilder = iDocBuilderFactory.newDocumentBuilder();
            Document iDoc = iDocBuilder.parse(this.iFile.getAbsolutePath());
            iDoc.getDocumentElement().normalize();
            if (!iDoc.getDocumentElement().getNodeName().equals("Customers")) {
                throw new SSImportException("Filen inneh\u00e5ller inga kunder");
            }
            NodeList iCustomerList = iDoc.getElementsByTagName("Customer");
            if (iCustomerList.getLength() == 0) {
                throw new SSImportException("Filen inneh\u00e5ller inga kunder");
            }
            for (int i = 0; i < iCustomerList.getLength(); ++i) {
                SSCustomer iCustomer = new SSCustomer();
                Node iCustomerNode = iCustomerList.item(i);
                if (iCustomerNode.getNodeType() != 1) continue;
                NodeList iTextCustomerAttList = null;
                String iValue = null;
                Element iCustomerElement = (Element)iCustomerNode;
                NodeList iCustomerAttList = iCustomerElement.getElementsByTagName("CustomerNo");
                Element iFirstCustomerAttElement = (Element)iCustomerAttList.item(0);
                if (iFirstCustomerAttElement != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setNumber(iValue == null ? "" : iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("CustomerName")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setName(iValue == null ? "" : iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("CurrencyCode")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    SSCurrency iCurrency = this.getCurrency(iValue);
                    iCustomer.setInvoiceCurrency(iCurrency);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("OurContactPerson")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setOurContactPerson(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("YourContactPerson")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setYourContactPerson(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("PaymentTerms")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setPaymentTerm(this.getPaymentTerm(iValue));
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("DeliveryTerms")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setDeliveryTerm(this.getDeliveryTerm(iValue));
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("DeliveryMethod")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setDeliveryWay(this.getDeliveryWay(iValue));
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("TaxFree")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setTaxFree(Boolean.valueOf(iValue));
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("EuSaleCommodity")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setEuSaleCommodity(Boolean.valueOf(iValue));
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("EuSaleThirdPartCommodity")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setEuSaleYhirdPartCommodity(Boolean.valueOf(iValue));
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("VATRegNo")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setVATNumber(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("Email")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setEMail(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("CompanyNo")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setRegistrationNumber(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("Telefax")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setTelefax(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("Telephone")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setPhone1(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("Telephone2")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setPhone2(iValue);
                }
                SSAddress iInvoiceAddress = new SSAddress();
                iCustomerAttList = iCustomerElement.getElementsByTagName("InvoiceName");
                iFirstCustomerAttElement = (Element)iCustomerAttList.item(0);
                if (iFirstCustomerAttElement != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iInvoiceAddress.setName(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("InvoiceAddress1")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iInvoiceAddress.setAddress1(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("InvoiceAddress2")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iInvoiceAddress.setAddress2(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("InvoicePostCode")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iInvoiceAddress.setZipCode(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("InvoicePostOffice")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iInvoiceAddress.setCity(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("InvoiceCountry")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iInvoiceAddress.setCountry(iValue);
                }
                iCustomer.setInvoiceAddress(iInvoiceAddress);
                SSAddress iDeliveryAddress = new SSAddress();
                iCustomerAttList = iCustomerElement.getElementsByTagName("DeliveryName");
                iFirstCustomerAttElement = (Element)iCustomerAttList.item(0);
                if (iFirstCustomerAttElement != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iDeliveryAddress.setName(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("DeliveryAddress1")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iDeliveryAddress.setAddress1(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("DeliveryAddress2")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iDeliveryAddress.setAddress2(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("DeliveryPostCode")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iDeliveryAddress.setZipCode(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("DeliveryPostOffice")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iDeliveryAddress.setCity(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("DeliveryCountry")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iDeliveryAddress.setCountry(iValue);
                }
                iCustomer.setDeliveryAddress(iDeliveryAddress);
                iCustomerAttList = iCustomerElement.getElementsByTagName("HideUnitPrice");
                iFirstCustomerAttElement = (Element)iCustomerAttList.item(0);
                if (iFirstCustomerAttElement != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "false" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setHideUnitprice(Boolean.valueOf(iValue));
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("CreditLimit")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "0.0" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setCreditLimit(new BigDecimal(iValue));
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("Discount")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "0.0" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setDiscount(new BigDecimal(iValue));
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("BgNo")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setBankgiro(iValue);
                }
                if ((iFirstCustomerAttElement = (Element)(iCustomerAttList = iCustomerElement.getElementsByTagName("PgNo")).item(0)) != null) {
                    iTextCustomerAttList = iFirstCustomerAttElement.getChildNodes();
                    iValue = iTextCustomerAttList.item(0) == null ? "" : iTextCustomerAttList.item(0).getNodeValue().trim();
                    iCustomer.setPlusgiro(iValue);
                }
                iCustomers.add(iCustomer);
            }
            for (SSCustomer pCustomer : iCustomers) {
                if (SSDB.getInstance().getCustomers().contains(pCustomer)) {
                    SSDB.getInstance().updateCustomer(pCustomer);
                    continue;
                }
                SSDB.getInstance().addCustomer(pCustomer);
            }
        }
        catch (ParserConfigurationException e) {
            throw new SSImportException(e.getMessage());
        }
        catch (SAXException e) {
            throw new SSImportException(e.getMessage());
        }
        catch (IOException e) {
            throw new SSImportException(e.getMessage());
        }
    }

    private SSCurrency getCurrency(String iName) {
        for (SSCurrency iCurrency : SSDB.getInstance().getCurrencies()) {
            if (!iCurrency.getName().equals(iName)) continue;
            return iCurrency;
        }
        return null;
    }

    private SSPaymentTerm getPaymentTerm(String iName) {
        for (SSPaymentTerm iPaymentTerm : SSDB.getInstance().getPaymentTerms()) {
            if (!iPaymentTerm.getName().equals(iName)) continue;
            return iPaymentTerm;
        }
        return null;
    }

    private SSDeliveryTerm getDeliveryTerm(String iName) {
        for (SSDeliveryTerm iDeliveryTerm : SSDB.getInstance().getDeliveryTerms()) {
            if (!iDeliveryTerm.getName().equals(iName)) continue;
            return iDeliveryTerm;
        }
        return null;
    }

    private SSDeliveryWay getDeliveryWay(String iName) {
        for (SSDeliveryWay iDeliveryWay : SSDB.getInstance().getDeliveryWays()) {
            if (!iDeliveryWay.getName().equals(iName)) continue;
            return iDeliveryWay;
        }
        return null;
    }

    public void doEbutikImport() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.iFile), "Windows-1252"));
            String text = null;
            ArrayList<String> al = new ArrayList<String>();
            ArrayList<String> iBadCustomers = new ArrayList<String>();
            while ((text = br.readLine()) != null) {
                al.add(text);
            }
            br.close();
            Integer iCustomerCount = 0;
            for (String iLine : al) {
                Integer n;
                Integer n2;
                boolean iNewCustomer = false;
                String[] iFields = iLine.split("\t", -1);
                SSCustomer iCustomer = SSDB.getInstance().getCustomer(iFields[0]);
                if (iCustomer == null) {
                    iCustomer = new SSCustomer();
                    iCustomer.setNumber(iFields[0]);
                    iNewCustomer = true;
                }
                if (iFields.length == 20) {
                    if (iFields[2] == null || iFields[2].length() == 0) {
                        iCustomer.getInvoiceAddress().setName(iFields[3] + ' ' + iFields[4]);
                        iCustomer.setName(iFields[3] + ' ' + iFields[4]);
                        iCustomer.getInvoiceAddress().setAddress1(iFields[5]);
                    } else {
                        iCustomer.getInvoiceAddress().setName(iFields[2]);
                        iCustomer.getInvoiceAddress().setAddress1(iFields[3] + ' ' + iFields[4]);
                        iCustomer.getInvoiceAddress().setAddress2(iFields[5]);
                        iCustomer.setName(iFields[2]);
                    }
                    iCustomer.setYourContactPerson(iFields[3] + ' ' + iFields[4]);
                    iCustomer.getInvoiceAddress().setZipCode(iFields[6]);
                    iCustomer.getInvoiceAddress().setCity(iFields[7]);
                    iCustomer.getInvoiceAddress().setCountry(iFields[8]);
                    if (iFields[9] == null || iFields[9].length() == 0 && iFields[2].length() == 0) {
                        iCustomer.getDeliveryAddress().setName((iFields[10] + ' ' + iFields[11]).equals(" ") ? iCustomer.getInvoiceAddress().getName() : iFields[10] + ' ' + iFields[11]);
                        iCustomer.getDeliveryAddress().setAddress1(iFields[12].length() == 0 ? iCustomer.getInvoiceAddress().getAddress1() : iFields[12]);
                    } else {
                        iCustomer.getDeliveryAddress().setName(iFields[9].length() == 0 ? iCustomer.getInvoiceAddress().getName() : iFields[9]);
                        iCustomer.getDeliveryAddress().setAddress1((iFields[10] + ' ' + iFields[11]).equals(" ") ? iCustomer.getInvoiceAddress().getAddress1() : iFields[10] + ' ' + iFields[11]);
                        iCustomer.getDeliveryAddress().setAddress2(iFields[12].length() == 0 ? iCustomer.getInvoiceAddress().getAddress2() : iFields[12]);
                    }
                    iCustomer.getDeliveryAddress().setZipCode(iFields[13].length() == 0 ? iCustomer.getInvoiceAddress().getZipCode() : iFields[13]);
                    iCustomer.getDeliveryAddress().setCity(iFields[14].length() == 0 ? iCustomer.getInvoiceAddress().getCity() : iFields[14]);
                    iCustomer.getDeliveryAddress().setCountry(iFields[15].length() == 0 ? iCustomer.getInvoiceAddress().getCountry() : iFields[15]);
                    iCustomer.setPhone1(iFields[16]);
                    iCustomer.setTelefax(iFields[17]);
                    iCustomer.setEMail(iFields[18]);
                    iCustomer.setRegistrationNumber(iFields[19]);
                    if (iNewCustomer) {
                        SSDB.getInstance().addCustomer(iCustomer);
                    } else {
                        SSDB.getInstance().updateCustomer(iCustomer);
                    }
                    n2 = iCustomerCount;
                    n = iCustomerCount = Integer.valueOf(iCustomerCount + 1);
                    continue;
                }
                if (iFields.length == 19) {
                    if (iFields[1] == null || iFields[1].length() == 0) {
                        iCustomer.getInvoiceAddress().setName(iFields[2] + ' ' + iFields[3]);
                        iCustomer.setName(iFields[2] + ' ' + iFields[3]);
                        iCustomer.getInvoiceAddress().setAddress1(iFields[4]);
                    } else {
                        iCustomer.getInvoiceAddress().setName(iFields[1]);
                        iCustomer.getInvoiceAddress().setAddress1(iFields[2] + ' ' + iFields[3]);
                        iCustomer.getInvoiceAddress().setAddress2(iFields[4]);
                        iCustomer.setName(iFields[1]);
                    }
                    iCustomer.setYourContactPerson(iFields[2] + ' ' + iFields[3]);
                    iCustomer.getInvoiceAddress().setZipCode(iFields[5]);
                    iCustomer.getInvoiceAddress().setCity(iFields[6]);
                    iCustomer.getInvoiceAddress().setCountry(iFields[7]);
                    if (iFields[8] == null || iFields[8].length() == 0 && iFields[1].length() == 0) {
                        iCustomer.getDeliveryAddress().setName((iFields[9] + ' ' + iFields[10]).equals(" ") ? iCustomer.getInvoiceAddress().getName() : iFields[9] + ' ' + iFields[10]);
                        iCustomer.getDeliveryAddress().setAddress1(iFields[11].length() == 0 ? iCustomer.getInvoiceAddress().getAddress1() : iFields[11]);
                    } else {
                        iCustomer.getDeliveryAddress().setName(iFields[8].length() == 0 ? iCustomer.getInvoiceAddress().getName() : iFields[8]);
                        iCustomer.getDeliveryAddress().setAddress1((iFields[9] + ' ' + iFields[10]).equals(" ") ? iCustomer.getInvoiceAddress().getAddress1() : iFields[9] + ' ' + iFields[10]);
                        iCustomer.getDeliveryAddress().setAddress2(iFields[11].length() == 0 ? iCustomer.getInvoiceAddress().getAddress2() : iFields[11]);
                    }
                    iCustomer.getDeliveryAddress().setZipCode(iFields[12].length() == 0 ? iCustomer.getInvoiceAddress().getZipCode() : iFields[12]);
                    iCustomer.getDeliveryAddress().setCity(iFields[13].length() == 0 ? iCustomer.getInvoiceAddress().getCity() : iFields[13]);
                    iCustomer.getDeliveryAddress().setCountry(iFields[14].length() == 0 ? iCustomer.getInvoiceAddress().getCountry() : iFields[14]);
                    iCustomer.setPhone1(iFields[15]);
                    iCustomer.setTelefax(iFields[16]);
                    iCustomer.setEMail(iFields[17]);
                    iCustomer.setRegistrationNumber(iFields[18]);
                    if (iNewCustomer) {
                        SSDB.getInstance().addCustomer(iCustomer);
                    } else {
                        SSDB.getInstance().updateCustomer(iCustomer);
                    }
                    n2 = iCustomerCount;
                    n = iCustomerCount = Integer.valueOf(iCustomerCount + 1);
                    continue;
                }
                iBadCustomers.add(iFields[0] + " - Fel antal f\u00e4lt");
            }
            if (!iBadCustomers.isEmpty()) {
                BufferedWriter bw = new BufferedWriter(new PrintWriter(new File(Path.get(Path.APP_BASE), "kundimport.txt")));
                for (String iBadOrder : iBadCustomers) {
                    bw.write(iBadOrder);
                    bw.newLine();
                }
                bw.close();
                new SSInformationDialog(SSMainFrame.getInstance(), "customerframe.import.errors", iCustomerCount.toString(), String.valueOf(iBadCustomers.size()));
            } else {
                new SSInformationDialog(SSMainFrame.getInstance(), "customerframe.import.noerrors", iCustomerCount.toString());
            }
        }
        catch (IOException e) {
            throw new SSImportException(e.getMessage());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.excel.SSCustomerImporter");
        sb.append("{iColumns=").append(this.iColumns);
        sb.append(", iFile=").append(this.iFile);
        sb.append('}');
        return sb.toString();
    }
}

