/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.excel;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProductRow;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.common.SSUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInitDialog;
import se.swedsoft.bookkeeping.importexport.dialog.SSImportReportDialog;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelCell;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelRow;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelSheet;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SSProductImporter {
    private File iFile;
    private Map<String, Integer> iColumns;

    public SSProductImporter(File iFile) {
        this.iFile = iFile;
        this.iColumns = new HashMap<String, Integer>();
    }

    public void doImport() throws IOException, SSImportException {
        WorkbookSettings iSettings = new WorkbookSettings();
        iSettings.setLocale(new Locale("sv", "SE"));
        iSettings.setEncoding("windows-1252");
        iSettings.setExcelDisplayLanguage("SE");
        iSettings.setExcelRegionalSettings("SE");
        List<SSProduct> iProducts = null;
        try {
            Workbook iWorkbook = Workbook.getWorkbook(this.iFile, iSettings);
            Sheet iSheet = iWorkbook.getSheet(0);
            iProducts = this.importProducts(new SSExcelSheet(iSheet));
            iWorkbook.close();
        }
        catch (BiffException e) {
            throw new SSImportException(e.getLocalizedMessage());
        }
        final LinkedList<SSProduct> iNewProducts = new LinkedList<SSProduct>(iProducts);
        final boolean iResult = this.showImportReport(iProducts);
        SSInitDialog.runProgress(SSMainFrame.getInstance(), "Importerar produkter", new Runnable(){

            @Override
            public void run() {
                if (iNewProducts != null && iResult) {
                    List<SSProduct> iExistingProducts = SSDB.getInstance().getProducts();
                    for (SSProduct iProduct : iNewProducts) {
                        if (iExistingProducts.contains(iProduct)) continue;
                        SSDB.getInstance().addProduct(iProduct);
                    }
                }
            }
        });
    }

    private void getColumnIndexes(SSExcelRow iColumns) {
        this.iColumns.clear();
        int iIndex = 0;
        for (SSExcelCell iColumn : iColumns.getCells()) {
            String iName = iColumn.getString();
            if (iName != null && iName.length() > 0) {
                if (iName.equalsIgnoreCase("Beskrivning")) {
                    this.iColumns.put("Beskrivning", iIndex);
                } else if (iName.equalsIgnoreCase("Produkt-id")) {
                    this.iColumns.put("Produkt-id", iIndex);
                } else if (iName.equalsIgnoreCase("F\u00f6rs\u00e4ljningspris")) {
                    this.iColumns.put("F\u00f6rs\u00e4ljningspris", iIndex);
                } else if (iName.equalsIgnoreCase("Ink\u00f6pspris")) {
                    this.iColumns.put("Ink\u00f6pspris", iIndex);
                } else if (iName.equalsIgnoreCase("Enhetsfrakt")) {
                    this.iColumns.put("Enhetsfrakt", iIndex);
                } else if (iName.equalsIgnoreCase("Moms")) {
                    this.iColumns.put("Moms", iIndex);
                } else if (iName.equalsIgnoreCase("Enhet")) {
                    this.iColumns.put("Enhet", iIndex);
                } else if (iName.equalsIgnoreCase("Vikt")) {
                    this.iColumns.put("Vikt", iIndex);
                } else if (iName.equalsIgnoreCase("Volym")) {
                    this.iColumns.put("Volym", iIndex);
                } else if (iName.equalsIgnoreCase("Leverant\u00f6r")) {
                    this.iColumns.put("Leverant\u00f6r", iIndex);
                } else if (iName.equalsIgnoreCase("Leverant\u00f6rens artikelnummer")) {
                    this.iColumns.put("Leverant\u00f6rens artikelnummer", iIndex);
                } else if (iName.equalsIgnoreCase("Best\u00e4llningspunkt")) {
                    this.iColumns.put("Best\u00e4llningspunkt", iIndex);
                } else if (iName.equalsIgnoreCase("Lagerplats")) {
                    this.iColumns.put("Lagerplats", iIndex);
                } else if (iName.equalsIgnoreCase("Lagerantal")) {
                    this.iColumns.put("Lagerantal", iIndex);
                } else if (iName.equalsIgnoreCase("Disponibelt")) {
                    this.iColumns.put("Disponibelt", iIndex);
                } else if (iName.equalsIgnoreCase("Lagerpris")) {
                    this.iColumns.put("Lagerpris", iIndex);
                } else {
                    throw new SSImportException("Ogiltigt kolumnnamn i importfilen: %s", iName);
                }
            }
            ++iIndex;
        }
    }

    private List<SSProduct> importProducts(SSExcelSheet iSheet) {
        List<SSExcelRow> iRows = iSheet.getRows();
        if (iRows.size() < 2) {
            throw new SSImportException(SSBundle.getBundle(), "productframe.import.norows");
        }
        this.getColumnIndexes(iRows.get(0));
        LinkedList<SSProduct> iProducts = new LinkedList<SSProduct>();
        for (int row = 1; row < iRows.size(); ++row) {
            SSExcelRow iRow = iRows.get(row);
            if (iRow.empty()) continue;
            List<SSExcelCell> iCells = iRow.getCells();
            SSProduct iProduct = new SSProduct();
            for (int col = 0; col < iCells.size(); ++col) {
                SSExcelCell iCell = iCells.get(col);
                String iValue = iCell.getString();
                DecimalFormat iFormat = new DecimalFormat("0,0000");
                iFormat.setParseBigDecimal(true);
                try {
                    if (this.iColumns.containsKey("Produkt-id") && this.iColumns.get("Produkt-id") == col) {
                        iProduct.setNumber(iValue);
                    }
                    if (this.iColumns.containsKey("Beskrivning") && this.iColumns.get("Beskrivning") == col) {
                        iProduct.setDescription(iValue);
                    }
                    if (this.iColumns.containsKey("F\u00f6rs\u00e4ljningspris") && this.iColumns.get("F\u00f6rs\u00e4ljningspris") == col) {
                        iProduct.setSellingPrice((BigDecimal)iFormat.parse(iValue));
                    }
                    if (this.iColumns.containsKey("Ink\u00f6pspris") && this.iColumns.get("Ink\u00f6pspris") == col) {
                        iProduct.setPurchasePrice((BigDecimal)iFormat.parse(iValue));
                    }
                    if (this.iColumns.containsKey("Enhetsfrakt") && this.iColumns.get("Enhetsfrakt") == col) {
                        iProduct.setUnitFreight((BigDecimal)iFormat.parse(iValue));
                    }
                    if (this.iColumns.containsKey("Moms") && this.iColumns.get("Moms") == col) {
                        iProduct.setTaxCode(SSTaxCode.decode(iValue));
                    }
                    if (this.iColumns.containsKey("Enhet") && this.iColumns.get("Enhet") == col) {
                        iProduct.setUnit(SSUnit.decode(iValue));
                    }
                    if (this.iColumns.containsKey("Vikt") && this.iColumns.get("Vikt") == col) {
                        iProduct.setWeight((BigDecimal)iFormat.parse(iValue));
                    }
                    if (this.iColumns.containsKey("Volym") && this.iColumns.get("Volym") == col) {
                        iProduct.setVolume((BigDecimal)iFormat.parse(iValue));
                    }
                    if (this.iColumns.containsKey("Leverant\u00f6r") && this.iColumns.get("Leverant\u00f6r") == col) {
                        iProduct.setSupplierNr(iValue);
                    }
                    if (this.iColumns.containsKey("Leverant\u00f6rens artikelnummer") && this.iColumns.get("Leverant\u00f6rens artikelnummer") == col) {
                        iProduct.setSupplierProductNr(iValue);
                    }
                    if (this.iColumns.containsKey("Best\u00e4llningspunkt") && this.iColumns.get("Best\u00e4llningspunkt") == col) {
                        iProduct.setOrderpoint(Integer.valueOf(iValue));
                    }
                    if (this.iColumns.containsKey("Lagerplats") && this.iColumns.get("Lagerplats") == col) {
                        iProduct.setWarehouseLocation(iValue);
                    }
                    if (!this.iColumns.containsKey("Lagerpris") || this.iColumns.get("Lagerpris") != col) continue;
                    iProduct.setStockPrice((BigDecimal)iFormat.parse(iValue));
                    continue;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new SSImportException(e.getLocalizedMessage());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new SSImportException(e.getLocalizedMessage());
                }
            }
            if (iProduct.getNumber() == null || iProduct.getNumber().length() <= 0) continue;
            iProducts.add(iProduct);
        }
        return iProducts;
    }

    private boolean showImportReport(List<SSProduct> iProducts) {
        SSImportReportDialog iDialog = new SSImportReportDialog(SSMainFrame.getInstance(), SSBundle.getBundle().getString("productframe.import.report"));
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("F\ufffdljande kolumner har importerats fr\ufffdn produktfilen:<br>");
        sb.append("<ul>");
        if (this.iColumns.containsKey("Produkt-id")) {
            sb.append("<li>").append("Produkt-id").append("</li>");
        }
        if (this.iColumns.containsKey("Beskrivning")) {
            sb.append("<li>").append("Beskrivning").append("</li>");
        }
        if (this.iColumns.containsKey("F\u00f6rs\u00e4ljningspris")) {
            sb.append("<li>").append("F\u00f6rs\u00e4ljningspris").append("</li>");
        }
        if (this.iColumns.containsKey("Ink\u00f6pspris")) {
            sb.append("<li>").append("Ink\u00f6pspris").append("</li>");
        }
        if (this.iColumns.containsKey("Enhetsfrakt")) {
            sb.append("<li>").append("Enhetsfrakt").append("</li>");
        }
        if (this.iColumns.containsKey("Moms")) {
            sb.append("<li>").append("Moms").append("</li>");
        }
        if (this.iColumns.containsKey("Enhet")) {
            sb.append("<li>").append("Enhet").append("</li>");
        }
        if (this.iColumns.containsKey("Vikt")) {
            sb.append("<li>").append("Vikt").append("</li>");
        }
        if (this.iColumns.containsKey("Volym")) {
            sb.append("<li>").append("Volym").append("</li>");
        }
        if (this.iColumns.containsKey("Leverant\u00f6r")) {
            sb.append("<li>").append("Leverant\u00f6r").append("</li>");
        }
        if (this.iColumns.containsKey("Leverant\u00f6rens artikelnummer")) {
            sb.append("<li>").append("Leverant\u00f6rens artikelnummer").append("</li>");
        }
        if (this.iColumns.containsKey("Best\u00e4llningspunkt")) {
            sb.append("<li>").append("Best\u00e4llningspunkt").append("</li>");
        }
        if (this.iColumns.containsKey("Lagerplats")) {
            sb.append("<li>").append("Lagerplats").append("</li>");
        }
        if (this.iColumns.containsKey("Lagerpris")) {
            sb.append("<li>").append("Lagerpris").append("</li>");
        }
        sb.append("</ul>");
        sb.append("F\ufffdljande produkter kommer att importeras:<br>");
        sb.append("<ul>");
        for (SSProduct iProduct : iProducts) {
            sb.append("<li>");
            sb.append(iProduct);
            sb.append("</li>");
        }
        sb.append("</ul>");
        sb.append("Forts\ufffdtt med importeringen ?");
        sb.append("</html>");
        iDialog.setText(sb.toString());
        iDialog.setSize(640, 480);
        iDialog.setLocationRelativeTo(SSMainFrame.getInstance());
        return iDialog.showDialog() == 0;
    }

    public void doXMLImport() throws SSImportException {
        LinkedList<SSProduct> iProducts = new LinkedList<SSProduct>();
        try {
            DocumentBuilderFactory iDocBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder iDocBuilder = iDocBuilderFactory.newDocumentBuilder();
            Document iDoc = iDocBuilder.parse(this.iFile.getAbsolutePath());
            iDoc.getDocumentElement().normalize();
            if (!iDoc.getDocumentElement().getNodeName().equals("Products")) {
                throw new SSImportException("Filen inneh\ufffdller inga produkter");
            }
            NodeList iProductList = iDoc.getElementsByTagName("Product");
            if (iProductList.getLength() == 0) {
                throw new SSImportException("Filen inneh\ufffdller inga produkter");
            }
            for (int i = 0; i < iProductList.getLength(); ++i) {
                SSProduct iProduct = new SSProduct();
                Node iProductNode = iProductList.item(i);
                if (iProductNode.getNodeType() != 1) continue;
                NodeList iTextProductAttList = null;
                String iValue = null;
                Element iProductElement = (Element)iProductNode;
                NodeList iProductAttList = iProductElement.getElementsByTagName("ProductNo");
                Element iFirstProductAttElement = (Element)iProductAttList.item(0);
                if (iFirstProductAttElement != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setNumber(iValue == null ? "" : iValue);
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("ProductDescription")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setDescription(iValue == null ? "" : iValue);
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("UnitPrice")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setSellingPrice(iValue == null ? new BigDecimal("0.0") : new BigDecimal(iValue));
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("TaxRate")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setTaxCode(iValue == null ? SSTaxCode.decode("0") : SSTaxCode.decode(iValue));
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("PurchasePrice")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setPurchasePrice(iValue == null ? new BigDecimal("0.0") : new BigDecimal(iValue));
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("UnitFreight")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setUnitFreight(iValue == null ? new BigDecimal("0.0") : new BigDecimal(iValue));
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("Unit")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setUnit(iValue == null ? null : SSUnit.decode(iValue));
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("Weight")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setWeight(iValue == null ? new BigDecimal("0.0") : new BigDecimal(iValue));
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("Volume")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setVolume(iValue == null ? new BigDecimal("0.0") : new BigDecimal(iValue));
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("SaleAccount")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setDefaultAccount(SSDefaultAccount.Sales, iValue == null ? null : Integer.valueOf(Integer.parseInt(iValue)));
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("PurchaseAccount")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setDefaultAccount(SSDefaultAccount.Purchases, iValue == null ? null : Integer.valueOf(Integer.parseInt(iValue)));
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("Expired")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setExpired(iValue != null && Boolean.valueOf(iValue) != false);
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("StockProduct")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setStockProduct(iValue != null && Boolean.valueOf(iValue) != false);
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("WarehouseLocation")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setWarehouseLocation(iValue);
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("OrderPoint")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setOrderpoint(iValue == null ? null : Integer.valueOf(Integer.parseInt(iValue)));
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("OrderCount")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setOrdercount(iValue == null ? null : Integer.valueOf(Integer.parseInt(iValue)));
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("SupplierProductNo")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setSupplierProductNr(iValue);
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("Supplier")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setSupplier(this.getSupplier(iValue));
                }
                if ((iFirstProductAttElement = (Element)(iProductAttList = iProductElement.getElementsByTagName("EnProductDescription")).item(0)) != null) {
                    iTextProductAttList = iFirstProductAttElement.getChildNodes();
                    iValue = iTextProductAttList.item(0) == null ? null : iTextProductAttList.item(0).getNodeValue().trim();
                    iProduct.setDescription(new Locale("en"), iValue);
                }
                iProductAttList = iProductElement.getElementsByTagName("Detail");
                iFirstProductAttElement = (Element)iProductAttList.item(0);
                NodeList iRowList = iFirstProductAttElement.getElementsByTagName("ParcelRow");
                LinkedList<SSProductRow> iRows = new LinkedList<SSProductRow>();
                for (int j = 0; j < iRowList.getLength(); ++j) {
                    SSProductRow iRow = new SSProductRow();
                    Node iRowNode = iRowList.item(j);
                    if (iRowNode.getNodeType() != 1) continue;
                    Element iRowElement = (Element)iRowNode;
                    NodeList iTextRowAttList = null;
                    NodeList iRowAttList = iRowElement.getElementsByTagName("IncludedProductNo");
                    Element iFirstRowAttElement = (Element)iRowAttList.item(0);
                    if (iFirstProductAttElement != null) {
                        iTextRowAttList = iFirstRowAttElement.getChildNodes();
                        iValue = iTextRowAttList.item(0) == null ? null : iTextRowAttList.item(0).getNodeValue().trim();
                        iRow.setProduct(this.getProduct(iValue));
                    }
                    iRowAttList = iRowElement.getElementsByTagName("RowQuantity");
                    iFirstRowAttElement = (Element)iRowAttList.item(0);
                    if (iFirstProductAttElement != null) {
                        iTextRowAttList = iFirstRowAttElement.getChildNodes();
                        iValue = iTextRowAttList.item(0) == null ? null : iTextRowAttList.item(0).getNodeValue().trim();
                        iRow.setQuantity(iValue == null ? null : Integer.valueOf(Integer.parseInt(iValue)));
                    }
                    if (iRow.getProductNr() == null) continue;
                    iRows.add(iRow);
                }
                if (!iRows.isEmpty()) {
                    iProduct.setParcelRows(iRows);
                }
                iProducts.add(iProduct);
            }
            List<SSProduct> iExistingProducts = SSDB.getInstance().getProducts();
            for (SSProduct pProduct : iProducts) {
                if (iExistingProducts.contains(pProduct)) {
                    SSDB.getInstance().updateProduct(pProduct);
                    continue;
                }
                SSDB.getInstance().addProduct(pProduct);
            }
        }
        catch (ParserConfigurationException e) {
            throw new SSImportException(e.getMessage());
        }
        catch (SAXException e) {
            throw new SSImportException(e.getMessage());
        }
        catch (IOException e) {
            throw new SSImportException(e.getMessage());
        }
    }

    private SSProduct getProduct(String iNumber) {
        List<SSProduct> iProducts = SSDB.getInstance().getProducts();
        for (SSProduct iProduct : iProducts) {
            if (!iProduct.getNumber().equals(iNumber)) continue;
            return iProduct;
        }
        return null;
    }

    private SSSupplier getSupplier(String iNumber) {
        for (SSSupplier iSupplier : SSDB.getInstance().getSuppliers()) {
            if (!iSupplier.getNumber().equals(iNumber)) continue;
            return iSupplier;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.excel.SSProductImporter");
        sb.append("{iColumns=").append(this.iColumns);
        sb.append(", iFile=").append(this.iFile);
        sb.append('}');
        return sb.toString();
    }
}

