/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.excel;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import se.swedsoft.bookkeeping.data.SSVoucherTemplate;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.importexport.dialog.SSImportReportDialog;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelCell;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelRow;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelSheet;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SSVoucherTemplateImporter {
    private File iFile;
    private Map<String, Integer> iColumns;

    public SSVoucherTemplateImporter(File iFile) {
        this.iFile = iFile;
        this.iColumns = new HashMap<String, Integer>();
    }

    public void Import() throws IOException, SSImportException {
        WorkbookSettings iSettings = new WorkbookSettings();
        iSettings.setLocale(new Locale("sv", "SE"));
        iSettings.setEncoding("windows-1252");
        iSettings.setExcelDisplayLanguage("SE");
        iSettings.setExcelRegionalSettings("SE");
        List<SSVoucherTemplate> iVoucherTemplates = null;
        try {
            Workbook iWorkbook = Workbook.getWorkbook(this.iFile, iSettings);
            if (iWorkbook.getNumberOfSheets() == 0) {
                throw new SSImportException(SSBundle.getBundle(), "vouchertemplateframe.import.nosheets");
            }
            Sheet iSheet = iWorkbook.getSheet(0);
            iVoucherTemplates = this.importVouchers(new SSExcelSheet(iSheet));
            iWorkbook.close();
        }
        catch (BiffException e) {
            throw new SSImportException(e.getLocalizedMessage());
        }
        boolean iResult = this.showImportReport(iVoucherTemplates);
        if (iVoucherTemplates != null && iResult) {
            for (SSVoucherTemplate iVoucherTemplate : iVoucherTemplates) {
                if (SSDB.getInstance().getVoucherTemplates().contains(iVoucherTemplate)) continue;
                SSDB.getInstance().addVoucherTemplate(iVoucherTemplate);
            }
        }
    }

    private void getColumnIndexes(SSExcelRow iColumns) {
        this.iColumns.clear();
        int iIndex = 0;
        for (SSExcelCell iColumn : iColumns.getCells()) {
            String iName = iColumn.getString();
            if (iName != null && iName.length() > 0) {
                if (iName.equalsIgnoreCase("Beskrivning")) {
                    this.iColumns.put("Beskrivning", iIndex);
                } else if (iName.equalsIgnoreCase("Konto")) {
                    this.iColumns.put("Konto", iIndex);
                } else if (iName.equalsIgnoreCase("Debet")) {
                    this.iColumns.put("Debet", iIndex);
                } else if (iName.equalsIgnoreCase("Kredit")) {
                    this.iColumns.put("Kredit", iIndex);
                } else {
                    throw new SSImportException("Ogiltigt kolumnnamn i importfilen: %s", iName);
                }
            }
            ++iIndex;
        }
    }

    private List<SSVoucherTemplate> importVouchers(SSExcelSheet pSheet) {
        List<SSExcelRow> iRows = pSheet.getRows();
        if (iRows.size() < 2) {
            throw new SSImportException(SSBundle.getBundle(), "vouchertemplateframe.import.norows");
        }
        this.getColumnIndexes(iRows.get(0));
        LinkedList<SSVoucherTemplate> iVoucherTemplates = new LinkedList<SSVoucherTemplate>();
        SSVoucherTemplate iVoucherTemplate = null;
        SSVoucherTemplate.SSVoucherTemplateRow iVoucherTemplateRow = null;
        for (int row = 1; row < iRows.size(); ++row) {
            SSExcelRow iRow = iRows.get(row);
            if (iRow.empty()) continue;
            List<SSExcelCell> iCells = iRow.getCells();
            for (int col = 0; col < iCells.size(); ++col) {
                SSExcelCell iCell = iCells.get(col);
                String iValue = iCell.getString();
                if (iValue == null || iValue.trim().length() == 0) continue;
                if (this.iColumns.containsKey("Beskrivning") && this.iColumns.get("Beskrivning") == col) {
                    iVoucherTemplate = new SSVoucherTemplate();
                    iVoucherTemplate.setDescription(iCell.getString());
                    iVoucherTemplates.add(iVoucherTemplate);
                }
                if (iVoucherTemplate == null) continue;
                if (this.iColumns.containsKey("Konto") && this.iColumns.get("Konto") == col) {
                    iVoucherTemplateRow = new SSVoucherTemplate.SSVoucherTemplateRow();
                    iVoucherTemplateRow.setAccountNr(iCell.getInteger());
                    iVoucherTemplate.getRows().add(iVoucherTemplateRow);
                }
                if (iVoucherTemplateRow == null) continue;
                if (this.iColumns.containsKey("Debet") && this.iColumns.get("Debet") == col) {
                    iVoucherTemplateRow.setDebet(iCell.getBigDecimal());
                }
                if (!this.iColumns.containsKey("Kredit") || this.iColumns.get("Kredit") != col) continue;
                iVoucherTemplateRow.setCredit(iCell.getBigDecimal());
            }
        }
        return iVoucherTemplates;
    }

    private boolean showImportReport(List<SSVoucherTemplate> iVoucherTemplates) {
        SSImportReportDialog iDialog = new SSImportReportDialog(SSMainFrame.getInstance(), SSBundle.getBundle().getString("vouchertemplateframe.import.report"));
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("F\u00f6ljande konteringsmallar kommer att importeras:<br>");
        sb.append("<ul>");
        for (SSVoucherTemplate iVoucherTemplate : iVoucherTemplates) {
            sb.append("<li>");
            sb.append(iVoucherTemplate);
            sb.append("</li>");
        }
        sb.append("</ul>");
        sb.append("Forts\u00e4tt med importeringen ?");
        sb.append("</html>");
        iDialog.setText(sb.toString());
        iDialog.setSize(640, 480);
        iDialog.setLocationRelativeTo(SSMainFrame.getInstance());
        return iDialog.showDialog() == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.excel.SSVoucherTemplateImporter");
        sb.append("{iColumns=").append(this.iColumns);
        sb.append(", iFile=").append(this.iFile);
        sb.append('}');
        return sb.toString();
    }
}

