/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.excel.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jxl.Cell;
import jxl.DateCell;
import jxl.NumberCell;

public class SSExcelCell {
    private int iRow;
    private int iColumn;
    private Cell iCell;

    public SSExcelCell(Cell pCell, int pRow, int pColumn) {
        this.iCell = pCell;
        this.iRow = pRow;
        this.iColumn = pColumn;
    }

    public String getString() {
        return this.iCell.getContents();
    }

    public Integer getInteger() {
        if (this.iCell instanceof NumberCell) {
            NumberCell iNumber = (NumberCell)this.iCell;
            return Math.round((float)iNumber.getValue());
        }
        try {
            return Integer.parseInt(this.iCell.getContents());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public Double getDouble() {
        if (this.iCell instanceof NumberCell) {
            NumberCell iNumber = (NumberCell)this.iCell;
            return iNumber.getValue();
        }
        try {
            return Double.parseDouble(this.iCell.getContents());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public Date getDate() {
        if (this.iCell instanceof DateCell) {
            DateCell iDateCell = (DateCell)this.iCell;
            return iDateCell.getDate();
        }
        SimpleDateFormat iFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return iFormat.parse(this.iCell.getContents());
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public BigDecimal getBigDecimal() {
        if (this.iCell instanceof NumberCell) {
            NumberCell iNumber = (NumberCell)this.iCell;
            return new BigDecimal(iNumber.getValue());
        }
        try {
            return new BigDecimal(this.iCell.getContents());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public int getColumn() {
        return this.iColumn;
    }

    public int getRow() {
        return this.iRow;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.excel.util.SSExcelCell");
        sb.append("{iCell=").append(this.iCell);
        sb.append(", iColumn=").append(this.iColumn);
        sb.append(", iRow=").append(this.iRow);
        sb.append('}');
        return sb.toString();
    }
}

