/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.excel.util;

import java.util.LinkedList;
import java.util.List;
import jxl.Cell;
import jxl.Sheet;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelCell;

public class SSExcelRow {
    private int iRow;
    private Sheet iSheet;

    public SSExcelRow(Sheet pSheet, int pRow) {
        this.iSheet = pSheet;
        this.iRow = pRow;
    }

    public List<SSExcelCell> getCells() {
        LinkedList<SSExcelCell> iList = new LinkedList<SSExcelCell>();
        int iColumn = 0;
        for (Cell iCell : this.iSheet.getRow(this.iRow)) {
            iList.add(new SSExcelCell(iCell, this.iRow, iColumn));
            ++iColumn;
        }
        return iList;
    }

    public boolean empty() {
        Cell[] iRows = this.iSheet.getRow(this.iRow);
        if (iRows.length == 0) {
            return true;
        }
        for (Cell iCell : iRows) {
            if (iCell.getContents() == null || iCell.getContents().length() <= 0) continue;
            return false;
        }
        return true;
    }

    public int getRow() {
        return this.iRow;
    }

    public String getString(int pColumn) {
        return this.iSheet.getCell(pColumn, this.iRow).getContents();
    }

    public Integer getInteger(int pColumn) {
        try {
            return Integer.parseInt(this.getString(pColumn));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public Double getDouble(int pColumn) {
        try {
            return Double.parseDouble(this.getString(pColumn));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.excel.util.SSExcelRow");
        sb.append("{iRow=").append(this.iRow);
        sb.append(", iSheet=").append(this.iSheet);
        sb.append('}');
        return sb.toString();
    }
}

