/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.excel.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import se.swedsoft.bookkeeping.importexport.excel.util.SSWritableExcelCell;

public class SSWritableExcelRow {
    private int iRow;
    private WritableSheet iSheet;

    public SSWritableExcelRow(WritableSheet pSheet, int pRow) {
        this.iSheet = pSheet;
        this.iRow = pRow;
    }

    public List<SSWritableExcelCell> getCells(int pCount) {
        LinkedList<SSWritableExcelCell> iList = new LinkedList<SSWritableExcelCell>();
        for (int iColumn = 0; iColumn < pCount; ++iColumn) {
            iList.add(new SSWritableExcelCell(this.iSheet, this.iRow, iColumn));
        }
        return iList;
    }

    public int getRow() {
        return this.iRow;
    }

    public void setString(int iColumn, String pValue) throws WriteException {
        try {
            this.iSheet.addCell(new Label(iColumn, this.iRow, pValue == null ? "" : pValue));
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
    }

    public void setString(int iColumn, String pValue, CellFormat iCellFormat) throws WriteException {
        try {
            this.iSheet.addCell(new Label(iColumn, this.iRow, pValue == null ? "" : pValue, iCellFormat));
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
    }

    public void setNumber(int iColumn, java.lang.Number pValue) throws WriteException {
        try {
            if (pValue == null) {
                this.iSheet.addCell(new Label(iColumn, this.iRow, ""));
            } else {
                this.iSheet.addCell(new Number(iColumn, this.iRow, pValue.doubleValue()));
            }
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
    }

    public void setNumber(int iColumn, java.lang.Number pValue, CellFormat iCellFormat) throws WriteException {
        try {
            if (pValue == null) {
                this.iSheet.addCell(new Label(iColumn, this.iRow, "", iCellFormat));
            } else {
                this.iSheet.addCell(new Number(iColumn, this.iRow, pValue.doubleValue(), iCellFormat));
            }
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
    }

    public void setDate(int iColumn, Date pValue) throws WriteException {
        SimpleDateFormat iFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (pValue == null) {
                this.iSheet.addCell(new Label(iColumn, this.iRow, ""));
            } else {
                this.iSheet.addCell(new Label(iColumn, this.iRow, iFormat.format(pValue)));
            }
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
    }

    public void setDate(int iColumn, Date pValue, CellFormat iCellFormat) throws WriteException {
        SimpleDateFormat iFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (pValue == null) {
                this.iSheet.addCell(new Label(iColumn, this.iRow, "", iCellFormat));
            } else {
                this.iSheet.addCell(new Label(iColumn, this.iRow, iFormat.format(pValue), iCellFormat));
            }
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.excel.util.SSWritableExcelRow");
        sb.append("{iRow=").append(this.iRow);
        sb.append(", iSheet=").append(this.iSheet);
        sb.append('}');
        return sb.toString();
    }
}

