/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.util.frame.SSFrameManager;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntry;
import se.swedsoft.bookkeeping.importexport.sie.types.SIEDimension;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEFactory;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEFile;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEReader;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEType;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SSSIEImporter {
    private List<String> iLines;
    private SIEType iType;
    private List<SIEDimension> iDimensions;
    private SIEFactory iFactory;
    private File iFile;

    public SSSIEImporter(File iFile) {
        this.iFile = iFile;
        this.iLines = new LinkedList<String>();
        this.iDimensions = SIEDimension.getDefaultDimensions();
        this.iFactory = SIEFactory.getImportInstance();
    }

    public void doImport() throws SSImportException {
        SSDB.getInstance().dropTriggers();
        SSNewAccountingYear iAccountingYear = SSDB.getInstance().getCurrentYear();
        this.readFile(this.iFile);
        if (this.iLines.isEmpty()) {
            return;
        }
        iAccountingYear.getInBalance().clear();
        iAccountingYear.getBudget().clear();
        iAccountingYear.getAccountPlan().clear();
        for (SSVoucher sSVoucher : SSDB.getInstance().getVouchers()) {
            SSDB.getInstance().deleteVoucher(sSVoucher);
        }
        SSDB.getInstance().getVouchers().clear();
        LinkedList<SSNewProject> projectsToDelete = new LinkedList<SSNewProject>(SSDB.getInstance().getProjects());
        for (SSNewProject sSNewProject : projectsToDelete) {
            SSDB.getInstance().deleteProject(sSNewProject);
        }
        projectsToDelete = null;
        LinkedList<SSNewResultUnit> linkedList = new LinkedList<SSNewResultUnit>(SSDB.getInstance().getResultUnits());
        for (SSNewResultUnit iResultUnit : linkedList) {
            SSDB.getInstance().deleteResultUnit(iResultUnit);
        }
        Object var3_6 = null;
        List<List<String>> list = SSSIEImporter.getParsedLines(this.iLines);
        for (List<String> iEntryLines : list) {
            SIEReader iReader = new SIEReader(iEntryLines);
            String iLabel = iReader.next();
            SIEEntry iEntry = this.iFactory.get(iLabel);
            if (iEntry != null) {
                iEntry.importEntry(this, iReader, iAccountingYear);
                continue;
            }
            System.out.println("(SSSIEImporter)Missing reader for: " + iLabel);
        }
        SSDB.getInstance().updateAccountingYear(iAccountingYear);
        SSDB.getInstance().notifyListeners("YEAR", SSDB.getInstance().getCurrentYear(), null);
        this.setReaded(this.iFile);
        SSFrameManager.getInstance().close();
        SSDB.getInstance().initYear(true);
        SSDB.getInstance().createTriggers();
    }

    public void doImportVouchers() throws SSImportException {
        String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
        this.readFile(this.iFile);
        if (this.iLines.isEmpty()) {
            SSPostLock.removeLock(lockString);
            return;
        }
        List<List<String>> iParsedLines = SSSIEImporter.getParsedLines(this.iLines);
        SSNewAccountingYear iYear = SSDB.getInstance().getCurrentYear();
        for (List<String> iEntryLines : iParsedLines) {
            SIEReader iReader = new SIEReader(iEntryLines);
            String iLabel = iReader.next();
            if (!iLabel.equals("#VER")) continue;
            SIEEntry iEntry = this.iFactory.get("#VER");
            iEntry.importEntry(this, iReader, iYear);
        }
        this.setReaded(this.iFile);
    }

    private void setReaded(File pFile) {
        this.iLines.set(0, (Object)((Object)SIELabel.SIE_FLAGGA) + " 1");
        this.writeFile(pFile);
    }

    private static List<List<String>> getParsedLines(List<String> iLines) {
        LinkedList<List<String>> iParsedLines = new LinkedList<List<String>>();
        for (int iIndex = 0; iIndex < iLines.size(); ++iIndex) {
            String iNext;
            String iLine = iLines.get(iIndex);
            String string = iNext = iIndex + 1 < iLines.size() ? iLines.get(iIndex + 1) : "";
            if (iLine == null || iLine.trim().length() == 0) continue;
            LinkedList<String> iEntryLines = new LinkedList<String>();
            iEntryLines.add(iLine);
            if (iNext.equals("{")) {
                int iStart;
                for (iIndex = iStart = iIndex + 2; iIndex < iLines.size() && !(iLine = iLines.get(iIndex)).equals("}"); ++iIndex) {
                    iEntryLines.add(iLine);
                }
            }
            iParsedLines.add(iEntryLines);
        }
        return iParsedLines;
    }

    protected void readFile(File pFile) throws SSImportException {
        try {
            this.iLines = SIEFile.readFile(pFile);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw new SSImportException(ex.getMessage());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new SSImportException(ex.getMessage());
        }
    }

    private void writeFile(File pFile) throws SSExportException {
        try {
            SIEFile.writeFile(pFile, this.iLines);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw new SSExportException(ex.getMessage());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new SSExportException(ex.getMessage());
        }
    }

    public void setType(SIEType pType) {
        this.iType = pType;
    }

    public SIEType getType() {
        return this.iType;
    }

    public List<SIEDimension> getDimensions() {
        return this.iDimensions;
    }

    public SIEDimension getDimension(int pNumber) {
        return SIEDimension.getDimension(this.iDimensions, pNumber);
    }

    public void setDimensions(List<SIEDimension> pDimensions) {
        this.iDimensions = pDimensions;
    }

    public SIEFactory getFactory() {
        return this.iFactory;
    }

    public void setFactory(SIEFactory iFactory) {
        this.iFactory = iFactory;
    }

    public List<String> getLines() {
        return this.iLines;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.sie.SSSIEImporter");
        sb.append("{iDimensions=").append(this.iDimensions);
        sb.append(", iFactory=").append(this.iFactory);
        sb.append(", iFile=").append(this.iFile);
        sb.append(", iLines=").append(this.iLines);
        sb.append(", iType=").append((Object)this.iType);
        sb.append('}');
        return sb.toString();
    }
}

