/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.fields;

import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.gui.util.SSBundleString;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEExporter;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEImporter;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntry;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEReader;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEWriter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SIEEntryKonto
implements SIEEntry {
    @Override
    public boolean importEntry(SSSIEImporter iImporter, SIEReader iReader, SSNewAccountingYear iYearData) throws SSImportException {
        SSAccountPlan iAccountPlan = iYearData.getAccountPlan();
        if (!iReader.hasFields(SIEReader.SIEDataType.STRING, SIEReader.SIEDataType.INT, SIEReader.SIEDataType.STRING)) {
            throw new SSImportException(SSBundleString.getString("sieimport.fielderror", iReader.peekLine()));
        }
        SSAccount iAccount = new SSAccount();
        iAccount.setNumber(iReader.nextInteger());
        iAccount.setDescription(iReader.next());
        if (!iAccountPlan.getAccounts().contains(iAccount)) {
            iAccountPlan.addAccount(iAccount);
        }
        return true;
    }

    @Override
    public boolean exportEntry(SSSIEExporter iExporter, SIEWriter iWriter, SSNewAccountingYear iYearData) throws SSExportException {
        SSAccountPlan iAccountPlan = iYearData.getAccountPlan();
        for (SSAccount iAccount : iAccountPlan.getAccounts()) {
            iWriter.append(SIELabel.SIE_KONTO);
            iWriter.append(iAccount.getNumber());
            iWriter.append(iAccount.getDescription());
            iWriter.newLine();
        }
        return !iAccountPlan.getAccounts().isEmpty();
    }
}

