/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.fields;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.SSSaldoCalculator;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEExporter;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEImporter;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntry;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEReader;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEType;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEWriter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SIEEntryPeriodSaldo
implements SIEEntry {
    @Override
    public boolean importEntry(SSSIEImporter iImporter, SIEReader iReader, SSNewAccountingYear iYearData) throws SSImportException {
        return false;
    }

    @Override
    public boolean exportEntry(SSSIEExporter iExporter, SIEWriter iWriter, SSNewAccountingYear iCurrentYearData) throws SSExportException {
        BigDecimal iSaldo;
        Map<SSAccount, BigDecimal> iAccounts;
        Map<SSMonth, Map<SSAccount, BigDecimal>> iMonths;
        SSNewAccountingYear iPreviousYearData = SSDB.getInstance().getPreviousYear();
        List<SSNewResultUnit> iResultUnits = SSDB.getInstance().getResultUnits();
        List<SSNewProject> iProjects = SSDB.getInstance().getProjects();
        boolean iHasData = false;
        if (iPreviousYearData != null) {
            iMonths = SSSaldoCalculator.getSaldo(iPreviousYearData);
            for (Map.Entry<SSMonth, Map<SSAccount, BigDecimal>> ssMonthMapEntry1 : iMonths.entrySet()) {
                Iterator<Map.Entry<SSMonth, Map<SSAccount, BigDecimal>>> iAccounts2 = ssMonthMapEntry1.getValue();
                for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : iAccounts2.entrySet()) {
                    Iterator<Map.Entry<SSAccount, BigDecimal>> iSaldo2 = ssAccountBigDecimalEntry.getValue();
                    iWriter.append(SIELabel.SIE_PSALDO);
                    iWriter.append(-1);
                    iWriter.append(ssMonthMapEntry1.getKey());
                    iWriter.append(ssAccountBigDecimalEntry.getKey().getNumber());
                    iWriter.append("{}");
                    iWriter.append((BigDecimal)((Object)iSaldo2));
                    iWriter.newLine();
                    iHasData = true;
                }
            }
            if (iExporter.getType() == SIEType.SIE_3) {
                for (SSNewResultUnit iResultUnit : iResultUnits) {
                    iMonths = SSSaldoCalculator.getSaldo(iPreviousYearData, iResultUnit);
                    for (Map.Entry<SSMonth, Map<SSAccount, BigDecimal>> ssMonthMapEntry : iMonths.entrySet()) {
                        iAccounts = (Map<SSAccount, BigDecimal>)ssMonthMapEntry.getValue();
                        for (Map.Entry entry : iAccounts.entrySet()) {
                            iSaldo = (BigDecimal)entry.getValue();
                            iWriter.append(SIELabel.SIE_PSALDO);
                            iWriter.append(-1);
                            iWriter.append(ssMonthMapEntry.getKey());
                            iWriter.append(((SSAccount)entry.getKey()).getNumber());
                            iWriter.append(1, iResultUnit.getNumber());
                            iWriter.append(iSaldo);
                            iWriter.newLine();
                            iHasData = true;
                        }
                    }
                }
                for (SSNewProject iProject : iProjects) {
                    iMonths = SSSaldoCalculator.getSaldo(iPreviousYearData, iProject);
                    for (Map.Entry<SSMonth, Map<SSAccount, BigDecimal>> ssMonthMapEntry : iMonths.entrySet()) {
                        iAccounts = ssMonthMapEntry.getValue();
                        for (Map.Entry<SSAccount, BigDecimal> entry : iAccounts.entrySet()) {
                            iSaldo = entry.getValue();
                            iWriter.append(SIELabel.SIE_PSALDO);
                            iWriter.append(-1);
                            iWriter.append(ssMonthMapEntry.getKey());
                            iWriter.append(entry.getKey().getNumber());
                            iWriter.append(6, iProject.getNumber());
                            iWriter.append(iSaldo);
                            iWriter.newLine();
                            iHasData = true;
                        }
                    }
                }
            }
        }
        if (iCurrentYearData != null) {
            iMonths = SSSaldoCalculator.getSaldo(iCurrentYearData);
            for (Map.Entry<SSMonth, Map<SSAccount, BigDecimal>> ssMonthMapEntry1 : iMonths.entrySet()) {
                Map<SSAccount, BigDecimal> iAccounts2 = ssMonthMapEntry1.getValue();
                for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : iAccounts2.entrySet()) {
                    BigDecimal iSaldo2 = ssAccountBigDecimalEntry.getValue();
                    iWriter.append(SIELabel.SIE_PSALDO);
                    iWriter.append(0);
                    iWriter.append(ssMonthMapEntry1.getKey());
                    iWriter.append(ssAccountBigDecimalEntry.getKey().getNumber());
                    iWriter.append("{}");
                    iWriter.append(iSaldo2);
                    iWriter.newLine();
                    iHasData = true;
                }
            }
            if (iExporter.getType() == SIEType.SIE_3) {
                for (SSNewResultUnit iResultUnit : iResultUnits) {
                    iMonths = SSSaldoCalculator.getSaldo(iCurrentYearData, iResultUnit);
                    for (Map.Entry<SSMonth, Map<SSAccount, BigDecimal>> ssMonthMapEntry : iMonths.entrySet()) {
                        iAccounts = ssMonthMapEntry.getValue();
                        for (Map.Entry<SSAccount, BigDecimal> entry : iAccounts.entrySet()) {
                            iSaldo = entry.getValue();
                            iWriter.append(SIELabel.SIE_PSALDO);
                            iWriter.append(0);
                            iWriter.append(ssMonthMapEntry.getKey());
                            iWriter.append(entry.getKey().getNumber());
                            iWriter.append(1, iResultUnit.getNumber());
                            iWriter.append(iSaldo);
                            iWriter.newLine();
                            iHasData = true;
                        }
                    }
                }
                for (SSNewProject iProject : iProjects) {
                    iMonths = SSSaldoCalculator.getSaldo(iCurrentYearData, iProject);
                    for (Map.Entry<SSMonth, Map<SSAccount, BigDecimal>> ssMonthMapEntry : iMonths.entrySet()) {
                        iAccounts = ssMonthMapEntry.getValue();
                        for (Map.Entry<SSAccount, BigDecimal> entry : iAccounts.entrySet()) {
                            iSaldo = entry.getValue();
                            iWriter.append(SIELabel.SIE_PSALDO);
                            iWriter.append(0);
                            iWriter.append(ssMonthMapEntry.getKey());
                            iWriter.append(entry.getKey().getNumber());
                            iWriter.append(6, iProject.getNumber());
                            iWriter.append(iSaldo);
                            iWriter.newLine();
                            iHasData = true;
                        }
                    }
                }
            }
        }
        return iHasData;
    }
}

