/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.fields;

import java.math.BigDecimal;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.SSResultCalculator;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEExporter;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEImporter;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntry;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEReader;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEWriter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SIEEntryResult
implements SIEEntry {
    @Override
    public boolean importEntry(SSSIEImporter iImporter, SIEReader iReader, SSNewAccountingYear iYearData) throws SSImportException {
        return false;
    }

    @Override
    public boolean exportEntry(SSSIEExporter iExporter, SIEWriter iWriter, SSNewAccountingYear iYear) throws SSExportException {
        Map<SSAccount, BigDecimal> iResult;
        SSNewAccountingYear iPreviousYearData = SSDB.getInstance().getPreviousYear();
        boolean iHasData = false;
        if (iPreviousYearData != null) {
            iResult = SSResultCalculator.getResult(iPreviousYearData);
            for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : iResult.entrySet()) {
                iWriter.append(SIELabel.SIE_RES);
                iWriter.append(-1);
                iWriter.append(ssAccountBigDecimalEntry.getKey().getNumber());
                iWriter.append(ssAccountBigDecimalEntry.getValue());
                iWriter.newLine();
                iHasData = true;
            }
        }
        if (iYear != null) {
            iResult = SSResultCalculator.getResult(iYear);
            for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : iResult.entrySet()) {
                iWriter.append(SIELabel.SIE_RES);
                iWriter.append(0);
                iWriter.append(ssAccountBigDecimalEntry.getKey().getNumber());
                iWriter.append(ssAccountBigDecimalEntry.getValue());
                iWriter.newLine();
                iHasData = true;
            }
        }
        return iHasData;
    }
}

