/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.fields;

import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.gui.util.SSBundleString;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEExporter;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEImporter;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntry;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEReader;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEWriter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SIEEntrySRU
implements SIEEntry {
    @Override
    public boolean importEntry(SSSIEImporter iImporter, SIEReader iReader, SSNewAccountingYear iYearData) throws SSImportException {
        SSAccountPlan iAccountPlan = iYearData.getAccountPlan();
        String line = iReader.peekLine().toString();
        if (!iReader.hasNextInteger()) {
            throw new SSImportException(SSBundleString.getString("sieimport.fielderror", line));
        }
        int iAccountNumber = iReader.nextInteger();
        SSAccount iAccount = iAccountPlan.getAccount(iAccountNumber);
        if (!iReader.hasNext()) {
            throw new SSImportException(SSBundleString.getString("sieexport.expectedbutfound.value", line));
        }
        if (iAccount == null) {
            throw new RuntimeException("Missing account for srucode " + iAccountNumber);
        }
        iAccount.setSRUCode(iReader.next());
        return true;
    }

    @Override
    public boolean exportEntry(SSSIEExporter iExporter, SIEWriter iWriter, SSNewAccountingYear iYearData) throws SSExportException {
        SSAccountPlan iAccountPlan = iYearData.getAccountPlan();
        boolean iHasData = false;
        for (SSAccount iAccount : iAccountPlan.getAccounts()) {
            if (iAccount.getSRUCode() == null) continue;
            iWriter.append(SIELabel.SIE_SRU);
            iWriter.append(iAccount.getNumber());
            iWriter.append(iAccount.getSRUCode());
            iWriter.newLine();
            iHasData = true;
        }
        return iHasData;
    }
}

