/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.fields;

import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.gui.util.SSBundleString;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEExporter;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEImporter;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntry;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEReader;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEWriter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SIEEntryTaxar
implements SIEEntry {
    @Override
    public boolean importEntry(SSSIEImporter iImporter, SIEReader iReader, SSNewAccountingYear iCurrentYearData) throws SSImportException {
        if (!iReader.hasFields(SIEReader.SIEDataType.STRING, SIEReader.SIEDataType.INT)) {
            throw new SSImportException(SSBundleString.getString("sieimport.fielderror", iReader.peekLine()));
        }
        String iYear = iReader.nextString();
        if (iCurrentYearData != null && iCurrentYearData.getAccountPlan() != null) {
            iCurrentYearData.getAccountPlan().setAssessementYear(iYear);
            return true;
        }
        return false;
    }

    @Override
    public boolean exportEntry(SSSIEExporter iExporter, SIEWriter iWriter, SSNewAccountingYear iCurrentYearData) throws SSExportException {
        if (iCurrentYearData != null && iCurrentYearData.getAccountPlan() != null) {
            String iAssessementYear = iCurrentYearData.getAccountPlan().getAssessementYear();
            if (iAssessementYear == null) {
                throw new SSExportException(SSBundleString.getString("sieexport.noassesmentyear"));
            }
            iWriter.append(SIELabel.SIE_TAXAR);
            iWriter.append(iAssessementYear);
            iWriter.append("BFL");
            iWriter.newLine();
            return true;
        }
        return false;
    }
}

