/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.fields;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSProjectMath;
import se.swedsoft.bookkeeping.calc.math.SSResultUnitMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundleString;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEExporter;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEImporter;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntry;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEIterator;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEReader;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEWriter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SIEEntryTransaktion
implements SIEEntry {
    @Override
    public boolean importEntry(SSSIEImporter iImporter, SIEReader iReader, SSNewAccountingYear iYearData) throws SSImportException {
        throw new RuntimeException("Must be called within a voucher.");
    }

    @Override
    public boolean exportEntry(SSSIEExporter iExporter, SIEWriter iWriter, SSNewAccountingYear iCurrentYearData) throws SSExportException {
        throw new RuntimeException("Must be called within a voucher.");
    }

    private List<Object> getObjects(SSVoucherRow iVoucherRow) {
        LinkedList<Object> iObjects = new LinkedList<Object>();
        SSNewResultUnit iResultUnit = iVoucherRow.getResultUnit();
        SSNewProject iProject = iVoucherRow.getProject();
        if (iResultUnit != null) {
            iObjects.add(1);
            iObjects.add(iResultUnit.getNumber());
        }
        if (iProject != null) {
            iObjects.add(6);
            iObjects.add(iProject.getNumber());
        }
        return iObjects;
    }

    public boolean importEntry(SSVoucher iVoucher, SSSIEImporter iImporter, SIEReader iReader, SSNewAccountingYear iCurrentYearData) throws SSImportException {
        if (!iReader.hasFields(SIEReader.SIEDataType.STRING, SIEReader.SIEDataType.INT, SIEReader.SIEDataType.ARRAY, SIEReader.SIEDataType.FLOAT)) {
            throw new SSImportException(SSBundleString.getString("sieimport.fielderror", iReader.peekLine()));
        }
        int iAccountNumber = iReader.nextInteger();
        List<String> iObjects = iReader.nextArray();
        BigDecimal iAmmount = iReader.nextBigDecimal();
        SSAccount iAccount = iCurrentYearData.getAccountPlan().getAccount(iAccountNumber);
        if (iAccount == null) {
            throw new SSImportException(SSBundleString.getString("sieimport.missingaccount", Integer.toString(iAccountNumber)));
        }
        if (iObjects.size() % 2 != 0) {
            throw new SSImportException(SSBundleString.getString("sieimport.fielderror", iReader.peekLine()));
        }
        SIEIterator iObjectIterator = new SIEIterator(iObjects);
        SSNewResultUnit iResultUnit = null;
        SSNewProject iProject = null;
        while (iObjectIterator.hasNext()) {
            int iDimension = iObjectIterator.nextInteger();
            String iNum = iObjectIterator.next();
            if (iNum == null) continue;
            if (iDimension == 1) {
                iResultUnit = SSResultUnitMath.getResultUnit(iNum);
            }
            if (iDimension != 6) continue;
            iProject = SSProjectMath.getProject(SSDB.getInstance().getProjects(), iNum);
        }
        SSVoucherRow iVoucherRow = new SSVoucherRow();
        iVoucherRow.setAccount(iAccount);
        iVoucherRow.setProject(iProject);
        iVoucherRow.setResultUnit(iResultUnit);
        SSVoucherMath.setDebetMinusCredit(iVoucherRow, iAmmount);
        iVoucher.addVoucherRow(iVoucherRow);
        return true;
    }

    public boolean exportEntry(SSVoucher iVoucher, SSSIEExporter iExporter, SIEWriter iWriter) throws SSExportException {
        boolean iHasData = false;
        for (SSVoucherRow iVoucherRow : iVoucher.getRows()) {
            SSAccount iAccount = iVoucherRow.getAccount();
            if (!iVoucherRow.isValid() || iVoucherRow.isCrossed()) continue;
            iWriter.append(SIELabel.SIE_TRANS);
            iWriter.append(iAccount.getNumber());
            iWriter.append(this.getObjects(iVoucherRow));
            iWriter.append(SSVoucherMath.getDebetMinusCredit(iVoucherRow));
            iWriter.newLine();
            iHasData = true;
        }
        return iHasData;
    }
}

