/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntry;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEType;

public class SIEFactory {
    private Map<String, SIEEntry> iEntries = new HashMap<String, SIEEntry>();
    private List<SIELabel> iLabels = new LinkedList<SIELabel>();

    public static SIEFactory getImportInstance() {
        return new SIEFactory();
    }

    public static SIEFactory getExportInstance(SIEType iType) {
        return new SIEFactory(iType);
    }

    private SIEFactory() {
        for (SIELabel iLabel : SIELabel.values()) {
            this.put(iLabel, iLabel.getEntry());
        }
    }

    private SIEFactory(SIEType iType) {
        for (SIELabel iLabel : SIELabel.values(iType)) {
            this.put(iLabel, iLabel.getEntry());
        }
    }

    public SIEEntry get(String pLabel) {
        return this.iEntries.get(pLabel);
    }

    public SIEEntry get(SIELabel pLabel) {
        return this.iEntries.get(pLabel.getName());
    }

    public void put(SIELabel pLabel) {
        this.iLabels.add(pLabel);
        this.iEntries.put(pLabel.getName(), pLabel.getEntry());
    }

    public void put(SIELabel pLabel, SIEEntry pField) {
        this.iLabels.add(pLabel);
        this.iEntries.put(pLabel.getName(), pField);
    }

    public List<SIELabel> getLabels() {
        return this.iLabels;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SIEFactory {\n");
        for (SIELabel iLabel : this.iLabels) {
            SIEEntry iEntry = this.get(iLabel);
            sb.append("  ");
            sb.append((Object)iLabel);
            sb.append(" = ");
            sb.append(iEntry == null ? "null" : iEntry.getClass().getName());
            sb.append('\n');
        }
        sb.append('}');
        return sb.toString();
    }
}

