/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.swedsoft.bookkeeping.data.SSMonth;

public class SIEIterator
implements Iterator<String> {
    private static DateFormat iFormat = DateFormat.getDateInstance(3);
    private static Pattern IntegerPattern = Pattern.compile("([-+]?[0-9]*)+");
    private static Pattern FloatPattern = Pattern.compile("([-+]?[0-9]*.?[0-9]*)+");
    private static Pattern BooleanPattern = Pattern.compile("true|false");
    private static Pattern ArrayPattern = Pattern.compile("[{](.*)[}]");
    private List<String> iValues;
    private int iIndex = -1;

    public SIEIterator(String pLine) {
        this.iValues = this.parseLine(pLine);
    }

    public SIEIterator(String ... pValues) {
        this.iValues = new LinkedList<String>();
        this.iValues.addAll(Arrays.asList(pValues));
    }

    public SIEIterator(List<String> pValues) {
        this.iValues = pValues;
    }

    @Override
    public boolean hasNext() {
        return this.iIndex + 1 < this.iValues.size();
    }

    @Override
    public String next() {
        if (this.iIndex + 1 >= this.iValues.size()) {
            throw new NoSuchElementException();
        }
        ++this.iIndex;
        return this.iValues.get(this.iIndex);
    }

    public String peek() {
        if (this.iIndex >= this.iValues.size()) {
            return null;
        }
        return this.iValues.get(this.iIndex + 1);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean hasNext(Pattern pPattern) {
        String iNext = this.peek();
        if (iNext == null || iNext.length() == 0) {
            return false;
        }
        Matcher m = pPattern.matcher(iNext);
        return m.matches();
    }

    public boolean hasNextArray() {
        return this.hasNext(ArrayPattern);
    }

    public boolean hasNextInteger() {
        return this.hasNext(IntegerPattern);
    }

    public boolean hasNextFloat() {
        return this.hasNext(FloatPattern);
    }

    public boolean hasNextDouble() {
        return this.hasNext(FloatPattern);
    }

    public boolean hasNextBoolean() {
        return this.hasNext(BooleanPattern);
    }

    public boolean hasNextBigInteger() {
        return this.hasNext(IntegerPattern);
    }

    public boolean hasNextBigDecimal() {
        return this.hasNext(FloatPattern);
    }

    public boolean hasNextDate() {
        return this.hasNext(IntegerPattern);
    }

    public boolean hasNextMonth() {
        return this.hasNext(IntegerPattern);
    }

    public List<String> nextArray() {
        String pLine = this.next();
        LinkedList<String> iObjects = new LinkedList<String>();
        for (int iIndex = 0; iIndex < pLine.length(); ++iIndex) {
            int iStart;
            char c = pLine.charAt(iIndex);
            if (this.isOpenArray(c) || this.isCloseArray(c) || this.isWhitespace(c)) continue;
            for (iIndex = iStart = iIndex; iIndex < pLine.length() && !this.isWhitespace(c = pLine.charAt(iIndex)) && !this.isCloseArray(c); ++iIndex) {
            }
            String iString = pLine.substring(iStart, iIndex);
            if (iString.length() <= 0) continue;
            iObjects.add(iString);
        }
        return iObjects;
    }

    public Integer nextInteger() {
        String s = this.next();
        try {
            Integer iNumber = null;
            if (s.length() > 0) {
                iNumber = new Integer(s);
            }
            return iNumber;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Float nextFloat() {
        Double iValue = this.nextDouble();
        return new Float(iValue);
    }

    public boolean nextBoolean() {
        String s = this.next();
        return s.equals("true");
    }

    public BigInteger nextBigInteger() {
        String s = this.next();
        return new BigInteger(s);
    }

    public BigDecimal nextBigDecimal() {
        Double iValue = this.nextDouble();
        return new BigDecimal(iValue);
    }

    public Double nextDouble() {
        String iValue = this.next();
        return Double.parseDouble(iValue);
    }

    public Date nextDate() {
        String iValue = this.next();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (iValue != null && iValue.length() == 8) {
            iValue = iValue.substring(0, 4) + '-' + iValue.substring(4, 6) + '-' + iValue.substring(6, 8);
            try {
                return formatter.parse(iValue);
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
        }
        return new Date();
    }

    public SSMonth nextMonth() {
        String iValue = this.next();
        if (iValue != null && iValue.length() == 6) {
            iValue = iValue.substring(0, 4) + '-' + iValue.substring(4, 6) + "-01";
            try {
                return new SSMonth(iFormat.parse(iValue));
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
        }
        return new SSMonth(new Date());
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    private boolean isString(char c) {
        return c == '\"';
    }

    private boolean isOpenArray(char c) {
        return c == '{';
    }

    private boolean isCloseArray(char c) {
        return c == '}';
    }

    private List<String> parseLine(String pLine) {
        LinkedList<String> iValues = new LinkedList<String>();
        for (int iIndex = 0; iIndex < pLine.length(); ++iIndex) {
            String iString;
            int iStart;
            char c = pLine.charAt(iIndex);
            if (this.isWhitespace(c)) continue;
            if (this.isString(c)) {
                for (iIndex = iStart = iIndex + 1; iIndex < pLine.length() && !this.isString(c = pLine.charAt(iIndex)); ++iIndex) {
                }
                iString = pLine.substring(iStart, iIndex);
                iValues.add(iString.trim());
                continue;
            }
            if (this.isOpenArray(c)) {
                iStart = iIndex + 1;
                int iLevel = 1;
                for (iIndex = iStart; iIndex < pLine.length(); ++iIndex) {
                    c = pLine.charAt(iIndex);
                    if (this.isOpenArray(c)) {
                        ++iLevel;
                    }
                    if (this.isCloseArray(c)) {
                        --iLevel;
                    }
                    if (iLevel == 0) break;
                }
                String iString2 = pLine.substring(iStart, iIndex);
                iValues.add('{' + iString2.trim() + '}');
                continue;
            }
            for (iIndex = iStart = iIndex; iIndex < pLine.length() && !this.isWhitespace(c = pLine.charAt(iIndex)); ++iIndex) {
            }
            iString = pLine.substring(iStart, iIndex);
            iValues.add(iString.trim());
        }
        return iValues;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SIEIterator {\n");
        for (String iValue : this.iValues) {
            sb.append("  ");
            sb.append(iValue);
            sb.append('\n');
        }
        sb.append('}');
        return sb.toString();
    }
}

