/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEIterator;

public class SIEReader
implements Iterator<String> {
    private List<String> iLines;
    private int iIndex;
    private SIEIterator iValues;

    public SIEReader() {
        this.iLines = new LinkedList<String>();
        this.iIndex = 0;
        this.iValues = null;
    }

    public SIEReader(String pLine) {
        this.iLines = new ArrayList<String>(1);
        this.iValues = null;
        this.iLines.add(pLine);
        this.reset();
    }

    public SIEReader(List<String> pLines) {
        this.iLines = pLines;
        this.reset();
    }

    private void reset() {
        this.iIndex = 0;
        if (this.iLines.isEmpty()) {
            return;
        }
        String iLine = this.iLines.get(0);
        this.iValues = new SIEIterator(iLine);
    }

    public boolean hasNextLine() {
        return this.iIndex + 1 < this.iLines.size();
    }

    public String nextLine() {
        ++this.iIndex;
        if (this.iIndex >= this.iLines.size()) {
            throw new NoSuchElementException();
        }
        String iLine = this.iLines.get(this.iIndex);
        this.iValues = new SIEIterator(iLine);
        return iLine;
    }

    public String peekLine() {
        if (this.iIndex >= this.iLines.size()) {
            throw new NoSuchElementException();
        }
        return this.iLines.get(this.iIndex);
    }

    @Override
    public boolean hasNext() {
        return this.iValues.hasNext();
    }

    @Override
    public String next() {
        return this.iValues.next();
    }

    public String peek() {
        return this.iValues.peek();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasFields(SIEDataType ... pDataTypes) {
        SIEIterator iIterator = new SIEIterator(this.peekLine());
        for (SIEDataType iDataType : pDataTypes) {
            boolean hasNext = iIterator.hasNext();
            boolean hasNextInteger = iIterator.hasNextInteger();
            boolean hasNextFloat = iIterator.hasNextFloat();
            boolean hasNextBoolean = iIterator.hasNextBoolean();
            boolean hasNextArray = iIterator.hasNextArray();
            if (iDataType == SIEDataType.STRING && !hasNext) {
                return false;
            }
            if (iDataType == SIEDataType.INT && !hasNextInteger) {
                return false;
            }
            if (iDataType == SIEDataType.FLOAT && !hasNextFloat) {
                return false;
            }
            if (iDataType == SIEDataType.BOOLEAN && !hasNextBoolean) {
                return false;
            }
            if (iDataType == SIEDataType.ARRAY && !hasNextArray) {
                return false;
            }
            iIterator.next();
        }
        return true;
    }

    public boolean hasNextString() {
        return this.iValues.hasNext();
    }

    public boolean hasNextInteger() {
        return this.iValues.hasNextInteger();
    }

    public boolean hasNextFloat() {
        return this.iValues.hasNextFloat();
    }

    public boolean hasNextDouble() {
        return this.iValues.hasNextDouble();
    }

    public boolean hasNextBoolean() {
        return this.iValues.hasNextBoolean();
    }

    public boolean hasNextBigInteger() {
        return this.iValues.hasNextBigInteger();
    }

    public boolean hasNextBigDecimal() {
        return this.iValues.hasNextBigDecimal();
    }

    public boolean hasNextArray() {
        return this.iValues.hasNextArray();
    }

    public boolean hasNextDate() {
        return this.iValues.hasNextDate();
    }

    public boolean hasNextMonth() {
        return this.iValues.hasNextMonth();
    }

    public String nextString() {
        return this.iValues.next();
    }

    public Integer nextInteger() {
        return this.iValues.nextInteger();
    }

    public Float nextFloat() {
        return this.iValues.nextFloat();
    }

    public Double nextDouble() {
        return this.iValues.nextDouble();
    }

    public boolean nextBoolean() {
        return this.iValues.nextBoolean();
    }

    public BigInteger nextBigInteger() {
        return this.iValues.nextBigInteger();
    }

    public BigDecimal nextBigDecimal() {
        return this.iValues.nextBigDecimal();
    }

    public List<String> nextArray() {
        return this.iValues.nextArray();
    }

    public Date nextDate() {
        return this.iValues.nextDate();
    }

    public SSMonth nextMonth() {
        return this.iValues.nextMonth();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SIEReader {\n");
        for (String iLine : this.iLines) {
            SIEIterator iIterator = new SIEIterator(iLine);
            sb.append("  ");
            sb.append(iIterator);
            sb.append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    public static enum SIEDataType {
        STRING,
        INT,
        FLOAT,
        BOOLEAN,
        ARRAY;

    }
}

