/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.supplierpayments.poster;

import java.math.BigDecimal;
import java.util.Date;
import se.swedsoft.bookkeeping.importexport.supplierpayments.data.SupplierPayment;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPost;
import se.swedsoft.bookkeeping.importexport.supplierpayments.util.LBinLine;

public class LBinPostTK14
extends LBinPost {
    private String iNumber;
    private String iReference;
    private BigDecimal iValue;
    private Date iDate;
    private Integer iInvoiceNr;

    public LBinPostTK14() {
    }

    public LBinPostTK14(SupplierPayment iPayment, String iNumber) {
        this.iNumber = iNumber.replaceAll("-", "");
        this.iReference = iPayment.getReference();
        this.iValue = iPayment.getValue();
        this.iDate = iPayment.getDate();
        this.iInvoiceNr = iPayment.getNumber();
    }

    @Override
    public void write(LBinLine iLine) {
        iLine.append("14");
        iLine.append(this.iNumber, 10, '0');
        iLine.append(this.iReference, 25);
        iLine.append(this.iValue, 12);
        iLine.append(this.iDate, 6, "yyMMdd");
        iLine.append("", 5);
        iLine.append(this.iInvoiceNr, 20);
    }

    @Override
    public void read(LBinLine iLine) {
        this.iNumber = iLine.readString(3, 12);
        this.iReference = iLine.readString(13, 37);
        this.iValue = iLine.readBigDecimal(38, 49);
        this.iInvoiceNr = iLine.readInteger(61, 80);
    }

    public String getNumber() {
        return this.iNumber;
    }

    public void setNumber(String iNumber) {
        this.iNumber = iNumber;
    }

    public String getReference() {
        return this.iReference;
    }

    public void setReference(String iReference) {
        this.iReference = iReference;
    }

    public BigDecimal getValue() {
        return this.iValue;
    }

    public void setValue(BigDecimal iValue) {
        this.iValue = iValue;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
    }

    public Integer getInvoiceNr() {
        return this.iInvoiceNr;
    }

    public void setInvoiceNr(Integer iInvoiceNr) {
        this.iInvoiceNr = iInvoiceNr;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK14");
        sb.append("{iDate=").append(this.iDate);
        sb.append(", iInvoiceNr=").append(this.iInvoiceNr);
        sb.append(", iNumber='").append(this.iNumber).append('\'');
        sb.append(", iReference='").append(this.iReference).append('\'');
        sb.append(", iValue=").append(this.iValue);
        sb.append('}');
        return sb.toString();
    }
}

