/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.supplierpayments.poster;

import se.swedsoft.bookkeeping.data.SSAddress;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.importexport.supplierpayments.data.SupplierPayment;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPost;
import se.swedsoft.bookkeeping.importexport.supplierpayments.util.LBinLine;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;

public class LBinPostTK27
extends LBinPost {
    private Integer iOutpaymentNumber;
    private String iAddress1;
    private String iZipCode;
    private String iCity;

    public LBinPostTK27() {
    }

    public LBinPostTK27(SupplierPayment iPayment) {
        SSAddress iAddress = iPayment.getAddress();
        this.iOutpaymentNumber = iPayment.getOutpaymentNumber();
        this.iAddress1 = iAddress.getAddress1();
        this.iZipCode = iAddress.getZipCode();
        this.iCity = iAddress.getCity();
        if (this.iAddress1 == null || this.iZipCode == null || this.iCity == null) {
            throw new SSExportException(SSBundle.getBundle(), "supplierpaymentframe.error.supplieraddress", iPayment.getSupplier().getName());
        }
        this.iZipCode = this.iZipCode.replace(" ", "");
    }

    @Override
    public void write(LBinLine iLine) {
        iLine.append("27");
        iLine.append("0000", 4, '0');
        iLine.append(this.iOutpaymentNumber, 5);
        iLine.append(" ");
        iLine.append(this.iAddress1.toUpperCase(), 35);
        iLine.append(this.iZipCode.toUpperCase(), 5);
        iLine.append(this.iCity.toUpperCase(), 20);
        iLine.append("", 8);
    }

    @Override
    public void read(LBinLine iLine) {
        this.iOutpaymentNumber = iLine.readInteger(3, 11);
        this.iAddress1 = iLine.readString(13, 47);
        this.iZipCode = iLine.readString(48, 52);
        this.iCity = iLine.readString(53, 72);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK27");
        sb.append("{iAddress1='").append(this.iAddress1).append('\'');
        sb.append(", iCity='").append(this.iCity).append('\'');
        sb.append(", iOutpaymentNumber=").append(this.iOutpaymentNumber);
        sb.append(", iZipCode='").append(this.iZipCode).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

