/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.supplierpayments.poster;

import se.swedsoft.bookkeeping.importexport.supplierpayments.data.SupplierPayment;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPost;
import se.swedsoft.bookkeeping.importexport.supplierpayments.util.LBinLine;

public class LBinPostTK40
extends LBinPost {
    private String iNumber;
    private String iClearing;
    private String iKonto;
    private String iReference;
    private String iLon;

    public LBinPostTK40() {
    }

    public LBinPostTK40(SupplierPayment iPayment) {
        this.iNumber = this.iNumber.replaceAll("-", "");
        this.iKonto = iPayment.getKonto().replaceAll("-", "").replaceAll(" ", "").substring(4);
        this.iClearing = iPayment.getKonto().replaceAll("-", "").replaceAll(" ", "").substring(0, 4);
        this.iReference = iPayment.getReference();
        this.iLon = " ";
    }

    @Override
    public void write(LBinLine iLine) {
        iLine.append("40");
        iLine.append(48, 4);
        iLine.append(this.iNumber, 6, '0');
        iLine.append(this.iClearing, 4);
        iLine.append(this.iKonto, 12, '0');
        iLine.append(this.iReference, 12);
        iLine.append(this.iLon, 1);
        iLine.append("", 39);
    }

    @Override
    public void read(LBinLine iLine) {
        this.iNumber = iLine.readString(7, 12);
        this.iClearing = iLine.readString(13, 16);
        this.iKonto = iLine.readString(17, 28);
        this.iReference = iLine.readString(29, 40);
        this.iLon = iLine.readString(41, 41);
    }

    public String getNumber() {
        return this.iNumber;
    }

    public void setNumber(String iNumber) {
        this.iNumber = iNumber;
    }

    public String getClearing() {
        return this.iClearing;
    }

    public void setClearing(String iClearing) {
        this.iClearing = iClearing;
    }

    public String getKonto() {
        return this.iKonto;
    }

    public void setKonto(String iKonto) {
        this.iKonto = iKonto;
    }

    public String getReference() {
        return this.iReference;
    }

    public void setReference(String iReference) {
        this.iReference = iReference;
    }

    public String getLon() {
        return this.iLon;
    }

    public void setLon(String iLon) {
        this.iLon = iLon;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK40");
        sb.append(", iNumber='").append(this.iNumber).append('\'');
        sb.append(", iClearing=").append(this.iClearing).append('\'');
        sb.append(", iKonto='").append(this.iKonto).append('\'');
        sb.append(", iReference='").append(this.iReference).append('\'');
        sb.append(", iLon=").append(this.iLon);
        sb.append('}');
        return sb.toString();
    }
}

