/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.supplierpayments.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LBinLine {
    private char[] iChars;
    private int iPosition;

    public LBinLine(int iLength) {
        this.iChars = new char[iLength];
        this.iPosition = 0;
    }

    public LBinLine(char[] iChars) {
        this.iChars = iChars;
        this.iPosition = 0;
    }

    public LBinLine(String iLine) {
        this(iLine.length());
        iLine.getChars(0, iLine.length(), this.iChars, 0);
    }

    public void reset() {
        this.iPosition = 0;
    }

    public int getPosition() {
        return this.iPosition;
    }

    public int getLength() {
        return this.iChars.length;
    }

    public int append(String iString) {
        if (iString == null) {
            return this.iPosition;
        }
        for (int i = 0; i < iString.length(); ++i) {
            this.iChars[this.iPosition] = iString.charAt(i);
            ++this.iPosition;
        }
        return this.iPosition;
    }

    public int append(String iString, int iLength, char iBlank) {
        int i;
        if (iString == null) {
            iString = "";
        }
        for (i = iString.length(); i < iLength; ++i) {
            iString = iBlank + iString;
        }
        for (i = 0; i < iLength; ++i) {
            this.iChars[this.iPosition] = iString.charAt(i);
            ++this.iPosition;
        }
        return this.iPosition;
    }

    public int append(String iString, int iLength) {
        return this.append(iString, iLength, ' ');
    }

    public int append(Date iDate, int iLength, String iFormat) {
        SimpleDateFormat iDateFormat = new SimpleDateFormat(iFormat);
        return this.append(iDateFormat.format(iDate), iLength, ' ');
    }

    public int append(BigDecimal iValue, int iLength) {
        String iText = Long.toString(Math.round(iValue.doubleValue() * 100.0));
        return this.append(iText, iLength, '0');
    }

    public int append(int iValue, int iLength) {
        String iText = Integer.toString(iValue);
        return this.append(iText, iLength, '0');
    }

    public String readString(int iStart) {
        return String.valueOf(this.iChars[iStart - 1]);
    }

    public String readString(int iStart, int iEnd) {
        String iField = "";
        for (int i = iStart; i <= iEnd; ++i) {
            if (i - 1 >= this.iChars.length) continue;
            iField = iField + this.iChars[i - 1];
        }
        return iField.trim();
    }

    public Date readDate(int iStart, int iEnd, String iFormat) {
        SimpleDateFormat iDateFormat = new SimpleDateFormat(iFormat);
        String iValue = this.readString(iStart, iEnd);
        try {
            return iDateFormat.parse(iValue);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public BigDecimal readBigDecimal(int iStart, int iEnd) {
        String iText = this.readString(iStart, iEnd);
        try {
            Long iValue = Long.valueOf(iText, 10);
            return new BigDecimal((double)iValue.longValue() / 100.0);
        }
        catch (NumberFormatException e) {
            return new BigDecimal(0);
        }
    }

    public Integer readInteger(int iStart, int iEnd) {
        String iValue = this.readString(iStart, iEnd);
        try {
            return new Integer(iValue);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String toString() {
        return new String(this.iChars);
    }
}

